/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.util.io.ASCII85Constants;
import org.apache.xmlgraphics.util.io.Finalizable;

public class ASCII85OutputStream
extends FilterOutputStream
implements ASCII85Constants,
Finalizable {
    private static final boolean DEBUG = false;
    private int pos = 0;
    private long buffer = 0L;
    private int posinline = 0;
    private int bw = 0;

    public ASCII85OutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        this.buffer = this.pos == 0 ? (this.buffer += (long)(n << 24) & 0xFF000000L) : (this.pos == 1 ? (this.buffer += (long)(n << 16) & 0xFF0000L) : (this.pos == 2 ? (this.buffer += (long)(n << 8) & 0xFF00L) : (this.buffer += (long)n & 0xFFL)));
        ++this.pos;
        if (this.pos > 3) {
            this.checkedWrite(this.convertWord(this.buffer));
            this.buffer = 0L;
            this.pos = 0;
        }
    }

    private void checkedWrite(byte[] byArray) throws IOException {
        this.checkedWrite(byArray, byArray.length, false);
    }

    private void checkedWrite(byte[] byArray, boolean bl) throws IOException {
        this.checkedWrite(byArray, byArray.length, bl);
    }

    private void checkedWrite(byte[] byArray, int n) throws IOException {
        this.checkedWrite(byArray, n, false);
    }

    private void checkedWrite(byte[] byArray, int n, boolean bl) throws IOException {
        if (this.posinline + n > 80) {
            int n2;
            int n3 = n2 = bl ? 0 : n - (this.posinline + n - 80);
            if (n2 > 0) {
                this.out.write(byArray, 0, n2);
            }
            this.out.write(10);
            ++this.bw;
            int n4 = n - n2;
            if (n4 > 0) {
                this.out.write(byArray, n2, n4);
            }
            this.posinline = n4;
        } else {
            this.out.write(byArray, 0, n);
            this.posinline += n;
        }
        this.bw += n;
    }

    private byte[] convertWord(long l) {
        if ((l &= 0xFFFFFFFFFFFFFFFFL) == 0L) {
            return ZERO_ARRAY;
        }
        if (l < 0L) {
            l = -l;
        }
        byte by = (byte)(l / POW85[0] & 0xFFL);
        byte by2 = (byte)((l - (long)by * POW85[0]) / POW85[1] & 0xFFL);
        byte by3 = (byte)((l - (long)by * POW85[0] - (long)by2 * POW85[1]) / POW85[2] & 0xFFL);
        byte by4 = (byte)((l - (long)by * POW85[0] - (long)by2 * POW85[1] - (long)by3 * POW85[2]) / POW85[3] & 0xFFL);
        byte by5 = (byte)(l - (long)by * POW85[0] - (long)by2 * POW85[1] - (long)by3 * POW85[2] - (long)by4 * POW85[3] & 0xFFL);
        byte[] byArray = new byte[]{(byte)(by + 33), (byte)(by2 + 33), (byte)(by3 + 33), (byte)(by4 + 33), (byte)(by5 + 33)};
        return byArray;
    }

    public void finalizeStream() throws IOException {
        if (this.pos > 0) {
            byte[] byArray;
            int n = this.pos;
            if (this.buffer != 0L) {
                byArray = this.convertWord(this.buffer);
            } else {
                byArray = new byte[5];
                for (int i = 0; i < 5; ++i) {
                    byArray[i] = 33;
                }
            }
            this.checkedWrite(byArray, n + 1);
        }
        this.checkedWrite(EOD, true);
        this.flush();
        if (this.out instanceof Finalizable) {
            ((Finalizable)((Object)this.out)).finalizeStream();
        }
    }

    public void close() throws IOException {
        this.finalizeStream();
        super.close();
    }
}

