/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.util.XMLizable;
import org.apache.xmlgraphics.xmp.PropertyAccess;
import org.apache.xmlgraphics.xmp.XMPArray;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPComplexValue;
import org.apache.xmlgraphics.xmp.XMPConstants;
import org.apache.xmlgraphics.xmp.XMPSchema;
import org.apache.xmlgraphics.xmp.XMPSchemaRegistry;
import org.apache.xmlgraphics.xmp.XMPStructure;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMPProperty
implements XMLizable {
    private QName name;
    private Object value;
    private String xmllang;
    private Map qualifiers;
    private boolean uri;

    public XMPProperty(QName qName, Object object) {
        this.name = qName;
        this.value = object;
        this.uri = false;
    }

    public QName getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.getName().getNamespaceURI();
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Object getValue() {
        return this.value;
    }

    public void setXMLLang(String string) {
        this.xmllang = string;
    }

    public String getXMLLang() {
        return this.xmllang;
    }

    public boolean isArray() {
        return this.value instanceof XMPArray;
    }

    public XMPArray getArrayValue() {
        return this.isArray() ? (XMPArray)this.value : null;
    }

    public XMPArray convertSimpleValueToArray(XMPArrayType xMPArrayType) {
        if (this.getArrayValue() == null) {
            XMPArray xMPArray = new XMPArray(xMPArrayType);
            if (this.getXMLLang() != null) {
                xMPArray.add(this.getValue().toString(), this.getXMLLang());
            } else {
                xMPArray.add(this.getValue());
            }
            this.setValue(xMPArray);
            this.setXMLLang(null);
            return xMPArray;
        }
        return this.getArrayValue();
    }

    public PropertyAccess getStructureValue() {
        return this.value instanceof XMPStructure ? (XMPStructure)this.value : null;
    }

    private boolean hasPropertyQualifiers() {
        return this.qualifiers == null || this.qualifiers.size() == 0;
    }

    public boolean isQualifiedProperty() {
        PropertyAccess propertyAccess = this.getStructureValue();
        if (propertyAccess != null) {
            XMPProperty xMPProperty = propertyAccess.getValueProperty();
            return xMPProperty != null;
        }
        return this.hasPropertyQualifiers();
    }

    public void simplify() {
        XMPProperty xMPProperty;
        PropertyAccess propertyAccess = this.getStructureValue();
        if (propertyAccess != null && (xMPProperty = propertyAccess.getValueProperty()) != null) {
            if (this.hasPropertyQualifiers()) {
                throw new IllegalStateException("Illegal internal state (qualifiers present on non-simplified property)");
            }
            XMPProperty xMPProperty2 = new XMPProperty(this.getName(), xMPProperty);
            Iterator iterator = propertyAccess.iterator();
            while (iterator.hasNext()) {
                QName qName = (QName)iterator.next();
                if (XMPConstants.RDF_VALUE.equals(qName)) continue;
                xMPProperty2.setPropertyQualifier(qName, propertyAccess.getProperty(qName));
            }
        }
    }

    private void setPropertyQualifier(QName qName, XMPProperty xMPProperty) {
        if (this.qualifiers == null) {
            this.qualifiers = new HashMap();
        }
        this.qualifiers.put(qName, xMPProperty);
    }

    private String getEffectiveQName() {
        String string = this.getName().getPrefix();
        if (string == null || "".equals(string)) {
            XMPSchema xMPSchema = XMPSchemaRegistry.getInstance().getSchema(this.getNamespace());
            string = xMPSchema.getPreferredPrefix();
        }
        return string + ":" + this.getName().getLocalName();
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        String string = this.getEffectiveQName();
        if (this.value instanceof URI) {
            attributesImpl.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", "rdf:resource", "CDATA", ((URI)this.value).toString());
        }
        contentHandler.startElement(this.getName().getNamespaceURI(), this.getName().getLocalName(), string, attributesImpl);
        if (this.value instanceof XMPComplexValue) {
            XMPComplexValue xMPComplexValue = (XMPComplexValue)this.value;
            xMPComplexValue.toSAX(contentHandler);
        } else if (!(this.value instanceof URI)) {
            char[] cArray = this.value.toString().toCharArray();
            contentHandler.characters(cArray, 0, cArray.length);
        }
        contentHandler.endElement(this.getName().getNamespaceURI(), this.getName().getLocalName(), string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("XMP Property ");
        stringBuffer.append(this.getName()).append(": ");
        stringBuffer.append(this.getValue());
        return stringBuffer.toString();
    }
}

