/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.collection.SoftCache;
import com.sun.jini.jeri.internal.http.ServerInfo;
import com.sun.jini.jeri.internal.http.TimedMap;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;

public class HttpClientManager {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private final SoftCache rolodex = new SoftCache();
    private final TimedMap unsentAcks;

    public HttpClientManager(long l) {
        this.unsentAcks = new TimedMap(systemThreadPool, l);
    }

    public void clearServerInfo() {
        this.rolodex.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnsentAcks(String string, int n, String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        TimedMap timedMap = this.unsentAcks;
        synchronized (timedMap) {
            ServerKey serverKey = new ServerKey(string, n);
            HashSet<String> hashSet = (HashSet<String>)this.unsentAcks.get(serverKey);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                this.unsentAcks.put(serverKey, hashSet);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearUnsentAcks(String string, int n, String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        TimedMap timedMap = this.unsentAcks;
        synchronized (timedMap) {
            ServerKey serverKey = new ServerKey(string, n);
            Set set = (Set)this.unsentAcks.get(serverKey);
            if (set == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                set.remove(stringArray[i]);
            }
            if (set.isEmpty()) {
                this.unsentAcks.remove(serverKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getUnsentAcks(String string, int n) {
        TimedMap timedMap = this.unsentAcks;
        synchronized (timedMap) {
            Set set = (Set)this.unsentAcks.get(new ServerKey(string, n));
            return set != null ? set.toArray(new String[set.size()]) : new String[]{};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerInfo getServerInfo(String string, int n) {
        ServerKey serverKey = new ServerKey(string, n);
        SoftCache softCache = this.rolodex;
        synchronized (softCache) {
            ServerInfo serverInfo = (ServerInfo)this.rolodex.get(serverKey);
            return serverInfo != null ? (ServerInfo)serverInfo.clone() : new ServerInfo(string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheServerInfo(ServerInfo serverInfo) {
        if (serverInfo.timestamp == -1L) {
            return;
        }
        ServerKey serverKey = new ServerKey(serverInfo.host, serverInfo.port);
        SoftCache softCache = this.rolodex;
        synchronized (softCache) {
            ServerInfo serverInfo2 = (ServerInfo)this.rolodex.get(serverKey);
            if (serverInfo2 == null || serverInfo.timestamp > serverInfo2.timestamp) {
                this.rolodex.put(serverKey, serverInfo.clone());
            }
        }
    }

    private static class ServerKey {
        private final String host;
        private final int port;
        private final int hash;

        ServerKey(String string, int n) {
            this.host = string;
            this.port = n;
            this.hash = string.hashCode() << 10 | n & 0x3FF;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof ServerKey) {
                ServerKey serverKey = (ServerKey)object;
                return this.host.equals(serverKey.host) && this.port == serverKey.port;
            }
            return false;
        }
    }
}

