/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import com.sun.jini.proxy.MarshalledWrapper;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.jini.core.event.RemoteEvent;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.LookupUnmarshalException;
import net.jini.io.MarshalledInstance;

public class RemoteDiscoveryEvent
extends RemoteEvent {
    private static final long serialVersionUID = -9171289945014585248L;
    protected boolean discarded;
    protected ArrayList marshalledRegs;
    protected ServiceRegistrar[] regs;
    protected Map groups;
    private transient boolean integrity;

    public RemoteDiscoveryEvent(Object object, long l, long l2, MarshalledObject marshalledObject, boolean bl, Map map) throws IOException {
        super(object, l, l2, marshalledObject);
        this.discarded = bl;
        if (map != null) {
            int n;
            if (map.size() == 0) {
                throw new IllegalArgumentException("empty input map");
            }
            ServiceRegistrar[] serviceRegistrarArray = map.keySet().toArray(new ServiceRegistrar[map.size()]);
            for (n = 0; n < serviceRegistrarArray.length; ++n) {
                if (serviceRegistrarArray[n] != null) continue;
                throw new NullPointerException("null element (" + n + ") in input map");
            }
            this.groups = new HashMap(map.size());
            this.marshalledRegs = new ArrayList(map.size());
            for (n = 0; n < serviceRegistrarArray.length; ++n) {
                try {
                    this.marshalledRegs.add(new MarshalledObject<ServiceRegistrar>(serviceRegistrarArray[n]));
                    this.groups.put(serviceRegistrarArray[n].getServiceID(), map.get(serviceRegistrarArray[n]));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.marshalledRegs.isEmpty()) {
                throw new IOException("failed to serialize any of the " + serviceRegistrarArray.length + " elements");
            }
        } else {
            throw new NullPointerException("null input map");
        }
        this.regs = new ServiceRegistrar[this.marshalledRegs.size()];
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar[] getRegistrars() throws LookupUnmarshalException {
        ArrayList arrayList = this.marshalledRegs;
        synchronized (arrayList) {
            if (this.marshalledRegs.size() > 0) {
                ArrayList arrayList2 = new ArrayList();
                ArrayList arrayList3 = this.unmarshalRegistrars(this.marshalledRegs, arrayList2);
                RemoteDiscoveryEvent.insertRegistrars(this.regs, arrayList2);
                if (arrayList3.size() > 0) {
                    throw new LookupUnmarshalException(RemoteDiscoveryEvent.clipNullsFromEnd(this.regs), this.marshalledRegs.toArray(new MarshalledObject[this.marshalledRegs.size()]), arrayList3.toArray(new Throwable[arrayList3.size()]), "failed to unmarshal at least one ServiceRegistrar");
                }
            }
            return RemoteDiscoveryEvent.clipNullsFromEnd(this.regs);
        }
    }

    public Map getGroups() {
        return this.groups;
    }

    private ArrayList unmarshalRegistrars(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<Throwable> arrayList3 = new ArrayList<Throwable>();
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            MarshalledObject marshalledObject = (MarshalledObject)arrayList.get(n);
            MarshalledInstance marshalledInstance = new MarshalledInstance(marshalledObject);
            try {
                ServiceRegistrar serviceRegistrar = (ServiceRegistrar)marshalledInstance.get(this.integrity);
                arrayList2.add(serviceRegistrar);
                arrayList.remove(n);
                continue;
            }
            catch (Throwable throwable) {
                arrayList3.add(throwable);
                ++n;
            }
        }
        return arrayList3;
    }

    private static void insertRegistrars(ServiceRegistrar[] serviceRegistrarArray, ArrayList arrayList) {
        if (serviceRegistrarArray != null && arrayList != null) {
            int n = serviceRegistrarArray.length;
            int n2 = arrayList.size();
            if (n == 0 || n2 == 0) {
                return;
            }
            int n3 = RemoteDiscoveryEvent.indexFirstNull(serviceRegistrarArray);
            int n4 = n3 + n2 <= n ? n3 + n2 : n;
            int n5 = n3;
            int n6 = 0;
            while (n5 < n4) {
                serviceRegistrarArray[n5] = (ServiceRegistrar)arrayList.get(n6);
                ++n5;
                ++n6;
            }
        }
    }

    private static ServiceRegistrar[] clipNullsFromEnd(ServiceRegistrar[] serviceRegistrarArray) {
        if (serviceRegistrarArray == null) {
            return new ServiceRegistrar[0];
        }
        int n = RemoteDiscoveryEvent.indexFirstNull(serviceRegistrarArray);
        ServiceRegistrar[] serviceRegistrarArray2 = new ServiceRegistrar[n];
        for (int i = 0; i < n; ++i) {
            serviceRegistrarArray2[i] = serviceRegistrarArray[i];
        }
        return serviceRegistrarArray2;
    }

    private static int indexFirstNull(Object[] objectArray) {
        int n = -1;
        if (objectArray == null || objectArray.length == 0) {
            return n;
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] != null) continue;
            return n;
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.source == null) {
            throw new InvalidObjectException("RemoteDiscoveryEvent.readObject failure - source field is null");
        }
        this.integrity = MarshalledWrapper.integrityEnforced(objectInputStream);
    }
}

