/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.jeri.internal.http.ConnectionTimer;
import com.sun.jini.jeri.internal.http.HttpServerConnection;
import com.sun.jini.jeri.internal.http.HttpServerManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;
import net.jini.jeri.ssl.HttpsEndpoint;
import net.jini.jeri.ssl.SslServerEndpointImpl;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.Security;

public final class HttpsServerEndpoint
implements ServerEndpoint {
    static final Logger logger = Utilities.serverLogger;
    private static final long ACK_TIMEOUT = (Long)Security.doPrivileged(new GetLongAction("com.sun.jini.jeri.https.responseAckTimeout", 15000L));
    static final HttpServerManager httpServerManager = new HttpServerManager(ACK_TIMEOUT);
    private static final long IDLE_TIMEOUT = (Long)Security.doPrivileged(new GetLongAction("com.sun.jini.jeri.https.idleServerConnectionTimeout", HttpsEndpoint.IDLE_TIMEOUT + 30000L));
    static final ConnectionTimer connectionTimer = new ConnectionTimer(IDLE_TIMEOUT);
    private final HttpsServerEndpointImpl impl;
    static /* synthetic */ Class class$net$jini$jeri$ssl$HttpsServerEndpoint$HttpsServerEndpointImpl$HttpsListenHandle;
    static /* synthetic */ Class class$net$jini$jeri$ssl$HttpsServerEndpoint$HttpsServerEndpointImpl$HttpsRequestDispatcher;

    public static HttpsServerEndpoint getInstance(int n) {
        return new HttpsServerEndpoint(null, null, null, n, null, null);
    }

    public static HttpsServerEndpoint getInstance(String string, int n) {
        return new HttpsServerEndpoint(null, null, string, n, null, null);
    }

    public static HttpsServerEndpoint getInstance(String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        return new HttpsServerEndpoint(null, null, string, n, socketFactory, serverSocketFactory);
    }

    public static HttpsServerEndpoint getInstance(Subject subject, X500Principal[] x500PrincipalArray, String string, int n) {
        return new HttpsServerEndpoint(subject, x500PrincipalArray, string, n, null, null);
    }

    public static HttpsServerEndpoint getInstance(Subject subject, X500Principal[] x500PrincipalArray, String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        return new HttpsServerEndpoint(subject, x500PrincipalArray, string, n, socketFactory, serverSocketFactory);
    }

    private HttpsServerEndpoint(Subject subject, X500Principal[] x500PrincipalArray, String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        this.impl = new HttpsServerEndpointImpl(this, subject, x500PrincipalArray, string, n, socketFactory, serverSocketFactory);
        logger.log(Level.FINE, "created {0}", this);
    }

    public String getHost() {
        return this.impl.serverHost;
    }

    public int getPort() {
        return this.impl.port;
    }

    public Set getPrincipals() {
        return this.impl.serverPrincipals == null ? null : Collections.unmodifiableSet(this.impl.serverPrincipals);
    }

    public SocketFactory getSocketFactory() {
        return this.impl.socketFactory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.impl.serverSocketFactory;
    }

    public String toString() {
        return "HttpsServerEndpoint" + this.impl.fieldsToString();
    }

    public InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        return this.impl.checkConstraints(invocationConstraints);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof HttpsServerEndpoint && this.impl.equals(((HttpsServerEndpoint)object).impl);
    }

    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        return this.impl.enumerateListenEndpoints(listenContext);
    }

    private static final class HttpsServerEndpointImpl
    extends SslServerEndpointImpl {
        HttpsServerEndpointImpl(ServerEndpoint serverEndpoint, Subject subject, X500Principal[] x500PrincipalArray, String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
            super(serverEndpoint, subject, x500PrincipalArray, string, n, socketFactory, serverSocketFactory);
        }

        ServerEndpoint.ListenEndpoint createListenEndpoint() {
            return new HttpsListenEndpoint();
        }

        Endpoint createEndpoint(String string, SslServerEndpointImpl.SslListenCookie sslListenCookie) {
            return HttpsEndpoint.getInstance(string, sslListenCookie.getPort(), this.socketFactory);
        }

        private final class HttpsServerConnection
        extends SslServerEndpointImpl.SslServerConnection {
            HttpServer httpServer;

            HttpsServerConnection(HttpsListenHandle httpsListenHandle, Socket socket) throws IOException {
                super(HttpsServerEndpointImpl.this, httpsListenHandle, socket);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void closeInternal(boolean bl) throws IOException {
                HttpsServerConnection httpsServerConnection = this;
                synchronized (httpsServerConnection) {
                    if (this.closed) {
                        return;
                    }
                }
                super.closeInternal(bl);
                if (this.httpServer != null) {
                    this.httpServer.shutdown(true);
                    this.httpServer = null;
                }
            }
        }

        private static final class HttpsInboundRequest
        implements InboundRequest {
            private final InboundRequest request;
            private final ServerConnection connection;
            private final InboundRequestHandle handle;

            HttpsInboundRequest(InboundRequest inboundRequest, ServerConnection serverConnection, InboundRequestHandle inboundRequestHandle) {
                this.request = inboundRequest;
                this.connection = serverConnection;
                this.handle = inboundRequestHandle;
            }

            public void checkPermissions() {
                this.connection.checkPermissions(this.handle);
            }

            public InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
                return this.connection.checkConstraints(this.handle, invocationConstraints);
            }

            public void populateContext(Collection collection) {
                this.request.populateContext(collection);
                this.connection.populateContext(this.handle, collection);
            }

            public InputStream getRequestInputStream() {
                return this.request.getRequestInputStream();
            }

            public OutputStream getResponseOutputStream() {
                return this.request.getResponseOutputStream();
            }

            public void abort() {
                this.request.abort();
            }
        }

        private static final class HttpsRequestDispatcher
        extends Utilities
        implements RequestDispatcher {
            private final RequestDispatcher requestDispatcher;
            private final HttpsServerConnection connection;

            HttpsRequestDispatcher(RequestDispatcher requestDispatcher, HttpsServerConnection httpsServerConnection) {
                this.requestDispatcher = requestDispatcher;
                this.connection = httpsServerConnection;
            }

            public void dispatch(InboundRequest inboundRequest) {
                block2: {
                    try {
                        HttpsInboundRequest httpsInboundRequest = new HttpsInboundRequest(inboundRequest, this.connection, this.connection.processRequestData(inboundRequest.getRequestInputStream(), inboundRequest.getResponseOutputStream()));
                        httpsInboundRequest.checkPermissions();
                        this.requestDispatcher.dispatch(httpsInboundRequest);
                    }
                    catch (SecurityException securityException) {
                        if (!SslServerEndpointImpl.logger.isLoggable(Level.INFO)) break block2;
                        HttpsRequestDispatcher.logThrow(SslServerEndpointImpl.logger, Level.INFO, class$net$jini$jeri$ssl$HttpsServerEndpoint$HttpsServerEndpointImpl$HttpsRequestDispatcher == null ? (class$net$jini$jeri$ssl$HttpsServerEndpoint$HttpsServerEndpointImpl$HttpsRequestDispatcher = HttpsServerEndpoint.class$("net.jini.jeri.ssl.HttpsServerEndpoint$HttpsServerEndpointImpl$HttpsRequestDispatcher")) : class$net$jini$jeri$ssl$HttpsServerEndpoint$HttpsServerEndpointImpl$HttpsRequestDispatcher, "dispatch", "{0} throws", new Object[]{this.connection}, securityException);
                    }
                }
            }
        }

        private static final class HttpServer
        extends HttpServerConnection {
            private final HttpsServerConnection connection;

            HttpServer(Socket socket, RequestDispatcher requestDispatcher, HttpsServerConnection httpsServerConnection) throws IOException {
                super(socket, requestDispatcher, httpServerManager);
                this.connection = httpsServerConnection;
                httpsServerConnection.httpServer = this;
                this.start();
            }

            protected void checkPermissions() {
                throw new AssertionError();
            }

            protected void populateContext(Collection collection) {
            }

            protected InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) {
                throw new AssertionError();
            }

            protected void idle() {
                connectionTimer.scheduleTimeout(this, false);
            }

            protected void busy() {
                connectionTimer.cancelTimeout(this);
            }

            public boolean shutdown(boolean bl) {
                boolean bl2 = super.shutdown(bl);
                if (bl2) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                connectionTimer.cancelTimeout(this);
                return bl2;
            }
        }

        private final class HttpsListenHandle
        extends SslServerEndpointImpl.SslListenHandle {
            HttpsListenHandle(RequestDispatcher requestDispatcher, ServerSocket serverSocket) throws IOException {
                super(HttpsServerEndpointImpl.this, requestDispatcher, serverSocket);
            }

            SslServerEndpointImpl.SslServerConnection serverConnection(Socket socket) throws IOException {
                return new HttpsServerConnection(this, socket);
            }

            void handleConnection(SslServerEndpointImpl.SslServerConnection sslServerConnection, RequestDispatcher requestDispatcher) {
                try {
                    new HttpServer((Socket)sslServerConnection.sslSocket, (RequestDispatcher)new HttpsRequestDispatcher(requestDispatcher, (HttpsServerConnection)sslServerConnection), (HttpsServerConnection)sslServerConnection);
                }
                catch (IOException iOException) {
                    if (SslServerEndpointImpl.logger.isLoggable(Level.INFO)) {
                        HttpsListenHandle.logThrow(SslServerEndpointImpl.logger, Level.INFO, class$net$jini$jeri$ssl$HttpsServerEndpoint$HttpsServerEndpointImpl$HttpsListenHandle == null ? (class$net$jini$jeri$ssl$HttpsServerEndpoint$HttpsServerEndpointImpl$HttpsListenHandle = HttpsServerEndpoint.class$("net.jini.jeri.ssl.HttpsServerEndpoint$HttpsServerEndpointImpl$HttpsListenHandle")) : class$net$jini$jeri$ssl$HttpsServerEndpoint$HttpsServerEndpointImpl$HttpsListenHandle, "handleConnection", "{0} throws", new Object[]{sslServerConnection}, iOException);
                    }
                    try {
                        sslServerConnection.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
        }

        private final class HttpsListenEndpoint
        extends SslServerEndpointImpl.SslListenEndpoint {
            private HttpsListenEndpoint() {
                super(HttpsServerEndpointImpl.this);
            }

            ServerEndpoint.ListenHandle createListenHandle(RequestDispatcher requestDispatcher, ServerSocket serverSocket) throws IOException {
                return new HttpsListenHandle(requestDispatcher, serverSocket);
            }
        }
    }
}

