/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.SharedMemory;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.logging.Logger;

public class MemoryImageProducer
implements ImageProducer {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private SharedMemory b;
    private ImageConsumer c;
    private final Rectangle d = new Rectangle();
    private final ColorModel e = ColorModel.getRGBdefault();

    public void resetMemory(SharedMemory sharedMemory) {
        this.b = sharedMemory;
        this.d.width = sharedMemory.getWidth();
        this.d.height = sharedMemory.getHeight();
    }

    public int getWidth() {
        return this.d.width;
    }

    public int getHeight() {
        return this.d.height;
    }

    public boolean isInitialized() {
        return this.b != null;
    }

    public double getDeviceScaleFactor() {
        if (this.b != null) {
            return this.b.getDeviceScaleFactor();
        }
        return 1.0;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return false;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.c = imageConsumer;
        this.c.setDimensions(this.getWidth(), this.getHeight());
        this.c.setColorModel(this.e);
        this.updatePixels(this.d);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void updatePixels(Rectangle ... rectangleArray) {
        if (this.c != null && this.b != null) {
            for (Rectangle rectangle : rectangleArray) {
                int[] nArray = this.b.readPixels(rectangle, 4);
                if (nArray != null) {
                    this.c.setDimensions(this.getWidth(), this.getHeight());
                    this.c.setColorModel(this.e);
                    this.c.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.e, nArray, 0, rectangle.width);
                    this.c.imageComplete(2);
                    continue;
                }
                a.info("Failed to read pixels from shared memory.");
            }
        }
    }
}

