/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.svg12.ContentSelectionChangedEvent;
import org.apache.batik.bridge.svg12.SVG12BridgeUpdateHandler;
import org.apache.batik.dom.svg12.BindableElement;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class BindableElementBridge
extends AbstractGraphicsNodeBridge
implements SVG12BridgeUpdateHandler {
    @Override
    public String getNamespaceURI() {
        return "*";
    }

    @Override
    public String getLocalName() {
        return "*";
    }

    @Override
    public Bridge getInstance() {
        return new BindableElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = this.buildCompositeGraphicsNode(bridgeContext, element, null);
        return compositeGraphicsNode;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        ScriptingEnvironment scriptingEnvironment;
        BindableElement bindableElement = (BindableElement)element;
        Element element2 = bindableElement.getXblShadowTree();
        UpdateManager updateManager = bridgeContext.getUpdateManager();
        ScriptingEnvironment scriptingEnvironment2 = scriptingEnvironment = updateManager == null ? null : updateManager.getScriptingEnvironment();
        if (scriptingEnvironment != null && element2 != null) {
            scriptingEnvironment.addScriptingListeners(element2);
        }
        if (compositeGraphicsNode == null) {
            compositeGraphicsNode = new CompositeGraphicsNode();
            this.associateSVGContext(bridgeContext, element, (GraphicsNode)compositeGraphicsNode);
        } else {
            int n = compositeGraphicsNode.size();
            for (int i = 0; i < n; ++i) {
                compositeGraphicsNode.remove(0);
            }
        }
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        if (element2 != null) {
            GraphicsNode graphicsNode = gVTBuilder.build(bridgeContext, element2);
            if (graphicsNode != null) {
                compositeGraphicsNode.add((Object)graphicsNode);
            }
        } else {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                GraphicsNode graphicsNode;
                if (node.getNodeType() != 1 || (graphicsNode = gVTBuilder.build(bridgeContext, (Element)node)) == null) continue;
                compositeGraphicsNode.add((Object)graphicsNode);
            }
        }
        return compositeGraphicsNode;
    }

    @Override
    public void dispose() {
        BindableElement bindableElement = (BindableElement)this.e;
        if (bindableElement != null && bindableElement.getCSSFirstChild() != null) {
            BindableElementBridge.disposeTree(bindableElement.getCSSFirstChild());
        }
        super.dispose();
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        BindableElement bindableElement = (BindableElement)this.e;
        Element element = bindableElement.getXblShadowTree();
        if (element == null && mutationEvent.getTarget() instanceof Element) {
            this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)mutationEvent.getTarget()));
        }
    }

    @Override
    public void handleBindingEvent(Element element, Element element2) {
        CompositeGraphicsNode compositeGraphicsNode = this.node.getParent();
        compositeGraphicsNode.remove((Object)this.node);
        BindableElementBridge.disposeTree(this.e);
        this.handleElementAdded(compositeGraphicsNode, this.e.getParentNode(), this.e);
    }

    @Override
    public void handleContentSelectionChangedEvent(ContentSelectionChangedEvent contentSelectionChangedEvent) {
    }

    protected void handleElementAdded(CompositeGraphicsNode compositeGraphicsNode, Node node, Element element) {
        GVTBuilder gVTBuilder = this.ctx.getGVTBuilder();
        GraphicsNode graphicsNode = gVTBuilder.build(this.ctx, element);
        if (graphicsNode == null) {
            return;
        }
        int n = -1;
        for (Node node2 = element.getPreviousSibling(); node2 != null; node2 = node2.getPreviousSibling()) {
            GraphicsNode graphicsNode2;
            if (node2.getNodeType() != 1) continue;
            Element element2 = (Element)node2;
            for (graphicsNode2 = this.ctx.getGraphicsNode(element2); graphicsNode2 != null && graphicsNode2.getParent() != compositeGraphicsNode; graphicsNode2 = graphicsNode2.getParent()) {
            }
            if (graphicsNode2 != null && (n = compositeGraphicsNode.indexOf((Object)graphicsNode2)) != -1) break;
        }
        compositeGraphicsNode.add(++n, (Object)graphicsNode);
    }
}

