/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.debug.Debug;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;

public class Defs {
    public static final Object NOT_FOUND = new Object();
    public static final Object NO_SYNCHRONIZATION = null;
    public static final String EMPTY_STRING = "";
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static Object[] newObjectArray(int n) {
        return n != 0 ? new Object[n] : EMPTY_OBJECT_ARRAY;
    }

    public static String property(String string) {
        return Defs.property(string, null);
    }

    public static String property(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            Defs.EMPTY_BYTE_ARRAY(securityException, "Failed to get property");
            return string2;
        }
    }

    public static int intProperty(String string, int n) {
        String string2 = Defs.property(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Defs.EMPTY_BYTE_ARRAY(numberFormatException, "Failed to parse property");
            }
        }
        return n;
    }

    public static boolean booleanProperty(String string) {
        return Defs.booleanProperty(string, false);
    }

    public static boolean booleanProperty(String string, boolean bl) {
        String string2 = Defs.sysProperty(string);
        if (string2 != null) {
            switch (string2.length()) {
                case 2: {
                    if (!"no".equals(string2)) break;
                    return false;
                }
                case 3: {
                    if (!"yes".equals(string2)) break;
                    return true;
                }
                case 4: {
                    if (!"true".equals(string2)) break;
                    return true;
                }
                case 5: {
                    if (!"false".equals(string2)) break;
                    return false;
                }
            }
        }
        return bl;
    }

    public static String sysProperty(String string) {
        return Defs.property(string);
    }

    public static String sysProperty(String string, String string2) {
        return Defs.property(string, string2);
    }

    public static int sysPropertyInt(String string, int n) {
        return Defs.intProperty(string, n);
    }

    public static boolean sysPropertyBoolean(String string) {
        return Defs.booleanProperty(string);
    }

    public static boolean sysPropertyBoolean(String string, boolean bl) {
        return Defs.booleanProperty(string, bl);
    }

    public static void setProperty(String string, String string2) {
        try {
            Properties properties = System.getProperties();
            if (string2 == null) {
                ((Hashtable)properties).remove(string);
            } else {
                ((Hashtable)properties).put(string, string2);
            }
        }
        catch (SecurityException securityException) {
            Defs.EMPTY_BYTE_ARRAY(securityException, "Failed to set system property");
        }
    }

    public static void setSystemProperty(String string, String string2) {
        Defs.setProperty(string, string2);
    }

    public static Class getClass(String string) {
        Exception exception;
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        Defs.EMPTY_BYTE_ARRAY(exception, "Failed to get class");
        return null;
    }

    public static Object newClassInstance(Class clazz) {
        Throwable throwable;
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        Defs.EMPTY_BYTE_ARRAY(throwable, "Failed to get instance of class");
        return null;
    }

    public static Object newClassInstance(String string) {
        Class clazz = Defs.getClass(string);
        return clazz == null ? null : Defs.newClassInstance(clazz);
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) {
        Exception exception;
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        Defs.EMPTY_BYTE_ARRAY(exception, "Failed to get method");
        return null;
    }

    public static Method getMethod(String string, String string2, Class[] classArray) {
        Class clazz = Defs.getClass(string);
        if (clazz != null) {
            return Defs.getMethod(clazz, string2, classArray);
        }
        return null;
    }

    public static void badArg() throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    private static void EMPTY_BYTE_ARRAY(Throwable throwable, String string) {
        Debug.trace(string + ": " + throwable.getMessage());
    }
}

