/*
 * Decompiled with CFR 0.152.
 */
package ice.util.encoding;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.encoding.ReaderLatin1;
import ice.util.encoding.ReaderUTF8;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.text.BreakIterator;
import java.util.Locale;

public class CharIO {
    public static final int DEFAULT_DECODING_BUFFER_SIZE = 4096;
    public static final String ENC_UTF8 = "UTF8";
    public static final String ENC_ISO8859_1 = "ISO8859_1";
    private static final String EMPTY_BYTE_ARRAY = CharIO.EMPTY_BYTE_ARRAY();
    private static final Object OEAB = new Object();
    private static HashArray Z;
    private static HashArray append;
    public static final int CHARSET_DEFAULT = 0;
    public static final int CHARSET_WINDOWS_1255 = 1;
    public static final int CHARSET_VISUAL = 2;
    public static final int CHARSET_ISO8859_8 = 3;

    private static String EMPTY_BYTE_ARRAY() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Defs.EMPTY_BYTE_ARRAY);
        String string = new InputStreamReader(byteArrayInputStream).getEncoding();
        string = CharIO.OEAB(string, true);
        return string;
    }

    public static String getDefaultEncoding() {
        return EMPTY_BYTE_ARRAY;
    }

    private static String OEAB(String string, boolean bl) {
        String string2 = null;
        String string3 = ENC_ISO8859_1;
        int n = string.length();
        switch (n) {
            case 4: {
                string2 = ENC_UTF8;
                string3 = ENC_UTF8;
                break;
            }
            case 5: {
                char c = string.charAt(0);
                if (c == 'A' || c == 'a') {
                    string2 = "ASCII";
                    break;
                }
                if (c != 'U' && c != 'u') break;
                string2 = "UTF_8";
                string3 = ENC_UTF8;
                break;
            }
            case 6: {
                char c = string.charAt(0);
                if (c == '8') {
                    string2 = "8859_1";
                    break;
                }
                if (c != 'L' && c != 'l') break;
                string2 = "LATIN1";
                break;
            }
            case 7: {
                char c = string.charAt(0);
                if (c == 'L' || c == 'l') {
                    string2 = "LATIN_1";
                    break;
                }
                if (c != 'U' && c != 'u') break;
                string2 = "UNICODE";
                string3 = ENC_UTF8;
                break;
            }
            case 8: {
                string2 = "US_ASCII";
                break;
            }
            case 9: {
                string2 = ENC_ISO8859_1;
                break;
            }
            case 10: {
                string2 = "ISO_8859_1";
            }
        }
        if (string2 != null && CharIO.bug(string, string2, n)) {
            return string3;
        }
        if (!bl) {
            if (n == EMPTY_BYTE_ARRAY.length() && CharIO.bug(string, EMPTY_BYTE_ARRAY, n)) {
                return EMPTY_BYTE_ARRAY;
            }
            String string4 = CharIO.charAt(string);
            String string5 = (String)CharIO.append().get(string4);
            if (string5 != null) {
                return string5;
            }
        }
        return string;
    }

    private static void Z(HashArray hashArray) {
        hashArray.put("X-SJIS", (Object)"SJIS");
        hashArray.put("SHIFT-JIS", (Object)"SJIS");
        hashArray.put("SHIFT_JIS", (Object)"SJIS");
        hashArray.put("ISO-2022-JP", (Object)"ISO2022JP");
        hashArray.put("VISUAL", (Object)"ISO8859_8");
        hashArray.put("ISO-8859-8 VISUAL", (Object)"ISO8859_8");
        hashArray.put("MACINTOSH", (Object)"MacRoman");
    }

    private static HashArray append() {
        HashArray hashArray = Z;
        if (hashArray == null) {
            Object object = OEAB;
            synchronized (object) {
                hashArray = Z;
                if (hashArray == null) {
                    hashArray = new HashArray(OEAB);
                    CharIO.Z(hashArray);
                    Z = hashArray;
                }
            }
        }
        return hashArray;
    }

    public static void addEncodingAlias(String string, String string2) {
        CharIO.append().put(CharIO.charAt(string), (Object)string2);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean bug(String var0, String var1_1, int var2_2) {
        if (var0 != var1_1) ** GOTO lbl16
        return true;
lbl-1000:
        // 1 sources

        {
            if ((var3_3 = var0.charAt(--var2_2)) == 45) {
                var3_3 = 95;
            } else if (97 <= var3_3 && var3_3 <= 122) {
                var3_3 -= 32;
            }
            var4_4 = var1_1.charAt(var2_2);
            if (var4_4 == 45) {
                var4_4 = 95;
            } else if (97 <= var4_4 && var4_4 <= 122) {
                var4_4 -= 32;
            }
            if (var3_3 == var4_4) continue;
            return false;
lbl16:
            // 2 sources

            ** while (var2_2 != 0)
        }
lbl17:
        // 1 sources

        return true;
    }

    private static String charAt(String string) {
        return string.toUpperCase();
    }

    public static Reader createInputStreamReader(InputStream inputStream, String string) {
        return CharIO.createInputStreamReader(inputStream, string, false);
    }

    public static Reader createInputStreamReader(InputStream inputStream, String string, boolean bl) {
        String string2 = string == null ? EMPTY_BYTE_ARRAY : CharIO.OEAB(string, false);
        Reader reader = CharIO.equals(inputStream, string2);
        if (reader == null) {
            block9: {
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
                    string2 = inputStreamReader.getEncoding();
                    reader = inputStreamReader;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (Debug.ex) {
                        Debug.ex(unsupportedEncodingException);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (!Debug.ex) break block9;
                    Debug.ex(runtimeException);
                }
            }
            if (reader == null) {
                if (!bl) {
                    reader = null;
                } else {
                    string2 = EMPTY_BYTE_ARRAY;
                    reader = CharIO.equals(inputStream, EMPTY_BYTE_ARRAY);
                }
            }
        }
        if (Debug.trace && reader != null) {
            Debug.trace("Given encoding=(" + string + ") Java name=(" + string2 + ")");
        }
        return reader;
    }

    private static Reader equals(InputStream inputStream, String string) {
        Reader reader;
        if (string == ENC_UTF8) {
            ReaderUTF8 readerUTF8 = new ReaderUTF8(inputStream, 4096);
            readerUTF8.setThrowOnBadUTF8(false);
            reader = readerUTF8;
        } else if (string == ENC_ISO8859_1) {
            ReaderLatin1 readerLatin1 = new ReaderLatin1(inputStream, 4096);
            readerLatin1.setWin1252Mode();
            reader = readerLatin1;
        } else {
            reader = string == EMPTY_BYTE_ARRAY ? new InputStreamReader(inputStream) : null;
        }
        return reader;
    }

    public static Reader createURLReader(URLConnection uRLConnection) throws IOException {
        String string = uRLConnection.getContentEncoding();
        InputStream inputStream = uRLConnection.getInputStream();
        if (inputStream != null) {
            return CharIO.createInputStreamReader(inputStream, string, true);
        }
        if (Debug.trace) {
            Debug.trace("ALERT: " + uRLConnection.getClass().getName() + ".getInputStream() returns null for " + uRLConnection.getURL() + ". Check it is OK.");
        }
        throw new EOFException();
    }

    public static BreakIterator getBreakIterator(Locale locale) {
        String string = locale.getLanguage();
        if (string.equals("zh") || string.equals("iw") || string.equals("ko") || string.equals("ja") || string.equals("th") || string.equals("tr")) {
            return BreakIterator.getWordInstance(locale);
        }
        return null;
    }

    private static void equalsIgnoreCase(HashArray hashArray) {
        hashArray.put("Big5", (Object)"zh");
        hashArray.put("EUC_CN", (Object)"zh");
        hashArray.put("EUC_TW", (Object)"zh");
        hashArray.put("GBK", (Object)"zh");
        hashArray.put("ISO2022CN", (Object)"zh");
        hashArray.put("ISO2022CN_CNS", (Object)"zh");
        hashArray.put("ISO2022CN_GB", (Object)"zh");
        hashArray.put("EUC_CN", (Object)"zh");
        hashArray.put("ISO8859_8", (Object)"iw");
        hashArray.put("Cp1255", (Object)"iw");
        hashArray.put("EUC_KR", (Object)"ko");
        hashArray.put("Johab", (Object)"ko");
        hashArray.put("ISO2022KR", (Object)"ko");
        hashArray.put("EUC_JP", (Object)"ja");
        hashArray.put("ISO2022JP", (Object)"ja");
        hashArray.put("JISAutoDetect", (Object)"ja");
        hashArray.put("SJIS", (Object)"ja");
        hashArray.put("TIS620", (Object)"th");
        hashArray.put("Cp857", (Object)"tr");
        hashArray.put("Cp1254", (Object)"tr");
        hashArray.put("ISO8859_9", (Object)"tr");
        hashArray.put("MacTurkish", (Object)"tr");
    }

    private static HashArray ex() {
        HashArray hashArray = append;
        if (hashArray == null) {
            Object object = OEAB;
            synchronized (object) {
                hashArray = append;
                if (hashArray == null) {
                    hashArray = new HashArray(OEAB);
                    CharIO.equalsIgnoreCase(hashArray);
                    append = hashArray;
                }
            }
        }
        return hashArray;
    }

    public static String getEncodingLanguage(String string) {
        String string2 = null;
        if ((string = CharIO.OEAB(string, false)) != ENC_ISO8859_1 && string != ENC_UTF8) {
            string2 = (String)CharIO.ex().get(string);
        }
        return string2;
    }

    public static Locale getEncodingLocale(String string) {
        String string2 = CharIO.getEncodingLanguage(string);
        return string2 != null ? new Locale(string2, "", "") : null;
    }

    public static int getCharsetId(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("windows-1255")) {
            n = 1;
        } else if (string.equalsIgnoreCase("visual")) {
            n = 2;
        } else if (string.equalsIgnoreCase("iso-8859-8") || string.equalsIgnoreCase("ISO8859_8")) {
            n = 3;
        }
        return n;
    }

    public static String utf8ToStr(byte[] byArray, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        int n3 = n + n2;
        int n4 = 0;
        boolean bl = true;
        while (n != n3) {
            int n5;
            if ((n5 = byArray[n++]) < 0) {
                int n6;
                int n7;
                if ((0xC0 & n5) != 192) {
                    bl = false;
                    break;
                }
                if ((0x20 & n5) == 0) {
                    n7 = 1;
                    n5 &= 0x1F;
                    n6 = 128;
                } else if ((0x10 & n5) == 0) {
                    n7 = 2;
                    n5 &= 0xF;
                    n6 = 2048;
                } else if ((8 & n5) == 0) {
                    n7 = 3;
                    n5 &= 7;
                    n6 = 65536;
                } else if ((4 & n5) == 0) {
                    n7 = 4;
                    n5 &= 3;
                    n6 = 0x200000;
                } else if ((2 & n5) == 0) {
                    n7 = 5;
                    n5 &= 1;
                    n6 = 0x4000000;
                } else {
                    bl = false;
                    break;
                }
                if (n + n7 > n3) {
                    bl = false;
                    break;
                }
                do {
                    byte by;
                    if (((by = byArray[n++]) & 0xC0) != 128) {
                        bl = false;
                        break;
                    }
                    n5 = n5 << 6 | 0x3F & by;
                } while (--n7 != 0);
                if (n5 < n6) {
                    bl = false;
                    break;
                }
                if (n5 > 65535) {
                    bl = false;
                    break;
                }
            }
            cArray[n4++] = (char)n5;
        }
        if (!bl) {
            throw new IOException("Bad UTF-8 bytes");
        }
        return new String(cArray, 0, n4);
    }

    public static byte[] strToUTF8(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = n;
        int n3 = 0;
        while (n3 != n) {
            char c = cArray[n3];
            if ((c & 0xFFFFFF80) != 0) {
                ++n2;
                if ((c & 0xFFFFF800) != 0) {
                    ++n2;
                }
            }
            ++n3;
        }
        byte[] byArray = new byte[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 != n) {
            int n6 = cArray[n5];
            if ((n6 & 0xFFFFFF80) != 0) {
                if ((n6 & 0xFFFFF800) == 0) {
                    byArray[n4++] = (byte)(0xC0 | n6 >>> 6);
                } else {
                    byArray[n4++] = (byte)(0xE0 | n6 >>> 12);
                    byArray[n4++] = (byte)(0x80 | n6 >>> 6 & 0x3F);
                }
                n6 = 0x80 | n6 & 0x3F;
            }
            byArray[n4++] = (byte)n6;
            ++n5;
        }
        if (n4 != n2) {
            Debug.bug();
        }
        return byArray;
    }

    public static int mapWin1252_128_159_toUnicode(int n) {
        String string = "\u20ac\u0081\u201a\u0192\u201e\u2026\u2020\u2021\u02c6\u2030\u0160\u2039\u0152\u008d\u017d\u008f\u0090\u2018\u2019\u201c\u201d\u2022\u2013\u2014\u02dc\u2122\u0161\u203a\u0153\u009d\u017e\u0178";
        return string.charAt(n - 128);
    }
}

