/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.security.BoxedCode;
import java.net.URL;

public abstract class SecurityKit {
    private static final SecurityKit OEAB = SecurityKit.OEAB();

    private static SecurityKit OEAB() {
        SecurityKit securityKit = null;
        String string = Defs.sysProperty("ice.util.security.SecurityKit");
        if (string != null && (securityKit = (SecurityKit)Defs.newClassInstance(string)) == null && Debug.trace) {
            Debug.trace("FAILED TO LOAD REQUESTED SecurityKit: " + string);
        }
        if (securityKit == null) {
            String[] stringArray = new String[]{"ice.util.security.jdk12.SecurityKit_jdk12", "ice.util.security.pjava12.SecurityKit_pjava12", "ice.util.security.jdk11.SecurityKit_jdk11"};
            int n = 0;
            while (n != stringArray.length) {
                string = stringArray[n];
                securityKit = (SecurityKit)Defs.newClassInstance(string);
                if (securityKit != null) break;
                ++n;
            }
        }
        if (Debug.trace) {
            Debug.trace(securityKit != null ? string : "FAILED!");
        }
        return securityKit;
    }

    public static void installDefaultSecurityManager() {
        block4: {
            OEAB.installDefaultSecurityManagerImpl();
            if (Debug.trace) {
                try {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (Debug.trace) {
                        Debug.trace(securityManager == null ? "null" : securityManager.getClass().getName());
                    }
                }
                catch (SecurityException securityException) {
                    if (!Debug.ex) break block4;
                    Debug.ex(securityException);
                }
            }
        }
    }

    public static ClassLoader newURLClassLoader(URL[] uRLArray) {
        return OEAB.newURLClassLoaderImpl(uRLArray);
    }

    public static Object doPrivileged(BoxedCode boxedCode) {
        return OEAB.doPrivilegedImpl(boxedCode);
    }

    public static Object doUntrusted(BoxedCode boxedCode) {
        return OEAB.doUntrustedImpl(boxedCode);
    }

    public static boolean usesJava2Security() {
        return OEAB.usesJava2SecurityImpl();
    }

    public static boolean is_working_doUntrusted() {
        return OEAB.is_working_doUntrustedImpl();
    }

    protected abstract void installDefaultSecurityManagerImpl();

    protected abstract ClassLoader newURLClassLoaderImpl(URL[] var1);

    protected abstract Object doPrivilegedImpl(BoxedCode var1);

    protected abstract Object doUntrustedImpl(BoxedCode var1);

    protected boolean usesJava2SecurityImpl() {
        return true;
    }

    protected boolean is_working_doUntrustedImpl() {
        return true;
    }
}

