/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class DocSetItemProperties {
    private static final String DOCCENTER_PROP_FILE_NAME = "doccenter.properties";
    private final String fHelpDirName;
    private final Properties fProperties;

    public DocSetItemProperties(File file) {
        this.fProperties = DocSetItemProperties.readPropertiesFile(file);
        this.fHelpDirName = file.getParentFile().getName();
    }

    public DocSetItemProperties(File file, String string) throws IOException {
        this(DocSetItemProperties.getDocCenterPropertiesFile(file, string));
    }

    private static File getDocCenterPropertiesFile(File file, String string) {
        File file2 = new File(file, string);
        return new File(file2, DOCCENTER_PROP_FILE_NAME);
    }

    public String getShortName() {
        return this.fProperties.getProperty(Property.SHORT_NAME.getKey(), this.fHelpDirName);
    }

    public String getDisplayName() {
        return this.fProperties.getProperty(Property.DISPLAY_NAME.getKey(), "");
    }

    public String getLegalName() {
        return this.fProperties.getProperty(Property.LEGAL_NAME.getKey(), this.getDisplayName());
    }

    public String getBaseProductShortName() {
        return this.fProperties.getProperty(Property.BASE_PRODUCT_SHORTNAME.getKey(), "");
    }

    public String getPathFromDocRoot() {
        return this.fProperties.getProperty(Property.PATH_FROM_DOCROOT.getKey(), "");
    }

    public void setProperty(Property property, String string) {
        this.fProperties.setProperty(property.getKey(), string);
    }

    private static Properties readPropertiesFile(File file) {
        Properties properties = new Properties();
        if (file != null && file.exists()) {
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
                properties.load(inputStreamReader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    public static enum Property {
        SHORT_NAME("shortname"),
        DISPLAY_NAME("displayname"),
        PATH_FROM_DOCROOT("pathfromdocroot"),
        BASE_PRODUCT_SHORTNAME("baseshortname"),
        LEGAL_NAME("legalname");

        private final String iPropertyKey;

        private Property(String string2) {
            this.iPropertyKey = string2;
        }

        private String getKey() {
            return this.iPropertyKey;
        }
    }
}

