/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.help.helpui.search.DocSearchJsonUtils;
import com.mathworks.help.helpui.search.FacetLabelVisitor;
import com.mathworks.help.helpui.search.LocalDocSearchPage;
import com.mathworks.helpsearch.facets.DocFacet;
import com.mathworks.helpsearch.facets.DocFacetResults;
import com.mathworks.helpsearch.facets.DocumentationFacetVisitor;
import com.mathworks.helpsearch.facets.Facetable;
import com.mathworks.html.Url;
import com.mathworks.search.facet.FacetResult;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

class FacetJsonBuilder {
    private static final FacetLabelVisitor FACET_LABEL_VISITOR = new FacetLabelVisitor();
    private static final int CATEGORY_LIMIT = 30;
    private final Iterable<DocFacetResults> fFacetResultsList;
    private final LocalDocSearchPage fSearchPage;
    private final DocRoot fDocUrlBuilder;

    FacetJsonBuilder(Iterable<DocFacetResults> iterable, LocalDocSearchPage localDocSearchPage, DocRoot docRoot) {
        this.fFacetResultsList = iterable;
        this.fSearchPage = localDocSearchPage.getModifiedCopy(1);
        this.fDocUrlBuilder = docRoot;
    }

    JsonEntity getJsonFacetResults() {
        JsonObject jsonObject = new JsonObject();
        for (DocFacetResults docFacetResults : this.fFacetResultsList) {
            JsonEntity jsonEntity = this.getJsonFacets(docFacetResults);
            jsonObject.addJsonProperty(docFacetResults.getFacetType().getFacetPrefix(), jsonEntity);
        }
        JsonArray jsonArray = new JsonArray();
        jsonArray.addEntity(jsonObject);
        return jsonArray;
    }

    JsonEntity getJsonFacetLabel() {
        JsonArray jsonArray = new JsonArray();
        for (DocFacetResults docFacetResults : this.fFacetResultsList) {
            Facetable facetable = docFacetResults.getSelectedFacet();
            if (facetable == null) continue;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addStringProperty("field", docFacetResults.getFacetType().getFacetPrefix());
            jsonObject.addStringProperty("value", facetable.getFacetId());
            facetable.accept((DocumentationFacetVisitor)FACET_LABEL_VISITOR);
            String string = FACET_LABEL_VISITOR.getMessage();
            jsonObject.addStringProperty("label", string);
            jsonArray.addEntity(jsonObject);
        }
        return jsonArray;
    }

    private JsonEntity getJsonFacets(DocFacetResults docFacetResults) {
        Facetable facetable;
        JsonObject jsonObject = new JsonObject();
        DocFacet docFacet = docFacetResults.getFacetType();
        String string = FacetJsonBuilder.getFacetTitle(docFacet);
        jsonObject.addStringProperty("facettitle", string);
        List list = docFacetResults.getResults();
        Boolean bl = list != null && !list.isEmpty();
        JsonEntity jsonEntity = null;
        if (bl.booleanValue()) {
            jsonEntity = this.getJsonRefinableFacets(docFacetResults.getResults(), docFacet);
        }
        Boolean bl2 = (facetable = docFacetResults.getSelectedFacet()) != null;
        jsonObject.addStringProperty("hasrefinedfacet", bl2.toString());
        if (bl2.booleanValue()) {
            JsonEntity jsonEntity2 = this.getJsonRefinedFacet(facetable, bl, jsonEntity);
            jsonObject.addJsonProperty("refinedfacet", jsonEntity2);
            jsonObject.addStringProperty("hasrefinablefacets", Boolean.FALSE.toString());
        } else {
            jsonObject.addStringProperty("hasrefinablefacets", bl.toString());
            if (bl.booleanValue()) {
                jsonObject.addJsonProperty("refinablefacets", jsonEntity);
            }
        }
        return jsonObject;
    }

    private static String getFacetTitle(DocFacet docFacet) {
        String string = HelpBrowserUtils.getString("helpbrowser.seachresults.facettitle");
        String string2 = HelpBrowserUtils.getString("helpbrowser.seachresults.facet." + docFacet.toString().toLowerCase(Locale.ENGLISH));
        return MessageFormat.format(string, string2);
    }

    private JsonEntity getJsonRefinedFacet(Facetable facetable, Boolean bl, JsonEntity jsonEntity) {
        JsonObject jsonObject = this.getJsonRefinedFacet(facetable);
        jsonObject.addStringProperty("hasrefinedfacet", Boolean.FALSE.toString());
        jsonObject.addStringProperty("hasrefinablefacets", bl.toString());
        if (bl.booleanValue()) {
            jsonObject.addJsonProperty("refinablefacets", jsonEntity);
        }
        for (Facetable facetable2 = facetable.getParent(); facetable2 != null; facetable2 = facetable2.getParent()) {
            JsonObject jsonObject2 = this.getJsonRefinedFacet(facetable2);
            jsonObject2.addStringProperty("hasrefinedfacet", String.valueOf(true));
            jsonObject2.addJsonProperty("refinedfacet", jsonObject);
            jsonObject2.addStringProperty("hasrefinablefacets", String.valueOf(false));
            jsonObject = jsonObject2;
        }
        return jsonObject;
    }

    private JsonObject getJsonRefinedFacet(Facetable facetable) {
        facetable.accept((DocumentationFacetVisitor)FACET_LABEL_VISITOR);
        String string = FACET_LABEL_VISITOR.getMessage();
        Facetable facetable2 = facetable.getParent();
        LocalDocSearchPage localDocSearchPage = facetable2 != null ? this.fSearchPage.getModifiedCopy(facetable2) : this.fSearchPage.getModifiedCopy(facetable.getFacetType(), null);
        String string2 = this.getUrlForSearchPage(localDocSearchPage).getQueryString();
        return FacetJsonBuilder.getJsonFacet(string, facetable.getFacetId(), string2, 0);
    }

    private JsonEntity getJsonRefinableFacets(Iterable<FacetResult<? extends Facetable>> iterable, DocFacet docFacet) {
        JsonArray jsonArray = new JsonArray();
        Iterator<FacetResult<? extends Facetable>> iterator = iterable.iterator();
        int n = docFacet == DocFacet.CATEGORY ? 30 : Integer.MAX_VALUE;
        for (int i = 0; iterator.hasNext() && i < n; ++i) {
            FacetResult<? extends Facetable> facetResult = iterator.next();
            JsonEntity jsonEntity = this.getJsonRefinableFacet(facetResult);
            jsonArray.addEntity(jsonEntity);
        }
        return jsonArray;
    }

    private JsonEntity getJsonRefinableFacet(FacetResult<? extends Facetable> facetResult) {
        Facetable facetable = (Facetable)facetResult.getCategory();
        int n = facetResult.getNumResults();
        facetable.accept((DocumentationFacetVisitor)FACET_LABEL_VISITOR);
        String string = FACET_LABEL_VISITOR.getMessage();
        LocalDocSearchPage localDocSearchPage = this.fSearchPage.getModifiedCopy((Facetable)facetResult.getCategory());
        String string2 = this.getUrlForSearchPage(localDocSearchPage).getQueryString();
        return FacetJsonBuilder.getJsonFacet(string, facetable.getFacetId(), string2, n);
    }

    private Url getUrlForSearchPage(LocalDocSearchPage localDocSearchPage) {
        return this.fDocUrlBuilder.buildSearchPageUrl(localDocSearchPage.getQuery(), localDocSearchPage.getPageNum());
    }

    private static JsonObject getJsonFacet(String string, String string2, String string3, int n) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("facetname", string);
        jsonObject.addStringProperty("facetcount", n > 0 ? String.valueOf(n) : "");
        jsonObject.addStringProperty("facetid", string2);
        jsonObject.addStringProperty("faceturlquery", DocSearchJsonUtils.escapeEncodedStringForHTML(string3));
        return jsonObject;
    }
}

