/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.DocSearchPageChangedListener;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.help.helpui.search.LocalDocSearchPage;
import com.mathworks.helpsearch.DocumentationSearchResult;
import com.mathworks.helpsearch.ResultPages;
import com.mathworks.search.SearchResults;
import java.text.MessageFormat;

class PageDataJsonBuilder {
    private final LocalDocSearchPage fSearchPage;
    private final ResultPages fPages;
    private final int fTotalResults;
    private final JsonEntity fJsonSearchTerm;
    private final DocRoot fDocUrlBuilder;
    private final String fLocale;

    PageDataJsonBuilder(LocalDocSearchPage localDocSearchPage, SearchResults<DocumentationSearchResult> searchResults, JsonEntity jsonEntity, DocRoot docRoot, String string) {
        this.fSearchPage = localDocSearchPage;
        this.fPages = new ResultPages(searchResults);
        this.fTotalResults = searchResults.getFullResultCount();
        this.fJsonSearchTerm = jsonEntity;
        this.fDocUrlBuilder = docRoot;
        this.fLocale = string;
    }

    JsonEntity getJsonPageData() {
        int n = this.fSearchPage.getPageNum();
        int n2 = DocSearchPageChangedListener.getStartPosition(n);
        int n3 = DocSearchPageChangedListener.getEndPosition(n2, this.fTotalResults);
        JsonEntity jsonEntity = this.getJsonSummary(n2 + 1, n3 + 1, this.fTotalResults);
        JsonEntity jsonEntity2 = this.getJsonFooter(n2 + 1, n3 + 1);
        JsonEntity jsonEntity3 = this.getJsonProductBreadcrumb();
        return this.getJsonDataObject(jsonEntity, jsonEntity2, jsonEntity3);
    }

    private JsonEntity getJsonProductBreadcrumb() {
        return new JsonObject();
    }

    private JsonEntity getJsonSummary(int n, int n2, int n3) {
        JsonObject jsonObject = new JsonObject();
        String string = this.getSummaryText(n, n2);
        jsonObject.addStringProperty(PageDataJsonBuilder.getSummaryTextPropertyName(), string);
        return jsonObject;
    }

    private static String getSummaryTextPropertyName() {
        return "summarytext";
    }

    private String getSummaryText(int n, int n2) {
        String string = HelpBrowserUtils.getString("helpbrowser.seachresults.summary");
        string = MessageFormat.format(string, n, n2, this.fTotalResults);
        return string;
    }

    private JsonEntity getJsonFooter(int n, int n2) {
        JsonArray jsonArray = new JsonArray();
        JsonObject jsonObject = new JsonObject();
        String string = this.getSummaryText(n, n2);
        jsonObject.addStringProperty(PageDataJsonBuilder.getSummaryTextPropertyName(), string);
        JsonEntity jsonEntity = this.getJsonFooterPages();
        jsonObject.addJsonProperty("footerdata", jsonEntity);
        jsonArray.addEntity(jsonObject);
        return jsonArray;
    }

    private JsonEntity getJsonFooterPages() {
        int n = this.fPages.getSelectedPage() + 1;
        int n2 = this.fPages.getPageListingStart() + 1;
        int n3 = this.fPages.getPageListingEnd() + 1;
        int n4 = this.fPages.getNumPages();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addIntProperty("numpages", n4);
        jsonObject.addIntProperty("selectedpage", n);
        jsonObject.addIntProperty("startrange", n2);
        jsonObject.addIntProperty("endrange", n3);
        jsonObject.addStringProperty("locale", this.fLocale);
        return jsonObject;
    }

    private JsonEntity getJsonDataObject(JsonEntity jsonEntity, JsonEntity jsonEntity2, JsonEntity jsonEntity3) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addJsonProperty("summarydata", jsonEntity);
        jsonObject.addJsonProperty("footerdata", jsonEntity2);
        jsonObject.addJsonProperty("productbreadcrumb", jsonEntity3);
        jsonObject.addJsonProperty("searchterm", this.fJsonSearchTerm);
        return jsonObject;
    }
}

