/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.help.helpui.search.BreadCrumbJsonBuilder;
import com.mathworks.helpsearch.DocumentationSearchResult;
import com.mathworks.helpsearch.HelpLocation;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.search.SearchHighlight;
import com.mathworks.search.SearchResults;
import java.util.Arrays;
import java.util.List;

class SearchResultJsonBuilder {
    private final SearchResults<DocumentationSearchResult> fSearchResults;
    private final DocRoot fDocUrlBuilder;
    private final DocumentationSet fDocSet;

    SearchResultJsonBuilder(SearchResults<DocumentationSearchResult> searchResults, DocRoot docRoot, DocumentationSet documentationSet) {
        this.fSearchResults = searchResults;
        this.fDocUrlBuilder = docRoot;
        this.fDocSet = documentationSet;
    }

    JsonEntity getJsonSearchResults() {
        JsonArray jsonArray = new JsonArray();
        int n = this.fSearchResults.getNumIncluded();
        int n2 = this.fSearchResults.getStart();
        int n3 = n2 + n;
        for (int i = n2; i < n3; ++i) {
            JsonEntity jsonEntity = this.getJsonSearchResult((DocumentationSearchResult)this.fSearchResults.getResult(i));
            jsonArray.addEntity(jsonEntity);
        }
        return jsonArray;
    }

    private JsonEntity getJsonSearchResult(DocumentationSearchResult documentationSearchResult) {
        List list;
        JsonEntity jsonEntity;
        String string = documentationSearchResult.getTitle();
        String string2 = documentationSearchResult.getSummary();
        Boolean bl = string2 != null && string2.length() > 0;
        DocSetItem docSetItem = documentationSearchResult.getDocSetItem();
        String string3 = docSetItem != null ? docSetItem.getDisplayName() : "";
        String string4 = documentationSearchResult.getPath();
        Object t = this.fDocUrlBuilder.buildHelpLocationUrl(docSetItem);
        SearchHighlight searchHighlight = documentationSearchResult.highlightText(documentationSearchResult.getDescription());
        if (searchHighlight != null && searchHighlight.getOriginalText().length() > 0) {
            jsonEntity = SearchResultJsonBuilder.getJsonHighlights(Arrays.asList(searchHighlight));
        } else {
            list = documentationSearchResult.getHighlights();
            jsonEntity = SearchResultJsonBuilder.getJsonHighlights(list);
        }
        list = documentationSearchResult.getBreadCrumbs();
        InformationType informationType = documentationSearchResult.getType();
        String string5 = informationType != null ? informationType.getIndexString() : "";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("title", string);
        jsonObject.addStringProperty("hassummary", bl.toString());
        if (bl.booleanValue()) {
            jsonObject.addStringProperty("summary", string2);
        }
        jsonObject.addStringProperty("product", t.toString());
        jsonObject.addStringProperty("path", string4);
        jsonObject.addJsonProperty("highlights", jsonEntity);
        HelpLocation helpLocation = docSetItem == null ? null : docSetItem.getHelpLocation();
        BreadCrumbJsonBuilder breadCrumbJsonBuilder = new BreadCrumbJsonBuilder(this.fDocSet, list, helpLocation, string3);
        JsonEntity jsonEntity2 = breadCrumbJsonBuilder.getJsonBreadcrumbs();
        jsonObject.addJsonProperty("breadcrumbs", jsonEntity2);
        jsonObject.addStringProperty("type", string5);
        return jsonObject;
    }

    private static JsonEntity getJsonHighlights(Iterable<SearchHighlight> iterable) {
        if (iterable == null) {
            return new JsonArray();
        }
        JsonArray jsonArray = new JsonArray();
        for (SearchHighlight searchHighlight : iterable) {
            String string = SearchResultJsonBuilder.getHighlightHtml(searchHighlight);
            jsonArray.addString(string);
        }
        return jsonArray;
    }

    private static String getHighlightHtml(SearchHighlight searchHighlight) {
        String string = searchHighlight.getHighlightText();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (SearchHighlight.Extent extent : searchHighlight.getExtents()) {
            String string2 = string.substring(n, extent.getStart());
            stringBuilder.append(SearchResultJsonBuilder.escapeHtml(string2));
            stringBuilder.append("<b>");
            stringBuilder.append(extent.getText());
            stringBuilder.append("</b>");
            n = extent.getEnd();
        }
        stringBuilder.append(SearchResultJsonBuilder.escapeHtml(string.substring(n)));
        return stringBuilder.toString();
    }

    private static String escapeHtml(String string) {
        return string.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

