/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.suggestions;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.suggestions.SuggestionRequest;
import com.mathworks.help.helpui.suggestions.SuggestionUtils;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.suggestion.DocumentationSuggestionProvider;
import com.mathworks.helpsearch.suggestion.PageSuggestion;
import com.mathworks.helpsearch.suggestion.PageSuggestionFinder;
import com.mathworks.html.FileUrl;
import com.mathworks.search.SearchException;
import java.text.MessageFormat;

public class PageSuggestionRequest
implements SuggestionRequest {
    public static final MessageFormat MORE_PAGES_FORMAT = new MessageFormat("suggestionsObj.displayMoreSuggestions(''{0}'',''pagesuggestion'',{1});");
    private final DocumentationSuggestionProvider fSuggestionProvider;
    private final InformationType fType;
    private final String fSearchText;
    private final int fStartAt;
    private final DocRoot<FileUrl> fDocUrlBuilder;

    public PageSuggestionRequest(DocumentationSuggestionProvider documentationSuggestionProvider, InformationType informationType, String string, int n, DocRoot<FileUrl> docRoot) {
        this.fSuggestionProvider = documentationSuggestionProvider;
        this.fType = informationType;
        this.fSearchText = string;
        this.fStartAt = n;
        this.fDocUrlBuilder = docRoot;
    }

    protected PageSuggestionFinder getSuggestionFinder() {
        return new PageSuggestionFinder(this.fSuggestionProvider, this.fType, this.fSearchText, this.fStartAt);
    }

    public Iterable<PageSuggestion> findSuggestions() throws SearchException {
        PageSuggestionFinder pageSuggestionFinder = this.getSuggestionFinder();
        return pageSuggestionFinder.getPageSuggestions();
    }

    public JsonArray getJsonArray(Iterable<PageSuggestion> iterable) {
        return SuggestionUtils.createPageSuggestionArray(this.fDocUrlBuilder, this.fType, iterable);
    }

    @Override
    public String getJavaScriptCallback() throws SearchException {
        Iterable<PageSuggestion> iterable = this.findSuggestions();
        JsonArray jsonArray = this.getJsonArray(iterable);
        Object[] objectArray = new Object[]{this.fType.getFacetId(), jsonArray.getJsonString()};
        return MORE_PAGES_FORMAT.format(objectArray);
    }
}

