/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.DocumentationAnalyzer;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.lucene.FileSystemIndexLocation;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneSearchEngine;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.lucene.analysis.Analyzer;

public class DocSearchEngineFactory {
    public static SearchEngine createSearchEngine(SearchConfig config, DocumentationSet docSet) {
        IndexLocation[] locations = DocSearchEngineFactory.getIndexLocations(config);
        EnumSet<DocumentationSearchField> fields = EnumSet.of(DocumentationSearchField.BODY, DocumentationSearchField.TITLE_SEARCH, DocumentationSearchField.SUMMARY);
        SearchLanguage language = docSet.getLanguage().getSearchLanguage();
        DocumentationAnalyzer docCenterAnalyzer = DocumentationAnalyzer.getSearchAnalyzer(docSet.getLanguage().getSearchLanguage());
        return new LuceneSearchEngine(language, (Analyzer)docCenterAnalyzer, fields, locations);
    }

    private static IndexLocation[] getIndexLocations(SearchConfig config) {
        Collection<File> indexDirs = config.getIndexDirectories();
        IndexLocation[] locations = new IndexLocation[indexDirs.size()];
        int i = 0;
        for (File indexDir : indexDirs) {
            locations[i++] = new FileSystemIndexLocation(indexDir);
        }
        return locations;
    }
}

