/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.csh;

import com.mathworks.helpsearch.DocSearchEngineFactory;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.csh.CshResult;
import com.mathworks.helpsearch.csh.CshRetriever;
import com.mathworks.helpsearch.csh.CshSearchField;
import com.mathworks.helpsearch.product.DocCenterItemResolver;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.ListSearchResultCollector;
import com.mathworks.search.PartialWordSearchExpression;
import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultAdapter;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SimpleSearchExpression;
import java.io.IOException;
import java.util.ArrayList;

public class SearchEngineCshRetriever
implements CshRetriever {
    private final SearchEngine fSearchEngine;
    private final DocumentationSet fDocSet;

    public SearchEngineCshRetriever(SearchConfig config, DocumentationSet docSet) {
        this(DocSearchEngineFactory.createSearchEngine(config, docSet), docSet);
    }

    public SearchEngineCshRetriever(SearchEngine engine, DocumentationSet docSet) {
        this.fSearchEngine = engine;
        this.fDocSet = docSet;
    }

    @Override
    public CshResult findProductTopic(DocProduct product, String mapKey) {
        return this.findProductTopic(product, null, mapKey);
    }

    @Override
    public CshResult findProductTopic(String prodShortName, String mapKey) {
        return this.findProductTopic(prodShortName, null, mapKey);
    }

    @Override
    public CshResult findProductTopic(DocProduct product, String mapFile, String mapKey) {
        return this.findProductTopic(product.getShortName(), mapFile, mapKey);
    }

    @Override
    public CshResult findProductTopic(String prodShortName, String mapFile, String mapKey) {
        return this.findTopic(prodShortName, mapFile, mapKey);
    }

    @Override
    public CshResult findGlobalTopic(String topicKey, String mapKey) {
        CshResult topicMapResult = this.findTopicMapResult(topicKey);
        if (topicMapResult != null) {
            return this.findProductTopic(topicMapResult.getProduct(), topicMapResult.getRelativePath(), mapKey);
        }
        return null;
    }

    @Override
    public SearchResults<CshResult> findGlobalTopicsStartingWith(String prefix) throws SearchException {
        PartialWordSearchExpression expression = new PartialWordSearchExpression(prefix);
        expression.addSearchField((SearchField)CshSearchField.TOPIC_MAP_KEY);
        expression.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
        SearchCriteria criteria = new SearchCriteria((SearchExpression)expression);
        CshResultAdapter adapter = new CshResultAdapter();
        ListSearchResultCollector collector = ListSearchResultCollector.createCollector((SearchResultAdapter)adapter);
        this.fSearchEngine.search(criteria, new SearchResultCollector[]{collector});
        return collector.getResults(0, collector.getNumResults());
    }

    @Override
    public void close() {
        try {
            this.fSearchEngine.closeIndex();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private CshResult findTopic(String shortName, String mapFile, String mapKey) {
        try {
            SearchExpression expr = SearchEngineCshRetriever.buildCshExpression(shortName, mapFile, mapKey);
            SearchCriteria criteria = new SearchCriteria(expr);
            return this.getCshResult(criteria);
        }
        catch (SearchException se) {
            return null;
        }
    }

    private static SearchExpression buildCshExpression(String shortName, String mapFile, String mapKey) {
        assert (shortName != null) : "CSH requests must include a product";
        assert (mapKey != null) : "CSH requests must include a map key";
        int numExprs = mapFile == null ? 2 : 3;
        ArrayList<SearchExpression> expressions = new ArrayList<SearchExpression>(numExprs);
        expressions.add(SearchEngineCshRetriever.createSearchFieldExpression(CshSearchField.CSH_PRODUCT, shortName));
        expressions.add(SearchEngineCshRetriever.createSearchFieldExpression(CshSearchField.MAP_KEY, mapKey));
        if (mapFile != null) {
            String correctedMapFile = SearchEngineCshRetriever.correctMapFilePath(mapFile);
            expressions.add(SearchEngineCshRetriever.createSearchFieldExpression(CshSearchField.MAP_FILE_PATH, correctedMapFile));
        }
        return new CompoundSearchExpression(expressions);
    }

    private static String correctMapFilePath(String mapFile) {
        return mapFile;
    }

    private CshResult getCshResult(SearchCriteria criteria) throws SearchException {
        CshResultAdapter adapter = new CshResultAdapter();
        return this.findSingleResult(criteria, adapter);
    }

    private <T> T findSingleResult(SearchCriteria criteria, SearchResultAdapter<T> adapter) throws SearchException {
        ListSearchResultCollector resultsCollector = ListSearchResultCollector.createCollector(adapter);
        this.fSearchEngine.search(criteria, new SearchResultCollector[]{resultsCollector});
        SearchResults results = resultsCollector.getResults(0, 1);
        if (results.getNumIncluded() == 1) {
            return (T)results.getResult(0);
        }
        return null;
    }

    private CshResult findTopicMapResult(String topicKey) {
        SearchExpression expr = SearchEngineCshRetriever.createSearchFieldExpression(CshSearchField.TOPIC_MAP_KEY, topicKey);
        SearchCriteria criteria = new SearchCriteria(expr);
        try {
            return this.findSingleResult(criteria, new CshResultAdapter());
        }
        catch (SearchException se) {
            return null;
        }
    }

    private static SearchExpression createSearchFieldExpression(CshSearchField field, String searchString) {
        SimpleSearchExpression expression = new SimpleSearchExpression(searchString);
        expression.addSearchField((SearchField)field);
        expression.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
        return expression;
    }

    private class CshResultAdapter
    implements SearchResultAdapter<CshResult> {
        private CshResultAdapter() {
        }

        public CshResult adaptResult(SearchResult result) {
            DocCenterItemResolver resolver = new DocCenterItemResolver(SearchEngineCshRetriever.this.fDocSet);
            String productName = result.getFieldValue(CshSearchField.CSH_PRODUCT.getFieldName());
            DocProduct product = resolver.getDocProductByIndexString(productName);
            String relPath = result.getFieldValue(CshSearchField.CSH_TARGET.getFieldName());
            return new CshResult(product, relPath);
        }
    }
}

