/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.facets;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.ProductSearchExpression;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SimpleSearchExpression;
import java.util.Locale;

public enum DocFacet {
    PRODUCT(new ProductExpressionBuilder()),
    CATEGORY(DocumentationSearchField.ANCESTOR_ID),
    TYPE(DocumentationSearchField.RESULT_TYPE);

    private final SearchExpressionBuilder fExprBuilder;

    private DocFacet(DocumentationSearchField field) {
        this(new DefaultExpressionBuilder(field));
    }

    private DocFacet(SearchExpressionBuilder exprBuilder) {
        this.fExprBuilder = exprBuilder;
    }

    public static DocFacet fromFacetPrefix(String facetPrefix) {
        try {
            return DocFacet.valueOf(facetPrefix.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public String getFacetPrefix() {
        return this.toString().toLowerCase(Locale.ENGLISH);
    }

    public SearchExpression createSearchExpression(String selectedValue) {
        return this.fExprBuilder.buildExpression(selectedValue);
    }

    public boolean useFacetWithFormat(ContentFormat format) {
        if (this == CATEGORY) {
            return format == ContentFormat.DOC_CENTER_DOC;
        }
        return true;
    }

    private static class DefaultExpressionBuilder
    implements SearchExpressionBuilder {
        private final DocumentationSearchField iField;

        private DefaultExpressionBuilder(DocumentationSearchField field) {
            this.iField = field;
        }

        @Override
        public SearchExpression buildExpression(String selectedFacet) {
            SimpleSearchExpression expr = new SimpleSearchExpression(selectedFacet);
            expr.addSearchField((SearchField)this.iField);
            expr.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
            return expr;
        }
    }

    private static class ProductExpressionBuilder
    implements SearchExpressionBuilder {
        private ProductExpressionBuilder() {
        }

        @Override
        public SearchExpression buildExpression(String facetId) {
            return new ProductSearchExpression(facetId, true);
        }
    }

    private static interface SearchExpressionBuilder {
        public SearchExpression buildExpression(String var1);
    }
}

