/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.DocTraversalStrategy;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class DocCrawler
implements DocTraversalStrategy {
    private static final String LANDING_PAGE = "index.html";
    private final Set<String> fVisitedDocs = new HashSet<String>();
    private final LocalizedFileLocator fFileLocator;
    private boolean fLandingPageVisited = false;

    DocCrawler(LocalizedFileLocator fileLocator) {
        this.fFileLocator = fileLocator;
    }

    @Override
    public Collection<String> updateAfterDocument(DocumentationDocument lastDocument, boolean indexed) {
        String relPath = this.getUnlocalizedFileName(lastDocument.getRelativePath());
        this.fVisitedDocs.add(relPath);
        if (indexed) {
            LinkedList<String> newDocs = new LinkedList<String>();
            for (String link : lastDocument.getOutgoingLinks()) {
                String unlocalizedLink = this.getUnlocalizedFileName(link);
                if (unlocalizedLink.contains("//") || this.fVisitedDocs.contains(unlocalizedLink)) continue;
                newDocs.add(unlocalizedLink);
            }
            return newDocs;
        }
        return Collections.emptyList();
    }

    private String getUnlocalizedFileName(String path) {
        return this.fFileLocator == null ? path : this.fFileLocator.getUnlocalizedFileName(path);
    }

    @Override
    public Collection<String> getPendingDocuments() {
        if (!this.fLandingPageVisited) {
            this.fLandingPageVisited = true;
            ArrayList<String> docs = new ArrayList<String>(1);
            docs.add(LANDING_PAGE);
            return docs;
        }
        return Collections.emptyList();
    }
}

