/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.DocumentationAnalyzer;
import com.mathworks.helpsearch.index.IndexerConfig;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.lucene.FileSystemIndexLocation;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneIndexer;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;

public class IndexUtils {
    private IndexUtils() {
    }

    public static String[] getDirectoriesForFilePath(String fromPath) {
        String[] pathParts = fromPath.split("[\\\\/]");
        String[] fromPathDirs = new String[pathParts.length - 1];
        System.arraycopy(pathParts, 0, fromPathDirs, 0, fromPathDirs.length);
        return fromPathDirs;
    }

    public static String resolveRelativePath(String relPath, String ... parentDirs) {
        String result = IndexUtils.resolveCurrentDirs(relPath);
        result = IndexUtils.resolveNonLeadingParentDirs(result);
        for (int i = parentDirs.length - 1; i > -1; --i) {
            result = result.startsWith("../") ? result.substring("../".length()) : parentDirs[i] + "/" + result;
        }
        return result;
    }

    private static String resolveCurrentDirs(String relPath) {
        return relPath.replaceAll("(^|/)\\./", "$1");
    }

    private static String resolveNonLeadingParentDirs(String relPath) {
        String result = relPath;
        boolean keepGoing = true;
        while (keepGoing) {
            String next = result.replaceAll("[^/]*\\w/\\.\\./", "");
            keepGoing = !next.equals(result);
            result = next;
        }
        return result;
    }

    public static boolean includeLinkInBreadCrumb(String href) {
        if (href == null || href.trim().length() == 0) {
            return false;
        }
        if (href.startsWith("..")) {
            return false;
        }
        if (href.equals("index.html")) {
            return false;
        }
        return !href.equals("examples.html");
    }

    static File getResourceDirectory(IndexerConfig config, boolean create) {
        File indexDir = config.getIndexDirectory();
        File parentDir = indexDir.getParentFile();
        File resourcesDir = new File(parentDir, "resources");
        if (resourcesDir.exists() || create && resourcesDir.mkdirs()) {
            return resourcesDir;
        }
        return null;
    }

    static File getProductResourceDirectory(IndexerConfig config, DocSetItem docSetItem, boolean create) {
        File globalResourcesDir = IndexUtils.getResourceDirectory(config, create);
        if (globalResourcesDir != null) {
            File productResourcesDir = new File(globalResourcesDir, docSetItem.getShortName());
            productResourcesDir.mkdirs();
            return productResourcesDir;
        }
        return null;
    }

    public static Indexer createDocCenterIndexer(SearchLanguage language, IndexerConfig config, boolean create) throws IOException {
        DocumentationAnalyzer docCenterAnalyzer = DocumentationAnalyzer.getIndexAnalyzer(language);
        IndexLocation location = IndexUtils.getIndexLocation(config);
        return new LuceneIndexer(location, language, (Analyzer)docCenterAnalyzer, create);
    }

    private static IndexLocation getIndexLocation(IndexerConfig config) {
        File indexDir = config.getIndexDirectory();
        return new FileSystemIndexLocation(indexDir);
    }
}

