/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class XmlTagInfo {
    private final XmlTagInfo fParent;
    private final String fTagName;
    private final Map<String, String> fAttributes;

    public XmlTagInfo(String tagname, Map<String, String> attributes, XmlTagInfo parent) {
        this.fTagName = tagname == null ? null : tagname.toLowerCase(Locale.ENGLISH);
        this.fAttributes = new HashMap<String, String>(attributes);
        this.fParent = parent;
    }

    public String getTagName() {
        return this.fTagName;
    }

    public String getAttribute(String name) {
        return this.fAttributes.get(name);
    }

    public XmlTagInfo getParent() {
        return this.fParent;
    }

    public boolean isWithinTag(String tagName) {
        for (XmlTagInfo current = this; current != null; current = current.getParent()) {
            if (!current.getTagName().equalsIgnoreCase(tagName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<");
        sb.append(this.fTagName);
        for (Map.Entry<String, String> entry : this.fAttributes.entrySet()) {
            sb.append(' ').append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        sb.append(">");
        return sb.toString();
    }
}

