/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.example;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.index.DocumentTracker;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.IndexerObserver;
import com.mathworks.helpsearch.index.example.Example;
import com.mathworks.helpsearch.index.example.ExampleMetadataWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExampleIndexerObserver
implements IndexerObserver<DocumentationSearchField> {
    private Set<Example> exampleSet = new HashSet<Example>();
    ExampleMetadataWriter fExampleMetadataWriter;

    public ExampleIndexerObserver(ExampleMetadataWriter exampleMetadataWriter) {
        this.fExampleMetadataWriter = exampleMetadataWriter;
    }

    @Override
    public void indexingStarted() {
    }

    @Override
    public void startDocument(DocumentTracker<DocumentationSearchField> tracker) {
    }

    @Override
    public void parsedDocument(DocumentTracker<DocumentationSearchField> tracker) {
        DocumentationDocument doc = tracker.getDocumentationDocument();
        ResultCategory topLevelCategory = this.getResultCategory(doc.getBreadCrumbs());
        for (Example example : doc.getExamples()) {
            this.addExample(topLevelCategory, example);
        }
    }

    @Override
    public void createdIndexDocument(DocumentTracker<DocumentationSearchField> tracker) {
    }

    @Override
    public void endDocument(DocumentTracker<DocumentationSearchField> tracker) {
    }

    @Override
    public void indexingFinished() {
        this.fExampleMetadataWriter.createMetadataDocument(this.getExamples());
    }

    public void addExample(ResultCategory category, Example example) {
        Example exampleClone = new Example(example);
        exampleClone.setResultCategory(category);
        this.exampleSet.add(exampleClone);
    }

    private ResultCategory getResultCategory(List<ResultCategory> breadCrumbs) {
        if (breadCrumbs != null && !breadCrumbs.isEmpty()) {
            ResultCategory category = breadCrumbs.get(0);
            return category.getNodesRootFirst().get(0);
        }
        return null;
    }

    public Collection<Example> getExamples() {
        return Collections.unmodifiableCollection(this.exampleSet);
    }
}

