/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.microdata;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MicrodataItem {
    private final String fItemType;
    private final Map<String, List<String>> fStringProps = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<MicrodataItem>> fItemProps = new LinkedHashMap<String, List<MicrodataItem>>();

    public MicrodataItem(String itemType) {
        this.fItemType = itemType;
    }

    void addProperties(Map<String, List<Object>> properties) {
        for (Map.Entry<String, List<Object>> entry : properties.entrySet()) {
            for (Object value : entry.getValue()) {
                this.addProperty(entry.getKey(), value);
            }
        }
    }

    void addProperty(String name, Object value) {
        if (value instanceof String) {
            this.addStringProperty(name, (String)value);
        } else if (value instanceof MicrodataItem) {
            this.addItemProperty(name, (MicrodataItem)value);
        } else {
            throw new IllegalArgumentException("The property must be either a String or a MicrodataItem");
        }
    }

    void addStringProperty(String name, String value) {
        List<String> values = this.fStringProps.get(name);
        if (values == null) {
            values = new LinkedList<String>();
            this.fStringProps.put(name, values);
        }
        values.add(value);
    }

    void addItemProperty(String name, MicrodataItem item) {
        List<MicrodataItem> values = this.fItemProps.get(name);
        if (values == null) {
            values = new LinkedList<MicrodataItem>();
            this.fItemProps.put(name, values);
        }
        values.add(item);
    }

    public String getItemType() {
        return this.fItemType;
    }

    public Map<String, List<String>> getStringProperties() {
        return Collections.unmodifiableMap(this.fStringProps);
    }

    public Map<String, List<MicrodataItem>> getItemProperties() {
        return Collections.unmodifiableMap(this.fItemProps);
    }
}

