/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.microdata;

import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.microdata.MicrodataDocumentBuilder;
import com.mathworks.helpsearch.index.microdata.MicrodataItem;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ReferenceDataParser {
    private static final String REF_ENTITY_OBJ = "refentityobj";
    private static final String REF_ENTITY_PROP = "refentity";
    private static final String REF_ENTITY_NAME_PROP = "name";
    private static final String REF_ENTITY_PURPOSE_PROP = "purpose";
    private final DocumentationDocument fDocumentationDocument;

    ReferenceDataParser(DocumentationDocument doc) {
        this.fDocumentationDocument = doc;
    }

    List<ReferenceEntity> getTopLevelReferenceEntities(MicrodataItem item) {
        List<String> entities = item.getStringProperties().get(REF_ENTITY_PROP);
        if (entities != null) {
            LinkedList<ReferenceEntity> entityList = new LinkedList<ReferenceEntity>();
            for (String entityStr : entities) {
                ReferenceEntity entity = ReferenceEntity.fromRefPageMetaData(entityStr);
                if (entity == null) continue;
                entityList.add(entity);
            }
            return entityList;
        }
        return Collections.emptyList();
    }

    List<ReferenceData> getAllNestedReferenceItems(MicrodataItem item) {
        List<MicrodataItem> propertyItems = item.getItemProperties().get("property");
        if (propertyItems != null) {
            LinkedList<ReferenceData> refItems = new LinkedList<ReferenceData>();
            for (MicrodataItem propertyItem : propertyItems) {
                refItems.addAll(this.getNestedReferenceItem(propertyItem));
            }
            return refItems;
        }
        return Collections.emptyList();
    }

    private List<ReferenceData> getNestedReferenceItem(MicrodataItem propertyItem) {
        if (ReferenceDataParser.isStructuredPropertyItem(propertyItem)) {
            return this.getStructuredPropertyItem(propertyItem);
        }
        ReferenceData propertyRefData = this.getUnstructuredPropertyItem(propertyItem);
        return propertyRefData == null ? Collections.emptyList() : Arrays.asList(propertyRefData);
    }

    private static boolean isStructuredPropertyItem(MicrodataItem propertyItem) {
        List<MicrodataItem> refEntityObjItems = propertyItem.getItemProperties().get(REF_ENTITY_OBJ);
        return refEntityObjItems != null && !refEntityObjItems.isEmpty();
    }

    private List<ReferenceData> getStructuredPropertyItem(MicrodataItem propertyItem) {
        String purpose = MicrodataDocumentBuilder.getStringProperty(propertyItem, REF_ENTITY_PURPOSE_PROP);
        List<MicrodataItem> refEntityObjItems = propertyItem.getItemProperties().get(REF_ENTITY_OBJ);
        ArrayList<ReferenceData> refData = new ArrayList<ReferenceData>(refEntityObjItems.size());
        for (MicrodataItem innerItem : refEntityObjItems) {
            String refEntityString = MicrodataDocumentBuilder.getStringProperty(innerItem, REF_ENTITY_PROP);
            String propName = MicrodataDocumentBuilder.getStringProperty(innerItem, REF_ENTITY_NAME_PROP);
            ReferenceEntity entity = ReferenceEntity.fromRefPageMetaData(refEntityString);
            if (entity == null) continue;
            refData.add(this.createReferenceData(entity, propName, purpose));
        }
        return refData;
    }

    private ReferenceData getUnstructuredPropertyItem(MicrodataItem propertyItem) {
        String refEntityString = MicrodataDocumentBuilder.getStringProperty(propertyItem, REF_ENTITY_PROP);
        String propName = MicrodataDocumentBuilder.getStringProperty(propertyItem, REF_ENTITY_NAME_PROP);
        String purpose = MicrodataDocumentBuilder.getStringProperty(propertyItem, REF_ENTITY_PURPOSE_PROP);
        ReferenceEntity entity = ReferenceEntity.fromRefPageMetaData(refEntityString);
        if (entity != null) {
            return this.createReferenceData(entity, propName, purpose);
        }
        return null;
    }

    private ReferenceData createReferenceData(ReferenceEntity entity, String propName, String purpose) {
        String anchor = "#prop_" + propName;
        String path = this.fDocumentationDocument.getRelativePath() + anchor;
        return new ReferenceData(this.fDocumentationDocument.getDocSetItem(), entity.getName(), path, purpose, "", entity.getType(), Collections.emptyList(), Collections.emptyList());
    }
}

