/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.report;

import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.microdata.MicrodataItem;
import com.mathworks.helpsearch.index.report.HeaderReportPart;
import com.mathworks.helpsearch.index.report.IndexReport;
import com.mathworks.helpsearch.index.report.IndexReportUtils;
import com.mathworks.helpsearch.index.report.ListReportPart;
import com.mathworks.helpsearch.index.report.TableReportPart;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.SearchField;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class SingleDocumentReport
extends IndexReport {
    private final Set<DocumentState> completedStates = EnumSet.noneOf(DocumentState.class);

    protected final void addCompletedState(DocumentState state) {
        this.completedStates.add(state);
    }

    protected final void addMicrodataParts(List<MicrodataItem> microdataItems) {
        if (microdataItems != null && !microdataItems.isEmpty()) {
            this.addCompletedState(DocumentState.MICRODATA);
            this.addParts(new HeaderReportPart("Microdata", 2));
            this.addParts(IndexReportUtils.createMicrodataReportParts(microdataItems));
        }
    }

    protected final void addDocumentationDocumentParts(DocumentationDocument document) {
        if (document != null) {
            this.completedStates.add(DocumentState.PARSED);
            this.addParts(new HeaderReportPart("Documentation Document", 2));
            this.addParts(IndexReportUtils.createDocumentationDocumentReportPart(document));
        }
    }

    protected final <T extends SearchField> void addIndexDocumentParts(List<IndexDocument<T>> indexDocs) {
        if (indexDocs != null && !indexDocs.isEmpty()) {
            this.addCompletedState(DocumentState.INDEXED);
            for (IndexDocument<T> indexDoc : indexDocs) {
                this.addParts(new HeaderReportPart("Index Document", 2));
                this.addParts(IndexReportUtils.createIndexDocumentReportPart(indexDoc));
            }
        }
    }

    protected final void addOutgoingLinksParts(Collection<String> outboundLinks) {
        HeaderReportPart outboundHeader = new HeaderReportPart("Outgoing Links", 2);
        ListReportPart outboundLinksPart = ListReportPart.fromStrings(outboundLinks, ListReportPart.Direction.VERTICAL);
        this.addParts(outboundHeader, outboundLinksPart);
    }

    protected final void addSummaryParts() {
        HeaderReportPart summaryHeader = new HeaderReportPart("Summary", 2);
        TableReportPart summaryTable = new TableReportPart();
        for (DocumentState state : DocumentState.values()) {
            String reportValue = this.completedStates.contains((Object)state) ? "Completed" : "Not Completed";
            summaryTable.addStringPart(state.toString(), reportValue);
        }
        this.addParts(summaryHeader, summaryTable);
    }

    protected static enum DocumentState {
        FOUND("Found by crawler"),
        MICRODATA("Parsed to Microdata"),
        PARSED("Parsed to MathWorks documentation data"),
        INDEXED("Indexed");

        private final String fDisplay;

        private DocumentState(String display) {
            this.fDisplay = display;
        }

        public String toString() {
            return this.fDisplay;
        }
    }
}

