/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.shared;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.XmlFragmentReader;
import com.mathworks.helpsearch.index.XmlTagInfo;
import com.mathworks.helpsearch.index.classic.TocTypeMap;

public class InfoTypeFragmentHandler
implements XmlFragmentHandler,
XmlFragmentReader {
    private InformationType fType;
    private boolean fIgnoreForCategoryFacet = false;

    public InfoTypeFragmentHandler(ContentFormat format) {
        if (format != ContentFormat.CLASSIC_DOC) {
            throw new UnsupportedOperationException("Using the toctype is only supported for classic doc.  For doc center doc, information type is determined using the infotype microdata.");
        }
    }

    @Override
    public String[] getEnclosingTagNames() {
        return new String[]{"meta"};
    }

    @Override
    public boolean useHandler(XmlTagInfo xmlTag) {
        String name = xmlTag.getAttribute("name");
        return name != null && name.equals("toctype");
    }

    @Override
    public boolean continueHandling() {
        return false;
    }

    @Override
    public void startElement(XmlTagInfo tagInfo) {
        String infoType = tagInfo.getAttribute("content");
        if (infoType != null) {
            this.fType = TocTypeMap.mapTocType(infoType);
            this.fIgnoreForCategoryFacet = this.fType == null ? false : this.fType.getIgnoreForCategoryFacet(infoType);
        }
    }

    @Override
    public void characters(XmlTagInfo location, String chars) {
    }

    @Override
    public void endElement(XmlTagInfo location) {
    }

    @Override
    public XmlFragmentReader startFragment(XmlTagInfo location) {
        return this;
    }

    @Override
    public void endFragment(XmlTagInfo location) {
    }

    private InformationType getInformationType() {
        return this.fType;
    }

    @Override
    public void populateDocument(DocumentationDocument doc) {
        doc.setType(this.getInformationType());
        doc.setIgnoreForCategoryFacet(this.fIgnoreForCategoryFacet);
    }
}

