/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.product.DocAddOn;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocSetItemResolver;
import com.mathworks.helpsearch.product.DocSetItemVisitor;
import com.mathworks.helpsearch.product.DocumentationSet;

public class DocCenterItemResolver
implements DocSetItemResolver {
    private final DocumentationSet fDocSet;

    public DocCenterItemResolver(DocumentationSet docSet) {
        this.fDocSet = docSet;
    }

    public static String toIndexString(DocSetItem item) {
        return item.accept(new IndexStringVisitor());
    }

    @Override
    public DocSetItem getDocSetItemByIndexString(String indexString) {
        String[] parts = DocCenterItemResolver.getIndexStringParts(indexString);
        DocProduct prod = this.fDocSet.getProductByShortName(parts[0]);
        if (parts.length < 2 || parts[1].isEmpty()) {
            return prod;
        }
        return prod.getAddOnByShortName(parts[1]);
    }

    @Override
    public DocProduct getDocProductByIndexString(String indexString) {
        String[] parts = DocCenterItemResolver.getIndexStringParts(indexString);
        return this.fDocSet.getProductByShortName(parts[0]);
    }

    private static String[] getIndexStringParts(String indexString) {
        String[] stringArray;
        if (indexString == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = indexString.split("::");
        }
        return stringArray;
    }

    private static class IndexStringVisitor
    implements DocSetItemVisitor<String> {
        private IndexStringVisitor() {
        }

        @Override
        public String visitDocProduct(DocProduct product) {
            return product.getShortName();
        }

        @Override
        public String visitDocAddOn(DocAddOn addOn) {
            return addOn.getParentProduct().getShortName() + "::" + addOn.getShortName();
        }
    }
}

