/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.product.BaseCodeMapBuilder;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class DocSetParser<T extends DocumentationSet> {
    private final BaseCodeMapBuilder fBaseCodeMapBuilder;

    public DocSetParser() {
        this(null);
    }

    public DocSetParser(BaseCodeMapBuilder mapBuilder) {
        this.fBaseCodeMapBuilder = mapBuilder;
    }

    protected abstract File getDocSetConfigFile();

    protected abstract T createNewDocSet(ContentFormat var1);

    protected abstract DocProduct createNewProduct(T var1, String var2, String var3, String var4);

    protected T getDocSet() {
        try {
            Document doc = this.getDocsetDocument();
            return this.parseDocSet(doc.getDocumentElement());
        }
        catch (Exception e) {
            return null;
        }
    }

    private T parseDocSet(Element rootNode) {
        Node formatNode = rootNode.getElementsByTagName("format").item(0);
        ContentFormat format = DocSetParser.getFormatFromString(formatNode.getTextContent());
        T docSet = this.createNewDocSet(format);
        Node productListNode = rootNode.getElementsByTagName("product-list").item(0);
        this.parseProducts(docSet, productListNode);
        if (this.fBaseCodeMapBuilder != null) {
            this.fBaseCodeMapBuilder.populateBaseCodeMap((DocumentationSet)docSet);
        }
        return docSet;
    }

    private void parseProducts(T documentationSet, Node productListNode) {
        NodeList children = ((Element)productListNode).getElementsByTagName("product");
        for (int i = 0; i < children.getLength(); ++i) {
            Element productNode = (Element)children.item(i);
            DocProduct product = this.parseProduct(documentationSet, productNode);
            documentationSet.addProduct(product);
        }
    }

    private DocProduct parseProduct(T docSet, Element productNode) {
        String shortName = DocSetParser.getChildValue(productNode, "short-name");
        String displayName = DocSetParser.getChildValue(productNode, "display-name");
        String helpLoc = DocSetParser.getChildValue(productNode, "help-location");
        return this.createNewProduct(docSet, shortName, displayName, helpLoc);
    }

    private static String getChildValue(Element parent, String tagName) {
        NodeList tags = parent.getElementsByTagName(tagName);
        if (tags.getLength() > 0) {
            return tags.item(0).getTextContent();
        }
        return null;
    }

    private static ContentFormat getFormatFromString(String formatString) {
        if (formatString.equalsIgnoreCase("doccenter")) {
            return ContentFormat.DOC_CENTER_DOC;
        }
        return ContentFormat.CLASSIC_DOC;
    }

    protected Document getDocsetDocument() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(this.getDocSetConfigFile());
    }
}

