/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.product.BaseCodeMapBuilder;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetParser;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductBaseCodeMap;
import com.mathworks.helpsearch.product.PropertiesBaseCodeMapBuilder;
import com.mathworks.helpsearch.product.SimpleDocProduct;
import com.mathworks.helpsearch.product.SimpleDocumentationSet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JavaScriptBaseCodeMap {
    private static final String CONSTRUCTOR = "function BaseCodeMap() {\n";
    private static final String VAR_ASSIGNMENT = "    this.";
    private static final String CLOSE_BRACE = "}";
    private final ProductBaseCodeMap fBaseCodeMap;

    public JavaScriptBaseCodeMap(ProductBaseCodeMap baseCodeMap) {
        this.fBaseCodeMap = baseCodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJsFile(File location) throws IOException {
        location = this.prepareJsFile(location);
        String script = this.getBaseCodeMapFunction();
        try (FileWriter writer = new FileWriter(location);){
            writer.write(script);
        }
    }

    private File prepareJsFile(File location) {
        if (location.exists() && location.isDirectory()) {
            location = new File(location, "basecodes.js");
        }
        if (location.exists()) {
            location.delete();
        }
        return location;
    }

    public String getBaseCodeMapFunction() {
        StringBuilder js = new StringBuilder(CONSTRUCTOR);
        js.append(VAR_ASSIGNMENT).append("global = ").append(this.getGlobalProductsArray()).append(";\n");
        js.append(VAR_ASSIGNMENT).append("simple = ").append(this.getSimpleMap()).append(";\n");
        js.append(VAR_ASSIGNMENT).append("multi = ").append(this.getMultiProductMap()).append(";\n\n");
        js.append(JavaScriptBaseCodeMap.createProductShortNamesFunction()).append("\n");
        js.append(CLOSE_BRACE).append("\n\n");
        js.append(JavaScriptBaseCodeMap.createContainsAllFunction());
        js.append("\n\n");
        js.append(JavaScriptBaseCodeMap.createSetVisibilityFunction());
        js.append("\n\n");
        js.append(JavaScriptBaseCodeMap.createGetProductDataFromCookieFunction());
        js.append("\n\n");
        js.append(JavaScriptBaseCodeMap.createHandleProductsFunction());
        js.append("\n\n");
        js.append(JavaScriptBaseCodeMap.createHandleAddOnsFunction());
        return js.toString();
    }

    private String getGlobalProductsArray() {
        List<DocProduct> globalProducts = this.fBaseCodeMap.getGlobalProducts();
        if (globalProducts != null && !globalProducts.isEmpty()) {
            return JavaScriptBaseCodeMap.getProductsArray(globalProducts);
        }
        return "[]";
    }

    private String getSimpleMap() {
        Map<String, List<DocProduct>> simpleMappings = this.fBaseCodeMap.getSimpleMappings();
        if (simpleMappings != null && !simpleMappings.isEmpty()) {
            StringBuilder jsObject = new StringBuilder("{");
            String indent = "\n        \"";
            for (Map.Entry<String, List<DocProduct>> entry : simpleMappings.entrySet()) {
                jsObject.append(indent).append(entry.getKey()).append("\":");
                jsObject.append(JavaScriptBaseCodeMap.getProductsArray(entry.getValue())).append(',');
            }
            jsObject.append(indent).append("3p\":[\"3p\"]");
            jsObject.append("\n    }");
            return jsObject.toString();
        }
        return "{}";
    }

    private String getMultiProductMap() {
        List<ProductBaseCodeMap.MultiBaseCodeMapping> multiMappings = this.fBaseCodeMap.getMultiBaseCodeMappings();
        if (multiMappings != null && !multiMappings.isEmpty()) {
            StringBuilder jsObject = new StringBuilder("{");
            for (ProductBaseCodeMap.MultiBaseCodeMapping mapping : multiMappings) {
                jsObject.append("\n        ").append(JavaScriptBaseCodeMap.getMultiProductMapEntry(mapping)).append(',');
            }
            jsObject.deleteCharAt(jsObject.length() - 1);
            jsObject.append("\n    }");
            return jsObject.toString();
        }
        return "{}";
    }

    private static String getMultiProductMapEntry(ProductBaseCodeMap.MultiBaseCodeMapping mapping) {
        StringBuilder jsMapping = new StringBuilder("\"");
        jsMapping.append(mapping.getProduct().getShortName()).append("\":");
        jsMapping.append(JavaScriptBaseCodeMap.toJavaScriptArray(mapping.getBaseCodes()));
        return jsMapping.toString();
    }

    private static String getProductsArray(List<DocProduct> products) {
        LinkedList<String> shortNames = new LinkedList<String>();
        for (DocProduct product : products) {
            shortNames.add(product.getShortName());
        }
        return JavaScriptBaseCodeMap.toJavaScriptArray(shortNames);
    }

    private static String toJavaScriptArray(List<String> values) {
        StringBuilder jsArray = new StringBuilder();
        for (String entry : values) {
            jsArray.append(",\"").append(entry).append('\"');
        }
        jsArray.append(']');
        jsArray.setCharAt(0, '[');
        return jsArray.toString();
    }

    public static void main(String[] args) {
        String helpDir = args[0];
        final String docSetDir = args.length > 1 ? args[1] : helpDir;
        File baseCodesFile = new File(docSetDir, "basecodes.properties");
        try {
            PropertiesBaseCodeMapBuilder mapBuilder = new PropertiesBaseCodeMapBuilder(baseCodesFile);
            DocSetParser<SimpleDocumentationSet> parser = new DocSetParser<SimpleDocumentationSet>((BaseCodeMapBuilder)mapBuilder){

                @Override
                protected File getDocSetConfigFile() {
                    return new File(docSetDir, "docset.xml");
                }

                @Override
                protected SimpleDocumentationSet createNewDocSet(ContentFormat format) {
                    return new SimpleDocumentationSet(ContentFormat.DOC_CENTER_DOC, DocLanguage.ENGLISH);
                }

                @Override
                protected DocProduct createNewProduct(SimpleDocumentationSet docSet, String shortName, String displayName, String helpLoc) {
                    return new SimpleDocProduct((DocumentationSet)docSet, shortName, displayName, helpLoc);
                }
            };
            Object docSet = parser.getDocSet();
            JavaScriptBaseCodeMap jsMap = new JavaScriptBaseCodeMap(docSet.getBaseCodeMap());
            jsMap.writeJsFile(new File(helpDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String createProductShortNamesFunction() {
        return "    this.getProductShortNames = function(baseCodes) {\n        var shortNames = this.global;\n        for (var i = 0; i < baseCodes.length; i++) {\n            shortNames = shortNames.concat(this.simple[baseCodes[i]]);\n        }\n        for (key in this.multi) {\n            if (containsAll(baseCodes,this.multi[key])) {\n                shortNames.push(key);\n            }\n        }\n        return shortNames;\n    }";
    }

    private static String createContainsAllFunction() {
        return "function containsAll(baseCodes, toFind) {\n    for (var i = 0; i < toFind.length; i++) {\n        if (!$.inArray(baseCodes,toFind[i])) {\n            return false;\n        }\n    }\n    return true;\n}";
    }

    private static String createSetVisibilityFunction() {
        return "function setVisibility() {\n    var cookieData = getProductDataFromCookie();\n    if (cookieData == null || cookieData.length == 0) {\n        handleProducts(null);\n        handleAddOns(null);\n        return;\n    }\n    var baseCodes = cookieData[0];\n    handleProducts(baseCodes);\n    if (cookieData.length > 1) {\n        var addOns = cookieData[1];\n        handleAddOns(addOns);\n    } else {\n        handleAddOns(null);\n    }\n}";
    }

    private static String createGetProductDataFromCookieFunction() {
        return "function getProductDataFromCookie() {\n    var cookieRegexp = /MW_Doc_Template=\"?([^;\"]*)/;\n    var cookies = document.cookie;\n    var matches = cookieRegexp.exec(cookies);\n    if (matches != null && matches.length > 0) {\n        var docCookie = matches[1];\n        var parts = docCookie.split(/\\|\\|/);\n        if (parts.length > 3) {\n            return [parts[1].split(/\\W+/), parts[3].split(/\\W+/)];\n        } else if (parts.length > 1) {\n            return [parts[1].split(/\\W+/)];\n        } else {\n            return null;\n        }\n    } else {\n        return null;\n    }\n}";
    }

    private static String createHandleProductsFunction() {
        return "function handleProducts(baseCodes) {\n    if (baseCodes == null || baseCodes.length == 0 || (baseCodes.length == 1 && baseCodes[0].length == 0)) {\n        handleSelectedProducts(null);\n    } else {\n        var shortNames = new BaseCodeMap().getProductShortNames(baseCodes);\n        handleSelectedProducts(shortNames);\n    }\n}";
    }

    private static String createHandleAddOnsFunction() {
        return "function handleAddOns(addOns) {\n    if (addOns == null || addOns.length == 0 || (addOns.length == 1 && addOns[0].length == 0)) {\n        handleSelectedAddOns(null);\n    } else {\n        handleSelectedAddOns(addOns);\n    }\n}";
    }
}

