/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.product.DocProduct;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProductBaseCodeMap {
    private final List<DocProduct> fGlobalProducts = new LinkedList<DocProduct>();
    private final Map<String, List<DocProduct>> fSimpleMappings = new HashMap<String, List<DocProduct>>();
    private final List<MultiBaseCodeMapping> fMultiMappings = new LinkedList<MultiBaseCodeMapping>();
    private final Map<String, String> fRequirementStrings = new HashMap<String, String>();

    public Set<DocProduct> getDocProductsForBaseCodes(Set<String> baseCodes) {
        HashSet<DocProduct> products = new HashSet<DocProduct>(this.fGlobalProducts);
        for (String baseCode : baseCodes) {
            List<DocProduct> baseCodeProducts = this.fSimpleMappings.get(baseCode);
            if (baseCodeProducts == null) continue;
            products.addAll(baseCodeProducts);
        }
        for (MultiBaseCodeMapping multiMapping : this.fMultiMappings) {
            if (!multiMapping.accept(baseCodes)) continue;
            products.add(multiMapping.getProduct());
        }
        return Collections.unmodifiableSet(products);
    }

    public String getBaseCode(DocProduct prod) {
        String reqString = this.getProductRequirementsString(prod);
        return reqString == null ? null : reqString.split("\\W")[0];
    }

    public void addProduct(DocProduct product, String baseCodeMappingString) {
        if (baseCodeMappingString == null || baseCodeMappingString.trim().length() == 0) {
            this.addBaseCodeMapping(product, new String[0]);
            this.fRequirementStrings.put(product.getShortName(), baseCodeMappingString);
        } else {
            String[] ors;
            for (String or : ors = baseCodeMappingString.split("\\|")) {
                String[] ands = or.split("\\W");
                this.addBaseCodeMapping(product, ands);
            }
            this.fRequirementStrings.put(product.getShortName(), baseCodeMappingString);
        }
    }

    private void addBaseCodeMapping(DocProduct product, String ... baseCodes) {
        if (baseCodes.length == 0) {
            this.fGlobalProducts.add(product);
        } else if (baseCodes.length == 1) {
            this.addSimpleBaseCodeMapping(product, baseCodes[0]);
        } else {
            this.addMultipleBaseCodeMapping(product, baseCodes);
        }
    }

    private void addSimpleBaseCodeMapping(DocProduct product, String baseCode) {
        List<DocProduct> products = this.fSimpleMappings.get(baseCode);
        if (products == null) {
            products = new LinkedList<DocProduct>();
            this.fSimpleMappings.put(baseCode, products);
        }
        products.add(product);
    }

    private void addMultipleBaseCodeMapping(DocProduct product, String ... baseCodes) {
        this.fMultiMappings.add(new MultiBaseCodeMapping(product, baseCodes));
    }

    public String getProductRequirementsString(DocProduct product) {
        return this.fRequirementStrings.get(product.getShortName());
    }

    public List<DocProduct> getGlobalProducts() {
        return Collections.unmodifiableList(this.fGlobalProducts);
    }

    public Map<String, List<DocProduct>> getSimpleMappings() {
        return Collections.unmodifiableMap(this.fSimpleMappings);
    }

    public List<MultiBaseCodeMapping> getMultiBaseCodeMappings() {
        return Collections.unmodifiableList(this.fMultiMappings);
    }

    public Collection<DocProduct> getAllKnownProducts() {
        LinkedList<DocProduct> products = new LinkedList<DocProduct>();
        products.addAll(this.getGlobalProducts());
        for (List<DocProduct> simple : this.getSimpleMappings().values()) {
            products.addAll(simple);
        }
        for (MultiBaseCodeMapping multi : this.getMultiBaseCodeMappings()) {
            products.add(multi.getProduct());
        }
        return products;
    }

    static class MultiBaseCodeMapping {
        private final DocProduct fProduct;
        private final List<String> fBaseCodes;

        private MultiBaseCodeMapping(DocProduct product, String ... baseCodes) {
            this.fProduct = product;
            this.fBaseCodes = Arrays.asList(baseCodes);
        }

        private boolean accept(Set<String> userBaseCodes) {
            return userBaseCodes.containsAll(this.fBaseCodes);
        }

        DocProduct getProduct() {
            return this.fProduct;
        }

        List<String> getBaseCodes() {
            return Collections.unmodifiableList(this.fBaseCodes);
        }
    }
}

