/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.SearchExpressionFilter;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SimpleSearchExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class ProductFilter
implements SearchExpressionFilter {
    private final Set<DocProduct> fProducts;
    private final SearchExpression fProductFilterExpr;

    public ProductFilter(DocumentationSet docSet, Collection<DocProduct> products) {
        this.fProducts = new LinkedHashSet<DocProduct>(products);
        this.fProductFilterExpr = ProductFilter.createExpression(docSet, products);
    }

    @Override
    public SearchExpression addFilterToExpression(SearchExpression expression) {
        if (this.fProductFilterExpr == null) {
            return expression;
        }
        return new CompoundSearchExpression(new SearchExpression[]{expression, this.fProductFilterExpr});
    }

    private static SearchExpression createExpression(DocumentationSet docSet, Collection<DocProduct> products) {
        int totalProducts = docSet.getAllProducts().size();
        int includedProducts = products.size();
        if (includedProducts == 0 || includedProducts == totalProducts) {
            return null;
        }
        Set<String> includedShortNames = ProductFilter.toShortNames(products);
        if (includedProducts < totalProducts / 2) {
            return ProductFilter.createIncludeProductsExpression(includedShortNames);
        }
        Set<String> excluded = ProductFilter.toShortNames(docSet.getAllProducts());
        excluded.removeAll(includedShortNames);
        return ProductFilter.createExcludeProductsExpression(excluded);
    }

    private static Set<String> toShortNames(Collection<DocProduct> prods) {
        HashSet<String> shortNames = new HashSet<String>();
        for (DocProduct prod : prods) {
            shortNames.add(prod.getShortName());
        }
        return shortNames;
    }

    private static SearchExpression createIncludeProductsExpression(Collection<String> toInclude) {
        return ProductFilter.createProductsExpression(toInclude, BooleanSearchOperator.MUST_OCCUR);
    }

    private static SearchExpression createExcludeProductsExpression(Collection<String> toExclude) {
        return ProductFilter.createProductsExpression(toExclude, BooleanSearchOperator.MUST_NOT_OCCUR);
    }

    private static SearchExpression createProductsExpression(Collection<String> shortNames, BooleanSearchOperator operator) {
        if (shortNames.size() == 1) {
            return ProductFilter.createSingleProductExpression(shortNames.iterator().next(), operator);
        }
        CompoundSearchExpression prodsExpression = new CompoundSearchExpression();
        for (String shortName : shortNames) {
            SearchExpression expr = ProductFilter.createSingleProductExpression(shortName, BooleanSearchOperator.SHOULD_OCCUR);
            prodsExpression.addExpression(expr);
        }
        prodsExpression.setBooleanOperator(operator);
        return prodsExpression;
    }

    private static SearchExpression createSingleProductExpression(String shortName, BooleanSearchOperator operator) {
        SimpleSearchExpression expr = new SimpleSearchExpression(shortName, operator);
        expr.addSearchField((SearchField)DocumentationSearchField.PRODUCT);
        return expr;
    }

    SearchExpression getSearchExpression() {
        return this.fProductFilterExpr;
    }

    public Set<DocProduct> getSelectedProducts() {
        return Collections.unmodifiableSet(this.fProducts);
    }
}

