/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import com.mathworks.helpsearch.reference.ReferenceEntityNameComparator;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.ExactPhraseSearchExpression;
import com.mathworks.search.PartialWordSearchExpression;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class ReferenceEntityRequest
extends ReferenceRequest {
    private final String fEntityName;
    private final Precision fPrecision;
    private final Collection<RefEntityType> fTypes;
    private boolean fMatchCase = false;

    public ReferenceEntityRequest(String entityName, RefEntityType ... types) {
        this(entityName, (Precision)null, (DocProduct)null, types);
    }

    public ReferenceEntityRequest(String entityName, Collection<RefEntityType> types) {
        this(entityName, null, null, types);
    }

    public ReferenceEntityRequest(String entityName, Precision precision, RefEntityType ... types) {
        this(entityName, precision, (DocProduct)null, types);
    }

    public ReferenceEntityRequest(String entityName, Precision precision, Collection<RefEntityType> types) {
        this(entityName, precision, null, types);
    }

    public ReferenceEntityRequest(String entityName, DocProduct product, RefEntityType ... types) {
        this(entityName, null, product, types);
    }

    public ReferenceEntityRequest(String entityName, DocProduct product, Collection<RefEntityType> types) {
        this(entityName, null, product, types);
    }

    public ReferenceEntityRequest(String entityName, Precision precision, DocProduct product, RefEntityType ... types) {
        this(entityName, precision, product, Arrays.asList(types));
    }

    public ReferenceEntityRequest(String entityName, Precision precision, DocProduct product, Collection<RefEntityType> types) {
        if (product != null) {
            this.addProducts(product);
        }
        this.fEntityName = entityName;
        this.fPrecision = precision;
        if (types == null) {
            types = Collections.emptyList();
        }
        this.fTypes = types;
        this.setResultComparator(new ReferenceEntityNameComparator(entityName));
    }

    public void setMatchCase(boolean matchCase) {
        this.fMatchCase = matchCase;
    }

    @Override
    protected SearchExpression getBaseExpression() {
        Precision precision = this.getPrecision();
        Collection<RefEntityType> types = this.getRefEntityTypes();
        switch (types.size()) {
            case 0: {
                String indexString = ReferenceEntity.getEntityNameForIndexStringPart(this.fEntityName);
                SearchExpression expr = ReferenceEntityRequest.buildEntityNameExpression(indexString, precision, BooleanSearchOperator.MUST_OCCUR);
                expr.addSearchField((SearchField)this.getEntityNameField());
                return expr;
            }
            case 1: {
                return this.buildSingleEntityExpression(this.fEntityName, precision, types.iterator().next(), BooleanSearchOperator.MUST_OCCUR);
            }
        }
        LinkedList<SearchExpression> exprs = new LinkedList<SearchExpression>();
        for (RefEntityType type : types) {
            exprs.add(this.buildSingleEntityExpression(this.fEntityName, precision, type, BooleanSearchOperator.SHOULD_OCCUR));
        }
        CompoundSearchExpression orExpr = new CompoundSearchExpression(exprs);
        orExpr.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
        return orExpr;
    }

    private Precision getPrecision() {
        return this.fPrecision == null ? Precision.getDefault() : this.fPrecision;
    }

    private Collection<RefEntityType> getRefEntityTypes() {
        if (this.fTypes == null) {
            return Collections.emptyList();
        }
        return this.fTypes;
    }

    private SearchExpression buildSingleEntityExpression(String entityName, Precision precision, RefEntityType type, BooleanSearchOperator operator) {
        String indexString = new ReferenceEntity(type, entityName).getFullIndexString();
        SearchExpression expr = ReferenceEntityRequest.buildEntityNameExpression(indexString, precision, operator);
        expr.addSearchField((SearchField)this.getEntityInfoField());
        return expr;
    }

    private static SearchExpression buildEntityNameExpression(String text, Precision precision, BooleanSearchOperator operator) {
        switch (precision) {
            case EXACT_MATCH: {
                return new ExactPhraseSearchExpression(text, operator);
            }
            case PREFIX_MATCH: {
                return new PartialWordSearchExpression(text, operator);
            }
        }
        ExactPhraseSearchExpression exactMatchExpr = new ExactPhraseSearchExpression(text, BooleanSearchOperator.SHOULD_OCCUR);
        PartialWordSearchExpression loosePackageExpr = new PartialWordSearchExpression(text + "/", BooleanSearchOperator.SHOULD_OCCUR);
        CompoundSearchExpression fullExpr = new CompoundSearchExpression(new SearchExpression[]{exactMatchExpr, loosePackageExpr});
        fullExpr.setBooleanOperator(operator);
        return fullExpr;
    }

    public boolean findsSameDataAs(ReferenceEntityRequest other) {
        Set<String> otherProducts;
        if (!this.fEntityName.equals(other.fEntityName)) {
            return false;
        }
        if (this.getPrecision() != other.getPrecision()) {
            return false;
        }
        Collection<RefEntityType> thisTypes = this.fTypes;
        Collection<RefEntityType> otherTypes = other.fTypes;
        if (!thisTypes.containsAll(otherTypes) || !otherTypes.containsAll(thisTypes)) {
            return false;
        }
        Set<String> thisProducts = ReferenceEntityRequest.getShortNames(this.getProducts());
        return thisProducts.containsAll(otherProducts = ReferenceEntityRequest.getShortNames(other.getProducts())) && otherProducts.containsAll(thisProducts);
    }

    private static Set<String> getShortNames(Collection<DocProduct> products) {
        HashSet<String> shortNames = new HashSet<String>();
        for (DocProduct product : products) {
            shortNames.add(product.getShortName());
        }
        return shortNames;
    }

    private DocumentationSearchField getEntityNameField() {
        return this.fMatchCase ? DocumentationSearchField.REFPAGE_ENTITY_NAME_CASE : DocumentationSearchField.REFPAGE_ENTITY_NAME;
    }

    private DocumentationSearchField getEntityInfoField() {
        return this.fMatchCase ? DocumentationSearchField.REFPAGE_ENTITY_INFO_CASE : DocumentationSearchField.REFPAGE_ENTITY_INFO;
    }

    public static enum Precision {
        EXACT_MATCH,
        IGNORE_PACKAGE,
        PREFIX_MATCH;


        public static Precision getDefault() {
            return IGNORE_PACKAGE;
        }
    }
}

