/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.annot;

import com.mathworks.toolbox.coder.annot.AnnotationUtils;
import com.mathworks.toolbox.coder.annot.BindingProfile;
import com.mathworks.toolbox.coder.annot.BindingProfileFactory;
import com.mathworks.toolbox.coder.annot.BoundToProperty;
import com.mathworks.toolbox.coder.annot.DefaultBindingProfile;
import com.mathworks.toolbox.coder.annot.PropertyBinder;
import com.mathworks.toolbox.coder.annot.PropertyBinderFactory;
import com.mathworks.util.Converter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class DynamicProxyBindingProfileFactory
implements BindingProfileFactory {
    private static final Converter<Method, PropertyBinderFactory> METHOD_CONVERTER = DynamicProxyBindingProfileFactory.createMethodConverter();
    private static final Converter<Field, PropertyBinderFactory> FIELD_CONVERTER = DynamicProxyBindingProfileFactory.createFieldConverter();
    private final Map<Class, BindingProfile> fBindingProfiles = new HashMap<Class, BindingProfile>();

    DynamicProxyBindingProfileFactory() {
    }

    @Override
    public BindingProfile createBindingProfile(Object object) {
        BindingProfile bindingProfile = this.fBindingProfiles.get(object.getClass());
        if (bindingProfile == null) {
            bindingProfile = this.doCreateBindingProfile(object);
            this.fBindingProfiles.put(object.getClass(), bindingProfile);
        }
        return bindingProfile;
    }

    private BindingProfile doCreateBindingProfile(Object object) {
        DefaultBindingProfile defaultBindingProfile = new DefaultBindingProfile(object.getClass());
        DynamicProxyBindingProfileFactory.handleSingleElementType(METHOD_CONVERTER, AnnotationUtils.getAllAnnotatedMethods(object.getClass(), BoundToProperty.class), object, defaultBindingProfile);
        DynamicProxyBindingProfileFactory.handleSingleElementType(FIELD_CONVERTER, AnnotationUtils.getAllAnnotatedFields(object.getClass(), BoundToProperty.class), object, defaultBindingProfile);
        return defaultBindingProfile;
    }

    private static <T extends AnnotatedElement> void handleSingleElementType(Converter<T, PropertyBinderFactory> converter, Collection<T> collection, Object object, DefaultBindingProfile defaultBindingProfile) {
        for (AnnotatedElement annotatedElement : collection) {
            BoundToProperty boundToProperty = annotatedElement.getAnnotation(BoundToProperty.class);
            assert (boundToProperty.value() != null);
            PropertyBinderFactory propertyBinderFactory = (PropertyBinderFactory)converter.convert((Object)annotatedElement);
            if (propertyBinderFactory == null) continue;
            defaultBindingProfile.addBindingFactory(boundToProperty.value(), new UnwrappedExceptionPropertyBinderFactory(propertyBinderFactory));
        }
    }

    private static PropertyBinderFactory handleField(final Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !PropertyChangeListener.class.isAssignableFrom(field.getType())) {
            return null;
        }
        return new PropertyBinderFactory(){

            @Override
            public PropertyBinder createPropertyBinder(final Object object) {
                return new PropertyBinder(){

                    @Override
                    public void fireBoundPropertyChanged(PropertyChangeEvent propertyChangeEvent) throws Exception {
                        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)field.get(object);
                        if (propertyChangeListener != null) {
                            propertyChangeListener.propertyChange(propertyChangeEvent);
                        }
                    }
                };
            }
        };
    }

    private static PropertyBinderFactory handleMethod(Method method) {
        MethodContext methodContext = null;
        Class[] classArray = method.getParameterTypes();
        if (classArray.length == 0) {
            methodContext = method.getReturnType() != null && PropertyChangeListener.class.isAssignableFrom(method.getReturnType()) ? new MethodContext(){

                @Override
                boolean invokeMethod(Method method, PropertyChangeEvent propertyChangeEvent, Object object) throws Exception {
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)method.invoke(object, new Object[0]);
                    if (propertyChangeListener != null) {
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                    return true;
                }
            } : new MethodContext(){

                @Override
                Object[] getArgs(Method method, PropertyChangeEvent propertyChangeEvent) {
                    return new Object[0];
                }
            };
        } else if (AnnotationUtils.isCompatible(classArray, String.class)) {
            methodContext = new MethodContext(){

                @Override
                Object[] getArgs(Method method, PropertyChangeEvent propertyChangeEvent) {
                    return new Object[]{propertyChangeEvent.getPropertyName()};
                }
            };
        } else if (AnnotationUtils.isCompatible(classArray, Object.class)) {
            methodContext = new MethodContext(){

                @Override
                Object[] getArgs(Method method, PropertyChangeEvent propertyChangeEvent) {
                    return new Object[]{propertyChangeEvent.getNewValue()};
                }
            };
        } else if (AnnotationUtils.isCompatible(classArray, String.class, Object.class)) {
            methodContext = new MethodContext(){

                @Override
                Object[] getArgs(Method method, PropertyChangeEvent propertyChangeEvent) {
                    return new Object[]{propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue()};
                }
            };
        } else if (AnnotationUtils.isCompatible(classArray, Object.class, Object.class)) {
            methodContext = new MethodContext(){

                @Override
                Object[] getArgs(Method method, PropertyChangeEvent propertyChangeEvent) {
                    return new Object[]{propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()};
                }
            };
        } else if (AnnotationUtils.isCompatible(classArray, String.class, Object.class, Object.class)) {
            methodContext = new MethodContext(){

                @Override
                Object[] getArgs(Method method, PropertyChangeEvent propertyChangeEvent) {
                    return new Object[]{propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()};
                }
            };
        }
        return methodContext != null ? new MethodBindingFactory(method, methodContext) : null;
    }

    private static Converter<Method, PropertyBinderFactory> createMethodConverter() {
        return new Converter<Method, PropertyBinderFactory>(){

            public PropertyBinderFactory convert(Method method) {
                return DynamicProxyBindingProfileFactory.handleMethod(method);
            }
        };
    }

    private static Converter<Field, PropertyBinderFactory> createFieldConverter() {
        return new Converter<Field, PropertyBinderFactory>(){

            public PropertyBinderFactory convert(Field field) {
                return DynamicProxyBindingProfileFactory.handleField(field);
            }
        };
    }

    private static class UnwrappedExceptionPropertyBinderFactory
    implements PropertyBinderFactory {
        private final PropertyBinderFactory fFactoryImpl;

        private UnwrappedExceptionPropertyBinderFactory(PropertyBinderFactory propertyBinderFactory) {
            this.fFactoryImpl = propertyBinderFactory;
        }

        @Override
        public PropertyBinder createPropertyBinder(Object object) {
            final PropertyBinder propertyBinder = this.fFactoryImpl.createPropertyBinder(object);
            return propertyBinder != null ? new PropertyBinder(){

                @Override
                public void fireBoundPropertyChanged(PropertyChangeEvent propertyChangeEvent) throws Exception {
                    block2: {
                        try {
                            propertyBinder.fireBoundPropertyChanged(propertyChangeEvent);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Throwable throwable = invocationTargetException.getCause();
                            if (!(throwable instanceof Exception)) break block2;
                            throw (Exception)throwable;
                        }
                    }
                }
            } : null;
        }
    }

    private static class MethodBindingFactory
    implements PropertyBinderFactory {
        private final MethodContext fContext;
        private final Method fMethod;

        MethodBindingFactory(Method method, MethodContext methodContext) {
            this.fMethod = method;
            this.fContext = methodContext;
        }

        @Override
        public PropertyBinder createPropertyBinder(final Object object) {
            return new PropertyBinder(){

                @Override
                public void fireBoundPropertyChanged(PropertyChangeEvent propertyChangeEvent) throws Exception {
                    block4: {
                        Object[] objectArray;
                        if (!MethodBindingFactory.this.fMethod.isAccessible()) {
                            MethodBindingFactory.this.fMethod.setAccessible(true);
                        }
                        if (!MethodBindingFactory.this.fContext.invokeMethod(MethodBindingFactory.this.fMethod, propertyChangeEvent, object) && (objectArray = MethodBindingFactory.this.fContext.getArgs(MethodBindingFactory.this.fMethod, propertyChangeEvent)) != null) {
                            try {
                                MethodBindingFactory.this.fMethod.invoke(object, objectArray);
                            }
                            catch (Exception exception) {
                                if (exception.getCause() == null || !(exception.getCause() instanceof Exception)) break block4;
                                throw (Exception)exception.getCause();
                            }
                        }
                    }
                }
            };
        }
    }

    private static abstract class MethodContext {
        private MethodContext() {
        }

        Object[] getArgs(Method method, PropertyChangeEvent propertyChangeEvent) {
            return null;
        }

        boolean invokeMethod(Method method, PropertyChangeEvent propertyChangeEvent, Object object) throws Exception {
            return false;
        }
    }
}

