/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.plugin.TestBenchConfig;
import com.mathworks.toolbox.coder.plugin.TestBenchResult;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.toolbox.coder.plugin.TestBenchUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AutoDefiner {
    private final CoderApp fApp;
    private final ParameterRunnable<XmlReader> fWidgetUpdater;
    private final MulticastChangeListener fChangeListeners;
    private boolean fRunning;
    private boolean fCanceled;
    private boolean fCancelPending;
    private boolean fSuccessful;
    private String fError;

    public AutoDefiner(CoderApp coderApp, ParameterRunnable<XmlReader> parameterRunnable) {
        this.fApp = coderApp;
        this.fWidgetUpdater = parameterRunnable;
        this.fChangeListeners = new MulticastChangeListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public boolean isRunning() {
        return this.fRunning;
    }

    public String getError() {
        return this.fError;
    }

    public boolean isSuccessful() {
        return this.fSuccessful;
    }

    public void run(String string) {
        this.notifyRunning();
        this.createContext(string, new ParameterRunnable<TestBenchContext>(){

            public void run(TestBenchContext testBenchContext) {
                TestBenchUtils.runTestBench(testBenchContext.getConfig(), new ParameterRunnable<TestBenchResult>(){

                    public void run(TestBenchResult testBenchResult) {
                        AutoDefiner.this.processResult(testBenchResult);
                    }
                });
            }
        });
    }

    public void cancel() {
        this.fCancelPending = true;
        TestBenchUtils.interruptTestBench();
    }

    private void reset(final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AutoDefiner.this.fRunning = false;
                AutoDefiner.this.fCanceled = false;
                AutoDefiner.this.fCancelPending = false;
                AutoDefiner.this.fError = null;
                AutoDefiner.this.fSuccessful = false;
                if (bl) {
                    AutoDefiner.this.fChangeListeners.stateChanged(new ChangeEvent(this));
                }
            }
        });
    }

    private void notifyRunning() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AutoDefiner.this.reset(false);
                AutoDefiner.this.fRunning = true;
                AutoDefiner.this.fChangeListeners.stateChanged(new ChangeEvent(this));
            }
        });
    }

    private void notifyCanceled() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AutoDefiner.this.fRunning = false;
                AutoDefiner.this.fCancelPending = false;
                AutoDefiner.this.fCanceled = true;
                AutoDefiner.this.fChangeListeners.stateChanged(new ChangeEvent(this));
            }
        });
    }

    private void notifySuccessful() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AutoDefiner.this.reset(false);
                AutoDefiner.this.fSuccessful = true;
                AutoDefiner.this.fChangeListeners.stateChanged(new ChangeEvent(this));
            }
        });
    }

    private void notifyError(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AutoDefiner.this.reset(false);
                AutoDefiner.this.fError = string;
                AutoDefiner.this.fChangeListeners.stateChanged(new ChangeEvent(this));
            }
        });
    }

    private void createContext(final String string, final ParameterRunnable<TestBenchContext> parameterRunnable) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    File file = AutoDefiner.this.fApp.getModel().getEntryPoint();
                    File file2 = FileUtils.getNextNamedFile((File)file.getParentFile(), (String)"tb", (String)".m", (FileFilter[])new FileFilter[0]);
                    PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
                    printWriter.print(string);
                    printWriter.close();
                    parameterRunnable.run((Object)new TestBenchContext(file2, true));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        if (AutoDefiner.isPlainInvocation(string)) {
            new Matlab().feval("which", new Object[]{string}, 1, new CompletionObserver(){

                public void completed(int n, Object object) {
                    if (Matlab.getExecutionStatus((int)n) == 0 && object instanceof String && !((String)object).isEmpty()) {
                        parameterRunnable.run((Object)new TestBenchContext(new File((String)object), false));
                    } else {
                        runnable.run();
                    }
                }
            });
        } else {
            runnable.run();
        }
    }

    private static boolean isPlainInvocation(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (i == 0 && !Character.isJavaIdentifierStart(c) || i > 0 && !Character.isJavaIdentifierPart(c) || bl && c != ')' && c != ';') {
                return false;
            }
            if (c != '(') continue;
            bl = true;
        }
        return true;
    }

    private void processResult(final TestBenchResult testBenchResult) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AutoDefiner.this.fRunning = false;
                if (AutoDefiner.this.fCancelPending) {
                    AutoDefiner.this.notifyCanceled();
                    return;
                }
                if (testBenchResult.getMessage().isEmpty()) {
                    if (AutoDefiner.this.foundAnyTypes(testBenchResult)) {
                        AutoDefiner.this.applyResult(testBenchResult);
                        AutoDefiner.this.notifySuccessful();
                    } else {
                        AutoDefiner.this.reset(true);
                    }
                } else {
                    AutoDefiner.this.notifyError(testBenchResult.getMessage());
                }
            }
        });
    }

    private boolean foundAnyTypes(TestBenchResult testBenchResult) {
        for (String string : testBenchResult.getEntryPointTypes().values()) {
            if (!string.contains("</Input>")) continue;
            return true;
        }
        return false;
    }

    private void applyResult(final TestBenchResult testBenchResult) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Map<String, String> map = testBenchResult.getEntryPointTypes();
                FileSetInstance fileSetInstance = AutoDefiner.this.fApp.getModel().getEntryPointFileSet();
                Set set = fileSetInstance.getFiles();
                for (File file : set) {
                    String string = file.getName();
                    String string2 = string.substring(0, string.length() - 2);
                    String string3 = map.get(string2);
                    if (string3 == null) continue;
                    fileSetInstance.setCustomData(file, string3);
                    try {
                        AutoDefiner.this.fWidgetUpdater.run((Object)XmlApi.getInstance().read(string3));
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException(iOException);
                    }
                }
            }
        });
    }

    private class TestBenchContext {
        private final TestBenchConfig fConfig;
        private final boolean fSynthetic;

        TestBenchContext(File file, boolean bl) {
            this.fSynthetic = bl;
            this.fConfig = new TestBenchConfig(TestBenchRunMode.RUN_FORTYPES);
            this.fConfig.setTestBenchFile(file);
            this.fConfig.setSynthetic(bl);
            HashSet<File> hashSet = new HashSet<File>();
            hashSet.add(AutoDefiner.this.fApp.getModel().getEntryPoint());
            this.fConfig.setEntryPointFiles(hashSet);
        }

        TestBenchConfig getConfig() {
            return this.fConfig;
        }

        void dispose() {
            if (this.fSynthetic) {
                this.fConfig.getTestBenchFile().delete();
            }
        }
    }
}

