/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableContextMenuCustomizer;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.project.impl.table.VirtualComponentManager;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.ParameterRunnable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

public final class BuildErrorTable {
    private final PropertyTable<BuildError> fTable;
    private final List<BuildError> fErrors;
    private final ParameterRunnable<BuildError> fShowError;

    public BuildErrorTable(List<BuildError> list, ParameterRunnable<BuildError> parameterRunnable) {
        this.fErrors = new ArrayList<BuildError>(list);
        this.fShowError = parameterRunnable;
        ArrayList<AbstractPropertyTableColumn> arrayList = new ArrayList<AbstractPropertyTableColumn>();
        arrayList.add(new SeverityColumn());
        arrayList.add(new FunctionColumn());
        arrayList.add(new LineColumn());
        arrayList.add(new MessageColumn());
        ArrayList<PropertyTableNode> arrayList2 = new ArrayList<PropertyTableNode>();
        for (BuildError buildError : list) {
            arrayList2.add(new PropertyTableNode(null, false, Arrays.asList(buildError)));
        }
        PropertyTableModel propertyTableModel = new PropertyTableModel(arrayList, arrayList2);
        this.fTable = new PropertyTable(propertyTableModel);
        this.fTable.setName("error.table");
        this.fTable.setColumnWeights(new double[]{0.05, 0.2, 0.05, 0.7});
        this.fTable.setClickAction((ParameterRunnable)new ParameterRunnable<BuildError>(){

            public void run(BuildError buildError) {
                BuildErrorTable.this.showError(buildError);
            }
        });
        this.fTable.setSortable(true);
        this.fTable.setContextMenuCustomizer(new PropertyTableContextMenuCustomizer(){

            public void customize(MJPopupMenu mJPopupMenu, int n, int n2) {
                final BuildError buildError = (BuildError)BuildErrorTable.this.fTable.getModel().getValue(n, n2);
                if (buildError.isBoundToFunction() && buildError.getFunction().getFile().exists()) {
                    mJPopupMenu.add((Action)new MJAbstractAction(CoderResources.getString("f2f.action.openInEditor")){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Editor editor = MLEditorServices.getEditorApplication().openEditor(buildError.getFunction().getFile());
                            editor.goToLine(buildError.getLine(), 1);
                        }
                    });
                }
            }
        });
        this.fTable.getComponent().putClientProperty(this.getClass().getName(), this);
    }

    public void dispose() {
        this.fTable.dispose();
    }

    public void showFirstError(boolean bl) {
        BuildError buildError;
        Iterator<BuildError> iterator = this.fErrors.iterator();
        while (iterator.hasNext()) {
            buildError = iterator.next();
            if (buildError.getSeverity() != BuildErrorSeverity.FATAL && buildError.getSeverity() != BuildErrorSeverity.ERROR) continue;
            this.showError(buildError);
            return;
        }
        if (bl && (iterator = this.fErrors.iterator()).hasNext()) {
            buildError = iterator.next();
            this.showError(buildError);
            return;
        }
    }

    public void showError(BuildError buildError) {
        this.fShowError.run((Object)buildError);
    }

    public JComponent getComponent() {
        return this.fTable.getComponent();
    }

    public void clearSelection() {
        this.fTable.getSelectionModel().setAllowSelect(false);
        this.fTable.getSelectionModel().setAllowSelect(true);
    }

    private class MessageColumn
    extends AbstractPropertyTableColumn<BuildError> {
        public MessageColumn() {
            super(CoderResources.getString("build.error.column.message"));
        }

        public String getText(BuildError buildError) {
            return buildError.getMessage().replaceAll("\\<a href=.*\\>\\QFile: \\E.*\\Q.m Line: \\E\\d*\\Q Column: \\E\\d*\\s*\\</a\\>", "");
        }
    }

    private class LineColumn
    extends AbstractPropertyTableColumn<BuildError> {
        public LineColumn() {
            super(CoderResources.getString("build.error.column.line"));
        }

        public String getText(BuildError buildError) {
            return Integer.toString(buildError.getLine());
        }
    }

    private class FunctionColumn
    extends AbstractPropertyTableColumn<BuildError> {
        public FunctionColumn() {
            super(CoderResources.getString("build.error.column.function"));
        }

        public String getText(BuildError buildError) {
            if (buildError.getFunction() != null) {
                return buildError.getFunction().getName();
            }
            return buildError.getErrorSourceCode() != null ? buildError.getErrorSourceCode() : "";
        }
    }

    private class SeverityColumn
    extends AbstractPropertyTableColumn<BuildError> {
        public SeverityColumn() {
            super(CoderResources.getString("build.error.column.severity"));
        }

        public String getText(BuildError buildError) {
            return buildError.getSeverity().toString();
        }

        public PropertyTableDecorator<BuildError> getDecorator() {
            return new PropertyTableDecorator<BuildError>(){

                public boolean shouldPaintText(BuildError buildError) {
                    return false;
                }

                public void paintDecoration(CellPaintContext<BuildError> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, Color color, Color color2) {
                    BuildError buildError = (BuildError)cellPaintContext.getValue();
                    Rectangle2D rectangle2D = cellPaintContext.getCellRect();
                    Icon icon = buildError.getSeverity().getIcon();
                    icon.paintIcon(BuildErrorTable.this.fTable.getComponent(), graphics2D, (int)(rectangle2D.getX() + 12.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - 8.0));
                }
            };
        }
    }
}

