/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.app.ide.FileMonitor;
import com.mathworks.toolbox.coder.model.FunctionUtils;
import com.mathworks.toolbox.coder.plugin.EntryPoint;
import com.mathworks.toolbox.coder.plugin.Validator;
import com.mathworks.toolbox.coder.util.ProxyEventDispatcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EntryPointWatchService {
    private final FileSetInstance fFileSet;
    private final ProxyEventDispatcher<EntryPointObserver> fDispatcher;
    private final Map<File, EntryPointContext> fInputs;
    private final FileMonitor fFileMonitor;
    private final CoderAppModel fModel;
    private boolean fAllValid;

    EntryPointWatchService(FileSetInstance fileSetInstance, CoderAppModel coderAppModel) {
        this.fModel = coderAppModel;
        this.fFileSet = fileSetInstance;
        this.fFileMonitor = new FileMonitor();
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EntryPointWatchService.this.validateEntryPoints();
            }
        };
        this.fFileSet.addPropertyChangeListener(propertyChangeListener);
        this.fInputs = new HashMap<File, EntryPointContext>();
        this.fDispatcher = new ProxyEventDispatcher<EntryPointObserver>(EntryPointObserver.class);
        coderAppModel.addCleanupTask(new Runnable(){

            @Override
            public void run() {
                EntryPointWatchService.this.fFileSet.removePropertyChangeListener(propertyChangeListener);
                EntryPointWatchService.this.fFileMonitor.dispose();
            }
        });
        this.fFileMonitor.addFileChangeObserver(new FileMonitor.FileChangeObserver(){

            @Override
            public void fileChanged(File file) {
                EntryPointWatchService.this.validateEntryPoints();
            }
        });
        this.validateEntryPoints();
    }

    private void validateEntryPoints() {
        Object object3;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashSet<File> hashSet = new HashSet<File>(this.fInputs.keySet());
        for (Object object2 : this.fFileSet.getFiles()) {
            object3 = null;
            final List<String> list = this.parseEntryPoint((File)object2);
            final File file = object2;
            this.fFileMonitor.watchFile((File)object2);
            EntryPointContext entryPointContext = this.fInputs.get(object2);
            if (entryPointContext == null) {
                entryPointContext = new EntryPointContext();
                this.fInputs.put((File)object2, entryPointContext);
                object3 = new Runnable(){

                    @Override
                    public void run() {
                        ((EntryPointObserver)EntryPointWatchService.this.fDispatcher.getProxyDispatcher()).entryPointAddedOrRemoved(file, true);
                    }
                };
            } else if (!list.equals(entryPointContext.getInputs())) {
                final EntryPointContext entryPointContext2 = entryPointContext;
                object3 = new Runnable(){

                    @Override
                    public void run() {
                        ((EntryPointObserver)EntryPointWatchService.this.fDispatcher.getProxyDispatcher()).entryPointInputsChanged(file, entryPointContext2.getInputs(), new LinkedList<String>(list));
                    }
                };
            }
            entryPointContext.setInputs(list);
            if (object3 == null) continue;
            linkedList.add(object3);
        }
        hashSet.removeAll(this.fFileSet.getFiles());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object object2;
            object3 = object2 = (File)iterator.next();
            this.fFileMonitor.removeFile((File)object2);
            linkedList.add(new Runnable((File)object3){
                final /* synthetic */ File val$finalFile;
                {
                    this.val$finalFile = file;
                }

                @Override
                public void run() {
                    ((EntryPointObserver)EntryPointWatchService.this.fDispatcher.getProxyDispatcher()).entryPointAddedOrRemoved(this.val$finalFile, false);
                }
            });
            this.fInputs.remove(object2);
        }
        final boolean bl = this.areInputsSatisfied();
        if (bl != this.fAllValid) {
            this.fAllValid = bl;
            linkedList.add(new Runnable(){

                @Override
                public void run() {
                    ((EntryPointObserver)EntryPointWatchService.this.fDispatcher.getProxyDispatcher()).entryPointsValidityChanged(bl);
                }
            });
        }
        for (Object object3 : linkedList) {
            object3.run();
        }
    }

    private boolean areInputsSatisfied() {
        boolean bl = true;
        block0: for (EntryPointContext entryPointContext : this.fInputs.values()) {
            for (String string : entryPointContext.getInputs()) {
                if (string.equals("~")) continue;
                bl = false;
                continue block0;
            }
        }
        if (bl) {
            return true;
        }
        ArrayList arrayList = new ArrayList();
        Validator.validateEntryPoints((ReadableConfiguration)this.fModel.getConfiguration(), arrayList);
        if (this.fModel.isUsingGlobalVariables()) {
            Validator.validateGlobals((ReadableConfiguration)this.fModel.getConfiguration(), arrayList);
        }
        return arrayList.isEmpty();
    }

    @NotNull
    private List<String> parseEntryPoint(File file) {
        EntryPoint entryPoint = FunctionUtils.getEntryPoint(file);
        return entryPoint != null ? entryPoint.getInputNames() : new LinkedList<String>();
    }

    public boolean isAllValid() {
        return this.fAllValid;
    }

    public void addEntryPointObserver(EntryPointObserver entryPointObserver) {
        this.fDispatcher.addObserver(entryPointObserver);
    }

    public void removeEntryPointObserver(EntryPointObserver entryPointObserver) {
        this.fDispatcher.removeObserver(entryPointObserver);
    }

    @NotNull
    public List<String> getEntryPointInputs(File file, boolean bl) {
        LinkedList<String> linkedList;
        List<String> list = linkedList = this.fInputs.containsKey(file) ? this.fInputs.get(file).getInputs() : new LinkedList<String>();
        if (!bl) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                if (!((String)iterator.next()).equals("~")) continue;
                iterator.remove();
            }
        }
        return linkedList;
    }

    public static abstract class EntryPointObserverAdapter
    implements EntryPointObserver {
        @Override
        public void entryPointAddedOrRemoved(File file, boolean bl) {
        }

        @Override
        public void entryPointInputsChanged(File file, List<String> list, List<String> list2) {
        }

        @Override
        public void entryPointsValidityChanged(boolean bl) {
        }
    }

    public static interface EntryPointObserver {
        public void entryPointAddedOrRemoved(File var1, boolean var2);

        public void entryPointInputsChanged(File var1, List<String> var2, List<String> var3);

        public void entryPointsValidityChanged(boolean var1);
    }

    private static class EntryPointContext {
        private List<String> fInputs = new LinkedList<String>();
        private boolean fValid;

        EntryPointContext() {
        }

        void setValid(boolean bl) {
            this.fValid = bl;
        }

        void setInputs(List<String> list) {
            this.fInputs = new LinkedList<String>(list);
        }

        List<String> getInputs() {
            return new ArrayList<String>(this.fInputs);
        }

        boolean isValid() {
            return this.fValid;
        }
    }
}

