/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.HardwareImplementationWidget;
import com.mathworks.util.Converter;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public final class HardwareImplementationDialog {
    private final MJFrame fFrame;
    private final HardwareImplementationWidget fWidget;
    private final Configuration fConfiguration;
    private static Map<Project, HardwareImplementationDialog> sOpenDialogs = new HashMap<Project, HardwareImplementationDialog>();

    public static HardwareImplementationDialog invoke(Project project) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called on the EDT");
        }
        HardwareImplementationDialog hardwareImplementationDialog = sOpenDialogs.get(project);
        if (hardwareImplementationDialog == null) {
            hardwareImplementationDialog = new HardwareImplementationDialog(project);
            sOpenDialogs.put(project, hardwareImplementationDialog);
        }
        hardwareImplementationDialog.show();
        return hardwareImplementationDialog;
    }

    public void show() {
        this.fFrame.setVisible(true);
    }

    private HardwareImplementationDialog(final Project project) {
        this.fConfiguration = project.getConfiguration();
        this.fWidget = new HardwareImplementationWidget((WritableConfiguration)project.getConfiguration(), true);
        this.fFrame = new MJFrame();
        this.fFrame.setTitle(CoderResources.getString("title.hardwareImplementation"));
        this.fFrame.setName("hardwareImplementation.dialog");
        this.fFrame.add(this.fWidget.getComponent());
        this.fFrame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HardwareImplementationDialog.this.fWidget.dispose();
                sOpenDialogs.remove(project);
                new Matlab().fevalConsoleOutput("emlcprivate", new Object[]{"configObjectDialog", "destroy", project});
            }
        });
        MJButton mJButton = new MJButton(BuiltInResources.getString((String)"button.close"));
        mJButton.setName("HardwareImplementationDialog.CloseButton");
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HardwareImplementationDialog.this.fFrame.dispose();
            }
        });
        MJButton mJButton2 = new MJButton(BuiltInResources.getString((String)"button.help"));
        mJButton2.setName("HardwareImplementationDialog.HelpButton");
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Target target = HardwareImplementationDialog.this.fConfiguration.getTarget();
                String string = PluginManager.resolveHelpMapPath((String)target.getHelpMapPath());
                ParamSet paramSet = target.getParamSet("paramset.hardware");
                String string2 = HardwareImplementationDialog.this.fConfiguration.evaluateString(paramSet.getHelpTopicKey());
                if (string2 == null && target.getSettingsHelpKeyGeneratorClassName() != null) {
                    try {
                        Class<?> clazz = Class.forName(target.getSettingsHelpKeyGeneratorClassName());
                        Constructor<?> constructor = clazz.getConstructor(Configuration.class);
                        Converter converter = (Converter)constructor.newInstance(HardwareImplementationDialog.this.fConfiguration);
                        string2 = (String)converter.convert((Object)paramSet);
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(exception);
                    }
                }
                MLHelpServices.cshDisplayTopic((Object)HardwareImplementationDialog.this.fFrame, (String)string, (String)string2);
            }
        });
        JPanel jPanel = ButtonBarFactory.buildCloseHelpBar((JButton)mJButton, (JButton)mJButton2);
        jPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.fFrame.add((Component)jPanel, (Object)"South");
        this.fFrame.pack();
        this.fFrame.setMinimumSize(this.fFrame.getSize());
        WindowUtils.centerWindowOnScreen((Window)this.fFrame);
    }
}

