/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.toolbox.coder.app.FindAdapter;
import com.mathworks.toolbox.coder.app.FindPanel;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.PopupBar;
import com.mathworks.toolbox.coder.app.PopupBarContent;
import com.mathworks.toolbox.coder.app.PopupHintProvider;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class PopupBarManager {
    private final FindPanel fFindPanel;
    private final PopupBar fPopupBar;
    private final Set<Block> fBlocks;
    private final ChangeListener fChangeListener;
    private final MulticastChangeListener fMulticastChangeListener;
    private boolean fOpen;
    private PopupHintProvider fHintProvider;
    private OutputPane fOutputPane;
    private State fState;

    public PopupBarManager(Animator animator, FindAdapter findAdapter) {
        this.fFindPanel = new FindPanel(findAdapter);
        this.fPopupBar = new PopupBar(animator);
        this.fBlocks = new HashSet<Block>();
        this.fMulticastChangeListener = new MulticastChangeListener();
        this.fChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PopupBarManager.this.updateHint();
            }
        };
    }

    public PopupBar getPopupBar() {
        return this.fPopupBar;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fMulticastChangeListener.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fMulticastChangeListener.removeChangeListener(changeListener);
    }

    private void fireChange(boolean bl) {
        if (this.fOpen != bl) {
            this.fOpen = bl;
            this.fMulticastChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean isPopupBarOpen() {
        return this.fOpen;
    }

    public State getState() {
        return this.fState;
    }

    public void setOutputPane(OutputPane outputPane) {
        this.fOutputPane = outputPane;
    }

    public void setHintProvider(PopupHintProvider popupHintProvider) {
        if (this.fHintProvider != null) {
            this.fHintProvider.removeChangeListener(this.fChangeListener);
        }
        this.fHintProvider = popupHintProvider;
        if (this.fHintProvider != null) {
            this.fHintProvider.addChangeListener(this.fChangeListener);
        }
    }

    public Block block() {
        return new Block();
    }

    public void updateHint() {
        if (this.fState != State.WAITING_FOR_READY_STATE && this.fState != State.SPECIAL_HINT && this.fOutputPane != null && !this.fOutputPane.isRunningTask() && !this.fOutputPane.hasBuildErrors(BuildErrorSeverity.WARNING)) {
            String string;
            String string2 = string = this.fHintProvider == null ? null : this.fHintProvider.getCurrentHint();
            if (string != null) {
                this.fState = State.HINT;
                this.fPopupBar.update(new HintContent(string));
                this.fPopupBar.extend();
                this.fireChange(true);
            } else if (this.fState == State.HINT) {
                this.closePopup();
            }
        }
    }

    public void show(PopupBarContent popupBarContent) {
        this.fPopupBar.update(popupBarContent);
        this.fPopupBar.extend();
        this.fireChange(true);
    }

    public void showSpecialHint(String string) {
        this.fState = State.SPECIAL_HINT;
        this.fPopupBar.update(new HintContent(string));
        this.fPopupBar.extend();
        this.fireChange(true);
    }

    public void hideSpecialHint() {
        if (this.fState == State.SPECIAL_HINT) {
            this.closePopup();
        }
    }

    public JComponent getPopupBarComponent() {
        return this.fPopupBar.getComponent();
    }

    public void doFind() {
        this.fPopupBar.update(this.fFindPanel);
        this.fPopupBar.extend();
    }

    public boolean isFindOpen() {
        return this.fPopupBar.isExtended() && this.fPopupBar.getContent() == this.fFindPanel;
    }

    public void dispose() {
        if (this.fHintProvider != null) {
            this.fHintProvider.removeChangeListener(this.fChangeListener);
            this.fHintProvider.dispose();
            this.fHintProvider = null;
        }
    }

    public void closePopup() {
        this.fState = State.NO_HINT;
        this.fPopupBar.collapse(new Runnable(){

            @Override
            public void run() {
                PopupBarManager.this.fireChange(false);
            }
        });
    }

    public void enterReadyState() {
        String string;
        String string2 = string = this.fHintProvider == null ? null : this.fHintProvider.getInitialHint();
        if (string != null && !this.isFindOpen()) {
            this.fState = State.INITIAL_HINT;
            this.fPopupBar.update(new HintContent(string));
            this.fPopupBar.extend();
        }
    }

    private class HintContent
    implements PopupBarContent {
        private final String fText;
        private Component fCloseComponent;

        HintContent(String string) {
            this.fText = string;
        }

        @Override
        public JComponent createComponent(MJButton mJButton) {
            MJToolBar mJToolBar;
            this.fCloseComponent = mJButton;
            if (!PlatformInfo.isMacintosh()) {
                mJToolBar = new MJToolBar();
                mJToolBar.add((Component)mJButton);
                mJToolBar.setFloatable(false);
                mJToolBar.setOpaque(false);
                this.fCloseComponent = mJToolBar;
            }
            mJToolBar = new MJLabel(this.fText);
            MJPanel mJPanel = new MJPanel(null, (MJLabel)mJToolBar, mJButton){
                final /* synthetic */ MJLabel val$label;
                final /* synthetic */ MJButton val$closeButton;
                {
                    this.val$label = mJLabel;
                    this.val$closeButton = mJButton;
                    super(layoutManager);
                }

                public void doLayout() {
                    super.doLayout();
                    Dimension dimension = this.val$label.getPreferredSize();
                    this.val$label.setBounds(4, this.getHeight() / 2 - dimension.height / 2, dimension.width, dimension.height);
                    Dimension dimension2 = HintContent.this.fCloseComponent.getPreferredSize();
                    HintContent.this.fCloseComponent.setBounds(this.getWidth() - dimension2.width - 4, this.getHeight() / 2 - dimension2.height / 2, dimension2.width, dimension2.height);
                }

                public Dimension getPreferredSize() {
                    Dimension dimension = this.val$label.getPreferredSize();
                    Dimension dimension2 = this.val$closeButton.getPreferredSize();
                    return new Dimension(dimension.width + 8 + dimension2.width + 8, Math.max(dimension2.height, dimension.height + 8));
                }
            };
            mJPanel.setOpaque(false);
            mJPanel.add((Component)mJToolBar);
            mJPanel.add(this.fCloseComponent);
            return mJPanel;
        }

        @Override
        public void activate() {
        }

        @Override
        public void close() {
        }

        @Override
        public String getCloseButtonText() {
            return BuiltInResources.getString((String)"button.close");
        }
    }

    public class Block {
        Block() {
            if (PopupBarManager.this.fState == State.HINT || PopupBarManager.this.fState == State.SPECIAL_HINT) {
                PopupBarManager.this.closePopup();
            }
            PopupBarManager.this.fState = State.WAITING_FOR_READY_STATE;
            PopupBarManager.this.fBlocks.add(this);
        }

        public void dispose() {
            if (PopupBarManager.this.fBlocks.remove(this) && PopupBarManager.this.fBlocks.isEmpty()) {
                PopupBarManager.this.fState = State.NO_HINT;
                PopupBarManager.this.updateHint();
            }
        }
    }

    public static enum State {
        WAITING_FOR_READY_STATE,
        INITIAL_HINT,
        NO_HINT,
        SPECIAL_HINT,
        HINT;

    }
}

