/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

public final class SourceSet {
    private final Collection<ParameterRunnable<SourceSet>> fObservers;
    private final Collection<Predicate<Boolean>> fPredicates;
    private final ParameterRunnable<SourceSet> fDispatcher;
    private final Set<File> fFiles;
    private final String fKey;

    public SourceSet(String string) {
        this.fKey = string;
        this.fObservers = new LinkedList<ParameterRunnable<SourceSet>>();
        this.fFiles = new LinkedHashSet<File>();
        this.fPredicates = new LinkedList<Predicate<Boolean>>();
        this.fDispatcher = new ParameterRunnable<SourceSet>(){

            public void run(SourceSet sourceSet) {
                for (ParameterRunnable parameterRunnable : new LinkedList(SourceSet.this.fObservers)) {
                    parameterRunnable.run((Object)sourceSet);
                }
            }
        };
        this.setFiles(new HashSet<File>());
    }

    public SourceSet(String string, final FileSetInstance fileSetInstance) {
        this(string);
        fileSetInstance.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("files")) {
                    SourceSet.this.setFiles(fileSetInstance.getFiles());
                }
            }
        });
        this.setFiles(fileSetInstance.getFiles());
    }

    public void addActivationPredicate(Predicate<Boolean> predicate) {
        this.fPredicates.add(predicate);
        this.fireSourceSetChanged();
    }

    public void removeActivationPredicate(Predicate<Boolean> predicate) {
        boolean bl = this.fPredicates.remove(predicate);
        if (bl) {
            this.fireSourceSetChanged();
        }
    }

    private boolean queryPredicates(boolean bl) {
        for (Predicate<Boolean> predicate : this.fPredicates) {
            if (predicate.accept((Object)bl)) continue;
            return false;
        }
        return true;
    }

    public boolean isActivatable() {
        return this.queryPredicates(true);
    }

    public boolean isDeactivatable() {
        return this.queryPredicates(false);
    }

    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    public synchronized Set<File> getFiles() {
        return new TreeSet<File>(this.fFiles);
    }

    public synchronized void setFiles(Set<File> set) {
        if (!this.fFiles.equals(set)) {
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(this.fFiles);
            this.fFiles.clear();
            this.fFiles.addAll(set);
            this.fireSourceSetChanged();
        }
    }

    public String getKey() {
        return this.fKey;
    }

    public void addSourceSetObserver(ParameterRunnable<SourceSet> parameterRunnable) {
        this.fObservers.add(parameterRunnable);
    }

    public void removeSourceSetObserver(ParameterRunnable<SourceSet> parameterRunnable) {
        this.fObservers.remove(parameterRunnable);
    }

    public void fireSourceSetChanged() {
        this.fDispatcher.run((Object)this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SourceSet)) {
            return false;
        }
        SourceSet sourceSet = (SourceSet)object;
        if (!this.fFiles.equals(sourceSet.fFiles)) {
            return false;
        }
        if (!this.fKey.equals(sourceSet.fKey)) {
            return false;
        }
        return this.fPredicates.equals(sourceSet.fPredicates);
    }

    public int hashCode() {
        int n = this.fPredicates.hashCode();
        n = 31 * n + this.fFiles.hashCode();
        n = 31 * n + this.fKey.hashCode();
        return n;
    }
}

