/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.FontPrefs;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.model.CodeCoverageModel;
import com.mathworks.toolbox.coder.model.CoverageRegion;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.text.matlab.MatlabTokenInfo;
import com.mathworks.widgets.text.mcode.MLexer;
import com.mathworks.widgets.text.mcode.MTokenContext;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;

public class CodeCoverageBar
extends MJPanel {
    private final EditorView fEditorView;
    private final Runnable fShowOrHide;
    private CodeCoverageModel fCoverageModel;
    private Map<Integer, Double> fCoverageMap;
    private Map<Integer, String> fCoverageDescriptions;
    private Set<Integer> fSingleHits;
    private Set<Integer> fDead;
    private Set<Integer> fMaxPossible;
    private ChangeListener fCoverageListener;
    private FontMetrics fMetrics;
    private Timer fStretchTimer;
    private Timer fCheckTimer;
    private double fStretchRatio;
    private double fStretchIncrement;
    public static final String COVERAGE_BAR_PROPERTY = "coverage-bar";

    CodeCoverageBar(EditorView editorView, Font font, Runnable runnable) {
        this.fEditorView = editorView;
        this.fShowOrHide = runnable;
        this.putClientProperty(COVERAGE_BAR_PROPERTY, (Object)this);
        this.setName("CodeCoverageBar");
        this.setFont(font);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (CodeCoverageBar.this.fStretchRatio == 0.0 && CodeCoverageBar.this.fStretchTimer == null && CodeCoverageBar.this.fCoverageModel != null) {
                    CodeCoverageBar.this.startStretchTimer();
                }
            }
        });
    }

    public boolean hasModel() {
        return this.fCoverageModel != null;
    }

    public void setModel(CodeCoverageModel codeCoverageModel) {
        if (this.fCoverageModel != null) {
            this.fCoverageModel.removeChangeListener(this.fCoverageListener);
        }
        this.fCoverageModel = codeCoverageModel;
        this.fCoverageMap = new HashMap<Integer, Double>();
        this.fCoverageDescriptions = new HashMap<Integer, String>();
        this.fSingleHits = new HashSet<Integer>();
        this.fDead = new HashSet<Integer>();
        this.fMaxPossible = new HashSet<Integer>();
        if (codeCoverageModel != null) {
            this.fCoverageListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    CodeCoverageBar.this.updateCoverage();
                }
            };
            this.fCoverageModel.addChangeListener(this.fCoverageListener);
        }
        this.updateCoverage();
    }

    public void updateCoverage() {
        Function function;
        this.fCoverageMap.clear();
        this.fSingleHits.clear();
        this.fDead.clear();
        this.fMaxPossible.clear();
        if (this.fCoverageModel != null && (function = this.fEditorView.getCurrentFunction()) != null && this.fCoverageModel.isEnabled()) {
            int n;
            int n2;
            for (CoverageRegion coverageRegion : this.fCoverageModel.getCoverage(function.getFile())) {
                for (n2 = 0; n2 < coverageRegion.getLength(); ++n2) {
                    try {
                        n = this.fEditorView.getTextPane().getLineFromPos(coverageRegion.getStartIndex() + n2);
                        this.fCoverageMap.put(n, coverageRegion.getCoveragePercent());
                        if (!coverageRegion.hasMaxPossibleHits() && coverageRegion.getCoveredTimes() == 1 && coverageRegion.getEnclosingTimes() > 1) {
                            this.fSingleHits.add(n);
                        } else {
                            this.fSingleHits.remove(n);
                        }
                        if (coverageRegion.isDead()) {
                            this.fDead.add(n);
                        } else {
                            this.fDead.remove(n);
                        }
                        if (coverageRegion.hasMaxPossibleHits()) {
                            this.fMaxPossible.add(n);
                            continue;
                        }
                        this.fMaxPossible.remove(n);
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            Object object = null;
            boolean bl = false;
            this.fCoverageDescriptions = new HashMap<Integer, String>();
            for (n2 = 1; n2 <= this.fEditorView.getTextPane().getNumLines(); ++n2) {
                n = n2 - 1;
                Double d = this.getCoveragePercent(n);
                if (!(d == null || d == object || object != null && d != null && ((Double)object).equals(d))) {
                    String string = "";
                    if (this.fDead.contains(n)) {
                        string = CoderResources.getString("coverage.dead");
                    } else if (this.fMaxPossible.contains(n)) {
                        string = CoderResources.getString("coverage.max");
                    } else if (this.fSingleHits.contains(n)) {
                        string = CoderResources.getString("coverage.once");
                    } else if (d > 0.95) {
                        if (!bl) {
                            string = CoderResources.getString("coverage.complete");
                            bl = true;
                        }
                    } else if (d == 0.0) {
                        string = CoderResources.getString("coverage.none");
                    } else {
                        int n3 = (int)Math.round(d * 100.0);
                        if (n3 == 0 && d != 0.0) {
                            n3 = 1;
                        }
                        string = MessageFormat.format(CoderResources.getString("coverage.fraction"), n3);
                    }
                    if (!string.isEmpty()) {
                        this.fCoverageDescriptions.put(n2 - 1, string);
                    }
                }
                object = d;
            }
        }
        this.fShowOrHide.run();
        this.revalidate();
        this.repaint();
    }

    private void startStretchTimer() {
        if (this.fStretchTimer == null) {
            this.fStretchIncrement = 0.06;
            this.fStretchTimer = new Timer(10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CodeCoverageBar.this.fStretchIncrement *= 1.08;
                    if (CodeCoverageBar.this.isHovered()) {
                        CodeCoverageBar.this.startCheckTimer();
                        CodeCoverageBar.this.fStretchRatio += CodeCoverageBar.this.fStretchIncrement;
                        if (CodeCoverageBar.this.fStretchRatio >= 1.0) {
                            CodeCoverageBar.this.fStretchRatio = 1.0;
                            CodeCoverageBar.this.fStretchTimer.stop();
                            CodeCoverageBar.this.fStretchTimer = null;
                        }
                    } else {
                        CodeCoverageBar.this.fStretchRatio -= CodeCoverageBar.this.fStretchIncrement;
                        if (CodeCoverageBar.this.fStretchRatio <= 0.0) {
                            CodeCoverageBar.this.fStretchRatio = 0.0;
                            CodeCoverageBar.this.fStretchTimer.stop();
                            CodeCoverageBar.this.fStretchTimer = null;
                        }
                    }
                    if (CodeCoverageBar.this.fEditorView.getTextPane() != null) {
                        CodeCoverageBar.this.fEditorView.getTextPane().revalidate();
                        CodeCoverageBar.this.fEditorView.getTextPane().repaint();
                    }
                }
            });
            this.fStretchTimer.setRepeats(true);
            this.fStretchTimer.start();
        }
    }

    private void startCheckTimer() {
        if (this.fCheckTimer == null) {
            this.fCheckTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!CodeCoverageBar.this.isHovered()) {
                        CodeCoverageBar.this.startStretchTimer();
                        CodeCoverageBar.this.fCheckTimer.stop();
                        CodeCoverageBar.this.fCheckTimer = null;
                    }
                }
            });
            this.fCheckTimer.setRepeats(true);
            this.fCheckTimer.start();
        }
    }

    private boolean isHovered() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            Point point = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
            return this.contains(point);
        }
        return false;
    }

    public double getStretchRatio() {
        return this.fStretchRatio;
    }

    public boolean isSingleHit(int n) {
        return this.fSingleHits.contains(n);
    }

    public String getCoverageDescription(int n) {
        return this.fCoverageDescriptions.get(n);
    }

    public Double getCoveragePercent(int n) {
        Double d = this.fCoverageMap.get(n);
        if (d == null && !this.fCoverageMap.isEmpty()) {
            try {
                if (this.fEditorView.getTextPane().getLineText(n).trim().equals("end")) {
                    d = this.fCoverageMap.get(n);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (d != null && (d < 0.0 || d > 1.0)) {
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 1.0) {
                d = 1.0;
            }
        }
        return d;
    }

    public void paintComponent(Graphics graphics) {
        this.paintComponent(graphics, this.getBackground(), true, this.getWidth(), new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public void paintComponent(Graphics graphics, final Color color, final boolean bl, final int n, final Rectangle rectangle) {
        if (bl) {
            super.paintComponent(graphics);
        }
        final Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (PlatformInfo.isMacintosh()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        final Composite composite = graphics2D.getComposite();
        graphics2D.setFont(this.getFont());
        this.fMetrics = graphics2D.getFontMetrics(this.getFont());
        final Holder holder = new Holder((Object)0);
        final Holder holder2 = new Holder((Object)0);
        this.fEditorView.forNonFoldedLines(new ParameterRunnable<Integer>(){

            public void run(Integer n2) {
                Double d = CodeCoverageBar.this.getCoveragePercent(n2 - 1);
                if (d != null) {
                    CodeCoverageBar.this.setColor(graphics2D, d, CodeCoverageBar.this.fSingleHits.contains(n2 - 1), CodeCoverageBar.this.fMaxPossible.contains(n2 - 1), CodeCoverageBar.this.fDead.contains(n2 - 1));
                    graphics2D.fillRect(0, (Integer)holder.get(), n, CodeCoverageBar.this.fMetrics.getHeight());
                }
                if (!bl) {
                    try {
                        boolean bl3;
                        String string = CodeCoverageBar.this.fEditorView.getTextPane().getLineText(n2 - 1).replaceAll("\\t", "    ");
                        boolean bl2 = bl3 = d != null && (d > 0.5 || d == 0.0);
                        if (bl3) {
                            graphics2D.setColor(Color.WHITE);
                        } else {
                            graphics2D.setColor(Color.BLACK);
                        }
                        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                        AttributedString attributedString = CodeCoverageBar.this.makeKeywordsBold(string, bl3);
                        graphics2D.drawString(attributedString.getIterator(), 2, (Integer)holder.get() + CodeCoverageBar.this.fMetrics.getAscent());
                        holder2.set((Object)((int)Math.max((double)((Integer)holder2.get()).intValue(), graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth() + 3.0)));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                holder.set((Object)((Integer)holder.get() + CodeCoverageBar.this.fMetrics.getHeight()));
            }
        });
        if (!bl && this.fStretchRatio == 1.0) {
            holder.set((Object)0);
            this.fEditorView.forNonFoldedLines(new ParameterRunnable<Integer>(){

                public void run(Integer n) {
                    int n2 = n - 1;
                    String string = CodeCoverageBar.this.getCoverageDescription(n2);
                    Double d = CodeCoverageBar.this.getCoveragePercent(n2);
                    if (string != null) {
                        boolean bl;
                        graphics2D.setFont(FontPrefs.getTextFont().deriveFont(1));
                        int n3 = (int)graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth();
                        int n4 = (Integer)holder2.get() + 30;
                        if (rectangle.getX() + rectangle.getWidth() - (double)n3 - 3.0 < (double)n4) {
                            n4 = (int)(rectangle.getX() + rectangle.getWidth() - (double)n3 - 3.0);
                            graphics2D.setComposite(composite);
                            graphics2D.setColor(color);
                            graphics2D.fillRect(n4, (Integer)holder.get(), n3, CodeCoverageBar.this.fMetrics.getHeight());
                            CodeCoverageBar.this.setColor(graphics2D, d, CodeCoverageBar.this.fSingleHits.contains(n2), CodeCoverageBar.this.fMaxPossible.contains(n2), CodeCoverageBar.this.fDead.contains(n2));
                            graphics2D.fillRect(n4, (Integer)holder.get(), n3, CodeCoverageBar.this.fMetrics.getHeight());
                        }
                        boolean bl2 = bl = d > 0.5 || d == 0.0;
                        if (bl) {
                            graphics2D.setColor(Color.WHITE);
                        } else {
                            graphics2D.setColor(Color.BLACK);
                        }
                        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                        graphics2D.drawString(string, n4, (Integer)holder.get() + CodeCoverageBar.this.fMetrics.getAscent());
                    }
                    holder.set((Object)((Integer)holder.get() + CodeCoverageBar.this.fMetrics.getHeight()));
                }
            });
        }
        graphics2D.dispose();
    }

    private AttributedString makeKeywordsBold(String string, boolean bl) {
        AttributedString attributedString = new AttributedString(string);
        if (string.length() > 0) {
            attributedString.addAttribute(TextAttribute.FONT, this.getFont(), 0, string.length());
        }
        MatlabTokenInfo matlabTokenInfo = MLexer.getInstance().tokenizeLines(MLexer.getInstance().getInitialTokenizerState(), string.toCharArray(), 0, string.length());
        for (int i = 0; i < matlabTokenInfo.getNumTokens(); ++i) {
            if (MTokenContext.getTokenID((int)matlabTokenInfo.getToken(i)).getCategory() != MTokenContext.KEYWORDS) continue;
            attributedString.addAttribute(TextAttribute.FOREGROUND, bl ? new Color(197, 252, 255) : Color.BLUE, matlabTokenInfo.getOffset(i), matlabTokenInfo.getOffset(i) + matlabTokenInfo.getTokenLength(i));
        }
        return attributedString;
    }

    private void setColor(Graphics2D graphics2D, double d, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            graphics2D.setColor(new Color(180, 180, 180));
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        } else if (bl2) {
            graphics2D.setColor(new Color(5, 112, 9));
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        } else if (bl) {
            graphics2D.setColor(new Color(255, 160, 118));
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        } else if (d > 0.0) {
            graphics2D.setColor(new Color(5, 112, 9));
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)(0.15 + d * 0.85)));
        } else {
            graphics2D.setColor(new Color(157, 38, 35));
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.fCoverageMap == null || this.fCoverageMap.isEmpty() ? 0 : 6, (int)super.getPreferredSize().getHeight());
    }
}

