/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.impl.logui.BufferedLogSource;
import com.mathworks.toolbox.coder.app.FunctionScopedEntityLocator;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.TabbedOutputContext;
import com.mathworks.toolbox.coder.app.ide.EditorSnapshot;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.FunctionSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.IDEFileSidebar;
import com.mathworks.toolbox.coder.app.ide.IDELayout;
import com.mathworks.toolbox.coder.app.ide.IDEView;
import com.mathworks.toolbox.coder.app.ide.SelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionListener;
import com.mathworks.toolbox.coder.app.ide.Selector;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.CodeCoverageModel;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.wfa.files.CallTreeFileSetView;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public abstract class IDEContext
implements TabbedOutputContext {
    private final Set<String> fVisibleTabKeys = new HashSet<String>();
    private final Set<String> fVisibleTaskKeys = new HashSet<String>();
    private final Queue<Runnable> fWhenActiveQueue = new LinkedList<Runnable>();
    private final EditorSnapshot fEditorSnapshot;
    private final Collection<Selector> fSelectors = new LinkedList<Selector>();
    private final SelectionListener fSelectionListener;
    private IDEView fIdeView;
    private OutputPane fOutputPane;
    private EditorView fEditor;
    private IDEFileSidebar fSidebar;
    private Component fBanner;
    private CodeCoverageModel fCoverageModel;
    private Set<String> fVisibleFileSetKeys;
    private String fActiveTabKey;
    private boolean fActive;

    public IDEContext() {
        this.fEditorSnapshot = new EditorSnapshot();
        this.fSelectionListener = new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                if (IDEContext.this.fIdeView != null && IDEContext.this.fActive) {
                    IDEContext.this.fIdeView.fireSelect(selectionEvent);
                }
            }
        };
    }

    final void init(IDEView iDEView) {
        this.fIdeView = iDEView;
    }

    public void activate(IDEFileSidebar iDEFileSidebar, IDELayout iDELayout, OutputPane outputPane, EditorView editorView) {
        this.fSidebar = iDEFileSidebar;
        this.fOutputPane = outputPane;
        this.fEditor = editorView;
        this.fActive = true;
        editorView.restoreEditorSnapshot(this.fEditorSnapshot);
        this.fIdeView.selectFile(true, false);
        iDEFileSidebar.reset();
        this.activateOutputPane(outputPane);
        iDEFileSidebar.setSupportedFileSetKeys(this.fVisibleFileSetKeys);
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.fWhenActiveQueue);
        this.fWhenActiveQueue.clear();
        for (Runnable runnable : arrayList) {
            runnable.run();
        }
    }

    public void addSelector(Selector selector) {
        this.fSelectors.add(selector);
        selector.addSelectionListener(this.fSelectionListener);
    }

    public void removeSelector(Selector selector) {
        this.fSelectors.remove(selector);
        selector.removeSelectionListener(this.fSelectionListener);
    }

    Collection<Selector> getSelectors() {
        return new LinkedList<Selector>(this.fSelectors);
    }

    private void activateOutputPane(OutputPane outputPane) {
        if (outputPane.getTabbedPane() != null) {
            for (String string : outputPane.getTabbedPane().getKeys()) {
                outputPane.setTabVisible(string, this.fVisibleTabKeys.contains(string));
            }
        }
        outputPane.setVisibleTaskKeys(this.fVisibleTaskKeys);
        if (this.fActiveTabKey != null) {
            this.fOutputPane.activateTab(this.fActiveTabKey);
        }
        if (this.fBanner != null) {
            outputPane.showBanner(this.fBanner);
        } else {
            this.fOutputPane.clearBanner();
        }
    }

    public void deactivate() {
        this.fActive = false;
        Collection<CallTreeFileSetView> collection = this.getSidebar().getFileSetViewsByType(CallTreeFileSetView.class);
        if (collection != null) {
            for (CallTreeFileSetView callTreeFileSetView : collection) {
                callTreeFileSetView.closeCallHierarchy();
            }
        }
        this.fEditor.takeEditorSnapshot(this.fEditorSnapshot);
        this.fEditor.reset();
    }

    public abstract CodePopupController createCodePopupController(Window var1, EditorView var2);

    public void setCoverageModel(final CodeCoverageModel codeCoverageModel) {
        this.whenActive(new Runnable(){

            @Override
            public void run() {
                IDEContext.this.fCoverageModel = codeCoverageModel;
                IDEContext.this.fEditor.setCoverageModel(codeCoverageModel);
            }
        });
    }

    public void showBanner(final Component component) {
        this.whenActive(new Runnable(){

            @Override
            public void run() {
                IDEContext.this.fBanner = component;
                IDEContext.this.fOutputPane.showBanner(component);
            }
        });
    }

    public void clearBanner() {
        this.whenActive(new Runnable(){

            @Override
            public void run() {
                IDEContext.this.fBanner = null;
                IDEContext.this.fOutputPane.clearBanner();
            }
        });
    }

    public void sidebarFunctionChanged(Function function) {
    }

    public void addTab(final String string, final String string2, final Component component) {
        this.whenActive(new Runnable(){

            @Override
            public void run() {
                IDEContext.this.fVisibleTabKeys.add(string);
                IDEContext.this.fOutputPane.getTabbedPane().addTab(string, string2, component);
            }
        });
    }

    @Override
    public void runWithoutLog(final DeploymentProcess deploymentProcess) {
        this.whenActive(new Runnable(){

            @Override
            public void run() {
                IDEContext.this.fOutputPane.runWithoutLog(deploymentProcess);
            }
        });
    }

    @Override
    public void runWithLog(final String string, final String string2, final DeploymentProcess deploymentProcess) {
        this.whenActive(new Runnable(){

            @Override
            public void run() {
                IDEContext.this.fVisibleTaskKeys.add(string);
                IDEContext.this.fVisibleTabKeys.add("output");
                IDEContext.this.fOutputPane.runWithLog(string, string2, deploymentProcess);
            }
        });
    }

    @Override
    public void runWithLog(final String string, final String string2, final DeploymentProcess deploymentProcess, final Runnable runnable, final String string3, final Predicate<BufferedLogSource> predicate) {
        this.whenActive(new Runnable(){

            @Override
            public void run() {
                IDEContext.this.fVisibleTaskKeys.add(string);
                IDEContext.this.fOutputPane.runWithLog(string, string2, deploymentProcess, runnable, string3, (Predicate<BufferedLogSource>)predicate);
            }
        });
    }

    @Override
    public void activateTab(final String string) {
        this.whenActive(new Runnable(){

            @Override
            public void run() {
                IDEContext.this.fOutputPane.activateTab(string);
                IDEContext.this.fActiveTabKey = string;
            }
        });
    }

    @Override
    public void showErrors(final String string, final String string2, final String string3, final boolean bl, final boolean bl2, final Component component, final List<BuildError> list) {
        this.whenActive(new Runnable(){

            @Override
            public void run() {
                IDEContext.this.fVisibleTabKeys.add("output");
                IDEContext.this.fVisibleTaskKeys.add(string);
                IDEContext.this.fOutputPane.showErrors(string, string2, string3, bl, bl2, component, list);
            }
        });
    }

    public void setVisibleFileSetKeys(final String ... stringArray) {
        this.whenActive(new Runnable(){

            @Override
            public void run() {
                IDEContext.this.fVisibleFileSetKeys = stringArray.length > 0 ? new HashSet<String>(Arrays.asList(stringArray)) : null;
                IDEContext.this.fSidebar.setSupportedFileSetKeys(IDEContext.this.fVisibleFileSetKeys);
            }
        });
    }

    private void whenActive(final Runnable runnable) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (IDEContext.this.fActive) {
                    runnable.run();
                } else {
                    IDEContext.this.fWhenActiveQueue.offer(runnable);
                }
            }
        });
    }

    public Predicate<File> getOutputFileSetFilter() {
        return null;
    }

    public IDEFileSidebar getSidebar() {
        return this.fSidebar;
    }

    public final OutputPane getOutputPane() {
        return this.fOutputPane;
    }

    public void select(SelectionEvent selectionEvent) {
        this.fIdeView.fireSelect(selectionEvent);
    }

    public void select(Function function) {
        this.fIdeView.fireSelect(new FunctionSelectionEvent(null, function));
    }

    public void setLocator(FunctionScopedEntityLocator functionScopedEntityLocator) {
        if (this.fActive) {
            this.fEditor.setEntityLocator(functionScopedEntityLocator);
        } else {
            this.fEditorSnapshot.setLocator(functionScopedEntityLocator);
        }
    }

    public void dispose() {
        if (this.fOutputPane != null) {
            this.fOutputPane.dispose();
        }
        if (this.fCoverageModel != null) {
            this.fCoverageModel.dispose();
        }
    }
}

