/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

final class LineNumberPane
extends MJPanel {
    private final EditorView fEditor;
    private int fLines;
    private int fPreferredWidth;
    private int fHoverLine;
    private FontMetrics fMetrics;
    private Timer fHoverTimer;

    LineNumberPane(Font font, EditorView editorView) {
        this.fEditor = editorView;
        this.setFont(font);
        this.update();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n;
                if (LineNumberPane.this.fMetrics != null && (n = mouseEvent.getY() / LineNumberPane.this.fMetrics.getHeight() + 1) != LineNumberPane.this.fHoverLine) {
                    LineNumberPane.this.fHoverLine = n;
                    if (LineNumberPane.this.fHoverLine > 0 && LineNumberPane.this.fHoverLine <= LineNumberPane.this.fLines) {
                        LineNumberPane.this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    LineNumberPane.this.startHoverTimer();
                    LineNumberPane.this.revalidate();
                    LineNumberPane.this.repaint();
                }
                LineNumberPane.this.revalidate();
                LineNumberPane.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (LineNumberPane.this.fEditor.isExplicitFile() && mouseEvent.getClickCount() == 1 && LineNumberPane.this.fHoverLine > 0 && LineNumberPane.this.fHoverLine <= LineNumberPane.this.fLines) {
                    Editor editor = MLEditorServices.getEditorApplication().openEditor(LineNumberPane.this.fEditor.getCurrentFile());
                    editor.goToLine(LineNumberPane.this.fHoverLine, 1);
                }
            }
        });
    }

    void update() {
        this.fLines = this.fEditor.getTextPane().getNumLines();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setFont(this.getFont());
        this.fPreferredWidth = 6 + (int)Math.ceil(this.getFont().getStringBounds(Integer.toString(this.fLines), graphics2D.getFontRenderContext()).getWidth());
        this.revalidate();
        this.repaint();
    }

    private void startHoverTimer() {
        if (this.fHoverTimer == null) {
            this.fHoverTimer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Point point;
                    PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                    if (pointerInfo != null && (point = pointerInfo.getLocation()) != null) {
                        SwingUtilities.convertPointFromScreen(point, (Component)((Object)LineNumberPane.this));
                        if (point.getX() < 0.0 || point.getX() > (double)LineNumberPane.this.getWidth() || (int)(point.getY() / (double)LineNumberPane.this.fMetrics.getHeight()) + 1 > LineNumberPane.this.fLines || point.getY() < 0.0) {
                            LineNumberPane.this.fHoverLine = 0;
                            LineNumberPane.this.fHoverTimer.stop();
                            LineNumberPane.this.fHoverTimer = null;
                            LineNumberPane.this.setCursor(Cursor.getDefaultCursor());
                            LineNumberPane.this.revalidate();
                            LineNumberPane.this.repaint();
                        }
                    }
                }
            });
            this.fHoverTimer.setRepeats(true);
            this.fHoverTimer.start();
        }
    }

    public void paintComponent(final Graphics graphics) {
        super.paintComponent(graphics);
        if (PlatformInfo.isMacintosh()) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics.setFont(this.getFont());
        graphics.setColor(Color.DARK_GRAY);
        this.fMetrics = graphics.getFontMetrics(this.getFont());
        this.fEditor.forNonFoldedLines(new ParameterRunnable<Integer>(){
            private int iY = 0;
            private int iDigitCount = 0;
            private int iDigitX = 0;

            public void run(Integer n) {
                Object object;
                if ((double)this.iDigitCount != Math.ceil(Math.log(n + 1) / Math.log(10.0))) {
                    object = (Graphics2D)graphics;
                    this.iDigitCount = (int)Math.ceil(Math.log(n + 1) / Math.log(10.0));
                    this.iDigitX = LineNumberPane.this.getWidth() - 3 - (int)Math.ceil(LineNumberPane.this.getFont().getStringBounds(Integer.toString(n), ((Graphics2D)object).getFontRenderContext()).getWidth());
                }
                object = Integer.toString(n);
                graphics.drawString((String)object, this.iDigitX, this.iY + LineNumberPane.this.fMetrics.getAscent());
                if (n == LineNumberPane.this.fHoverLine) {
                    graphics.drawLine(this.iDigitX, this.iY + LineNumberPane.this.fMetrics.getAscent() + 1, (int)((double)this.iDigitX + LineNumberPane.this.fMetrics.getStringBounds((String)object, graphics).getWidth()), this.iY + LineNumberPane.this.fMetrics.getAscent() + 1);
                }
                this.iY += LineNumberPane.this.fMetrics.getHeight();
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.fPreferredWidth, (int)super.getPreferredSize().getHeight());
    }
}

