/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.model.TestFileSubset;
import com.mathworks.toolbox.coder.plugin.Utilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectDataAdapter
implements FixedPointDataAdapter {
    protected final Configuration fConfiguration;
    protected String fInstrumentedMexFileKey;
    protected String fInstrumentedBuildChecksumKey;
    protected String fValidationChecksumKey;
    protected String fSourceCodeChecksumKey;
    protected String fVerificationLoggingKey;
    protected String fOverflowDetectionKey;
    protected String fStaticAnalysisChecksumKey;
    protected String fStaticAnalysisGlobalRangesOnlyKey;
    protected String fStaticAnalysisTimeoutKey;
    protected String fHistogramLoggingKey;
    protected String fCoverageKey;
    protected String fEntryPointFileSetKey;
    protected String fDefaultTestFileKey;
    protected String fDefaultWordLengthKey;
    protected String fDefaultFractionLengthKey;
    protected String fUserFixedPointDataKey;
    protected String fComputedFixedPointDataKey;
    protected String fFunctionReplacementsKey;
    protected String fExcludedVerificationFilesKey;
    protected String fExcludedSimulationFilesKey;
    protected String fSafetyMarginKey;
    protected String fProposalSourceKey;
    protected String fGeneratedFileSuffixKey;
    protected String fFimathKey;
    protected String fProposeContainerTypes;
    protected String fOptimizeWholeNumbersKey;
    protected String fTransformLoopIndexVariablesKey;
    protected String fDefaultSignednessKey;
    protected String fSpecifiedBuildFolderKey;
    protected String fSpecifiedWorkingFolderKey;
    protected String fSearchPathsKey;
    protected String fPlotFunction;
    protected String fSDIPlot;
    protected String fEnableEfficiencyChecks;
    private ParamWidgetBinder fBinder;
    private final List<PropertyChangeListener> fListeners = new ArrayList<PropertyChangeListener>();

    protected AbstractProjectDataAdapter(Configuration configuration) {
        this.fConfiguration = configuration;
    }

    protected ParamWidgetBinder getBinder() {
        if (this.fBinder == null) {
            this.fBinder = new ParamWidgetBinder(this.fConfiguration.getProject(), false);
        }
        return this.fBinder;
    }

    @Override
    public void dispose() {
        for (PropertyChangeListener propertyChangeListener : this.fListeners) {
            this.fConfiguration.removePropertyChangeListener(propertyChangeListener);
        }
        if (this.fBinder != null) {
            this.fBinder.dispose();
        }
        this.fListeners.clear();
    }

    @Override
    public final Configuration getConfiguration() {
        return this.fConfiguration;
    }

    @Override
    public final String generateMexInputChecksum() {
        CRC32 cRC32 = new CRC32();
        cRC32.update(this.isHistogramLoggingEnabled() ? 1 : 0);
        cRC32.update(this.isCoverageEnabled() ? 1 : 0);
        cRC32.update(this.getBuildPath().getBytes());
        for (File file : this.getEntryPoints()) {
            long l = file.length();
            long l2 = file.lastModified();
            cRC32.update(file.getAbsolutePath().getBytes());
            cRC32.update((int)(l >>> 32));
            cRC32.update((int)(l & 0xFFFFFFFFFFFFFFFFL));
            cRC32.update((int)(l2 >>> 32));
            cRC32.update((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
            XmlReader xmlReader = this.fConfiguration.getFileSet(this.fEntryPointFileSetKey).getCustomData(file);
            if (xmlReader == null) continue;
            cRC32.update(xmlReader.getXML().getBytes());
        }
        return Long.toString(cRC32.getValue());
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fListeners.add(propertyChangeListener);
        this.fConfiguration.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fListeners.remove(propertyChangeListener);
        this.fConfiguration.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public final String fileToReference(File file) {
        FileLocation fileLocation = new FileLocation(file);
        FileLocation fileLocation2 = new FileLocation(this.fConfiguration.getFile());
        if (fileLocation.hasPrefix(fileLocation2.getParent())) {
            return AbstractProjectDataAdapter.relativeToProjectRoot(fileLocation.stripPrefix(fileLocation2.getParent()).toString());
        }
        return file.getAbsolutePath();
    }

    private static String relativeToProjectRoot(String string) {
        while (string.startsWith("/") || string.startsWith("\\")) {
            string = string.substring(1);
        }
        return "$(PROJECTDIR)" + File.separator + string;
    }

    @Override
    public final File referenceToFile(String string) {
        if (string.startsWith("$(PROJECTDIR)")) {
            string = string.substring(13).replace('\\', File.separatorChar).replace('/', File.separatorChar);
            return new File(this.fConfiguration.getFile().getParentFile(), string);
        }
        return new File(string);
    }

    @Override
    public final File getInstrumentedMexFile() {
        return this.fConfiguration.getParamAsFile(this.fInstrumentedMexFileKey);
    }

    @Override
    public final void setInstrumentedMexFile(File file) {
        this.fConfiguration.setParamAsFile(this.fInstrumentedMexFileKey, file);
    }

    @Override
    public final String getMexInputChecksum() {
        return this.fConfiguration.getParamAsString(this.fInstrumentedBuildChecksumKey);
    }

    @Override
    public final void setMexInputChecksum(String string) {
        this.fConfiguration.setParamAsString(this.fInstrumentedBuildChecksumKey, string);
    }

    @Override
    public final String getSourceCodeChecksum() {
        return this.fConfiguration.getParamAsString(this.fSourceCodeChecksumKey);
    }

    @Override
    public final void setSourceCodeChecksum(String string) {
        this.fConfiguration.setParamAsString(this.fSourceCodeChecksumKey, string);
    }

    @Override
    public final String getValidationChecksum() {
        return this.fConfiguration.getParamAsString(this.fValidationChecksumKey);
    }

    @Override
    public final void setValidationChecksum(String string) {
        this.fConfiguration.setParamAsString(this.fValidationChecksumKey, string);
    }

    @Override
    public final String getStaticAnalysisChecksum() {
        return this.fConfiguration.getParamAsString(this.fStaticAnalysisChecksumKey);
    }

    @Override
    public void setStaticAnalysisChecksum(String string) {
        this.fConfiguration.setParamAsString(this.fStaticAnalysisChecksumKey, string);
    }

    @Override
    public boolean isStaticAnalysisLimitedToGlobalRanges() {
        return this.fConfiguration.getParamAsBoolean(this.fStaticAnalysisGlobalRangesOnlyKey);
    }

    @Override
    public String getStaticAnalysisLimitedToGlobalRangesKey() {
        return this.fStaticAnalysisGlobalRangesOnlyKey;
    }

    @Override
    public double getStaticAnalysisTimeoutMinutes() {
        String string = this.fConfiguration.getParamAsString(this.fStaticAnalysisTimeoutKey);
        try {
            return Double.parseDouble(string.trim());
        }
        catch (Exception exception) {
            return Double.POSITIVE_INFINITY;
        }
    }

    @Override
    public final String getVerificationLoggingKey() {
        return this.fVerificationLoggingKey;
    }

    @Override
    public final boolean isVerificationLoggingEnabled() {
        return this.fConfiguration.getParamAsBoolean(this.fVerificationLoggingKey);
    }

    @Override
    public final void setVerificationLoggingEnabled(boolean bl) {
        this.fConfiguration.setParamAsBoolean(this.fVerificationLoggingKey, bl);
    }

    @Override
    public final String getOverflowDetectionKey() {
        return this.fOverflowDetectionKey;
    }

    @Override
    public final boolean isOverflowDetectionEnabled() {
        return this.fConfiguration.getParamAsBoolean(this.fOverflowDetectionKey);
    }

    @Override
    public final void setOverflowDetectionEnabled(boolean bl) {
        this.fConfiguration.setParamAsBoolean(this.fOverflowDetectionKey, bl);
    }

    @Override
    public final boolean isCoverageEnabled() {
        return this.fConfiguration.getParamAsBoolean(this.fCoverageKey);
    }

    @Override
    public final void setCoverageEnabled(boolean bl) {
        this.fConfiguration.setParamAsBoolean(this.fCoverageKey, bl);
    }

    @Override
    public final String getHistogramKey() {
        return this.fHistogramLoggingKey;
    }

    @Override
    public final String getCoverageKey() {
        return this.fCoverageKey;
    }

    @Override
    public final String getStaticAnalysisTimeoutKey() {
        return this.fStaticAnalysisTimeoutKey;
    }

    @Override
    public final String getQuickStaticAnalysisKey() {
        return this.fStaticAnalysisGlobalRangesOnlyKey;
    }

    @Override
    public final boolean isHistogramLoggingEnabled() {
        return this.fConfiguration.getParamAsBoolean(this.fHistogramLoggingKey);
    }

    @Override
    public final void setHistogramLoggingEnabled(boolean bl) {
        this.fConfiguration.setParamAsBoolean(this.fHistogramLoggingKey, bl);
    }

    @Override
    public final Set<File> getEntryPoints() {
        return this.fConfiguration.getFileSet(this.fEntryPointFileSetKey).getFiles();
    }

    @Override
    public final Set<File> getTestFiles() {
        return Utilities.getTestFileSet((ReadableConfiguration)this.fConfiguration).getFiles();
    }

    @Override
    public final void addTestFile(File file) {
        Utilities.getTestFileSet((ReadableConfiguration)this.fConfiguration).add(new HashSet<File>(Arrays.asList(file)));
        if (this.getDefaultTestFile() == null) {
            this.setDefaultTestFile(file);
        }
    }

    @Override
    public final void removeTestFile(File file) {
        Utilities.getTestFileSet((ReadableConfiguration)this.fConfiguration).remove(Arrays.asList(file));
        if (this.getDefaultTestFile() != null && this.getDefaultTestFile().equals(file)) {
            this.setDefaultTestFile(null);
        }
    }

    @Override
    public final File getDefaultTestFile() {
        return this.fConfiguration.getParamAsFile(this.fDefaultTestFileKey);
    }

    @Override
    public final void setDefaultTestFile(File file) {
        this.fConfiguration.setParamAsFile(this.fDefaultTestFileKey, file);
    }

    @Override
    public final int getDefaultFractionLength() {
        return this.fConfiguration.getParamAsInt(this.fDefaultFractionLengthKey);
    }

    @Override
    public final void setDefaultFractionLength(int n) {
        this.fConfiguration.setParamAsInt(this.fDefaultFractionLengthKey, n);
    }

    @Override
    public final int getDefaultWordLength() {
        return this.fConfiguration.getParamAsInt(this.fDefaultWordLengthKey);
    }

    @Override
    public final void setDefaultWordLength(int n) {
        this.fConfiguration.setParamAsInt(this.fDefaultWordLengthKey, n);
    }

    @Override
    public final void setUserFixedPointData(XmlReader xmlReader) {
        this.fConfiguration.setParamAsXml(this.fUserFixedPointDataKey, xmlReader);
    }

    @Override
    public final XmlReader getUserFixedPointData() {
        return (XmlReader)this.fConfiguration.getParamAsObject(this.fUserFixedPointDataKey);
    }

    @Override
    public final void setComputedFixedPointData(XmlReader xmlReader) {
        if (this.fComputedFixedPointDataKey != null) {
            this.fConfiguration.setParamAsXml(this.fComputedFixedPointDataKey, xmlReader);
        }
    }

    @Override
    public final XmlReader getComputedFixedPointData() {
        return (XmlReader)this.fConfiguration.getParamAsObject(this.fComputedFixedPointDataKey);
    }

    @Override
    public final void setFunctionReplacements(XmlReader xmlReader) {
        this.fConfiguration.setParamAsXml(this.fFunctionReplacementsKey, xmlReader);
    }

    @Override
    public final XmlReader getFunctionReplacements() {
        return (XmlReader)this.fConfiguration.getParamAsObject(this.fFunctionReplacementsKey);
    }

    @Override
    public final double getSafetyMargin() {
        Object object = this.fConfiguration.getParamAsObject(this.fSafetyMarginKey);
        return ((Number)object).doubleValue();
    }

    @Override
    public final void setSafetyMargin(double d) {
        this.fConfiguration.setParamAsObject(this.fSafetyMarginKey, (Object)d);
    }

    @Override
    public final String getGeneratedFileSuffix() {
        return this.fConfiguration.getParamAsString(this.fGeneratedFileSuffixKey);
    }

    @Override
    public final void setGeneratedFileSuffix(String string) {
        this.fConfiguration.setParamAsString(this.fGeneratedFileSuffixKey, string);
    }

    @Override
    public final String getFimath() {
        return this.fConfiguration.getParamAsString(this.fFimathKey);
    }

    @Override
    public final String getDefaultFimath() {
        return this.fConfiguration.getParamDefaultValue(this.fFimathKey).toString();
    }

    @Override
    public final void setFimath(String string) {
        this.fConfiguration.setParamAsString(this.fFimathKey, string);
    }

    @Override
    public boolean isInstrumentedBuildChange(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().equals(this.fInstrumentedMexFileKey) || propertyChangeEvent.getPropertyName().equals(this.fInstrumentedBuildChecksumKey);
    }

    @Override
    public boolean isFimathChange(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().equals(this.fFimathKey);
    }

    @Override
    public boolean isProposeContainerTypesEnabled() {
        return this.fProposeContainerTypes == null || this.fConfiguration.getParamAsBoolean(this.fProposeContainerTypes);
    }

    @Override
    public void setProposeContainerTypes(boolean bl) {
        if (this.fProposeContainerTypes != null) {
            this.fConfiguration.setParamAsBoolean(this.fProposeContainerTypes, bl);
        }
    }

    @Override
    public boolean isOptimizeWholeNumbersEnabled() {
        return this.fOptimizeWholeNumbersKey == null || this.fConfiguration.getParamAsBoolean(this.fOptimizeWholeNumbersKey);
    }

    @Override
    public final void setOptimizeWholeNumbersEnabled(boolean bl) {
        if (this.fOptimizeWholeNumbersKey != null) {
            this.fConfiguration.setParamAsBoolean(this.fOptimizeWholeNumbersKey, bl);
        }
    }

    @Override
    public boolean isTransformLoopIndexVariablesEnabled() {
        return this.fConfiguration.getParamAsBoolean(this.fTransformLoopIndexVariablesKey);
    }

    @Override
    public boolean isDefaultSignednessAutomatic() {
        String string = this.fConfiguration.getParamAsString(this.fDefaultSignednessKey);
        return string == null || string.endsWith(".Automatic");
    }

    @Override
    public boolean isDefaultSignednessUnsigned() {
        String string = this.fConfiguration.getParamAsString(this.fDefaultSignednessKey);
        return string != null && string.endsWith(".Unsigned");
    }

    @Override
    public final TestFileSubset getSimulationTestFiles() {
        return new TestFileSubsetImpl(this.fExcludedSimulationFilesKey);
    }

    @Override
    public final TestFileSubset getVerificationTestFiles() {
        return new TestFileSubsetImpl(this.fExcludedVerificationFilesKey);
    }

    @Override
    public final String getPlotFunction() {
        return this.fConfiguration.getParamAsString(this.fPlotFunction);
    }

    @Override
    public final void setPlotFunction(String string) {
        this.fConfiguration.setParamAsString(this.fPlotFunction, string);
    }

    @Override
    public final boolean isEnableEfficiencyChecks() {
        return this.fConfiguration.getParamAsBoolean(this.fEnableEfficiencyChecks);
    }

    @Override
    public final void setEnableEfficiencyChecks(boolean bl) {
        this.fConfiguration.setParamAsBoolean(this.fEnableEfficiencyChecks, bl);
    }

    @Override
    public final boolean plotWithSDI() {
        return this.fConfiguration.getParamAsBoolean(this.fSDIPlot);
    }

    @Override
    public final void setPlotWithSDI(boolean bl) {
        this.fConfiguration.setParamAsBoolean(this.fSDIPlot, bl);
    }

    @Override
    public final String getBuildPath() {
        File file = this.fConfiguration.getFile().getParentFile();
        if (this.isBuildFolderProject()) {
            return file.getAbsolutePath();
        }
        if (this.isBuildFolderSpecified()) {
            String string = AbstractProjectDataAdapter.trimPath(this.fConfiguration.getParamAsString(this.fSpecifiedBuildFolderKey));
            if (new File(string).isAbsolute()) {
                return string;
            }
            return new File(file, string).getAbsolutePath();
        }
        return Utilities.getCurrentDirectory().getAbsolutePath();
    }

    @Override
    public final String getWorkingPath() {
        File file = this.fConfiguration.getFile().getParentFile();
        if (this.isWorkingFolderProject()) {
            return file.getAbsolutePath();
        }
        if (this.isWorkingFolderSpecified()) {
            String string = AbstractProjectDataAdapter.trimPath(this.fConfiguration.getParamAsString(this.fSpecifiedWorkingFolderKey));
            if (new File(string).isAbsolute()) {
                return string;
            }
            return new File(file, string).getAbsolutePath();
        }
        return Utilities.getCurrentDirectory().getAbsolutePath();
    }

    @Override
    public final String[] getSearchPaths() {
        File file = this.fConfiguration.getFile().getParentFile();
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.fConfiguration.getParamAsStringList(this.fSearchPathsKey);
        for (String string : list) {
            if (new File(string).isAbsolute()) {
                arrayList.add(string);
                continue;
            }
            arrayList.add(new File(file, string).getAbsolutePath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String trimPath(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim();
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            return string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    @Override
    public boolean isAdvancedTypeProposalSetting(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().equals(this.fSafetyMarginKey) || propertyChangeEvent.getPropertyName().equals(this.fProposalSourceKey) || propertyChangeEvent.getPropertyName().equals(this.fOptimizeWholeNumbersKey) || propertyChangeEvent.getPropertyName().equals(this.fDefaultSignednessKey) || propertyChangeEvent.getPropertyName().equals(this.fProposeContainerTypes);
    }

    @Override
    public Map<FixedPointDataAdapter.SettingsCategory, List<Param>> getCategorizedAdvancedSettings() {
        LinkedHashMap<FixedPointDataAdapter.SettingsCategory, List<Param>> linkedHashMap = new LinkedHashMap<FixedPointDataAdapter.SettingsCategory, List<Param>>();
        linkedHashMap.put(FixedPointDataAdapter.SettingsCategory.ADVANCED, this.keysToParams(this.fProposalSourceKey, this.fProposeContainerTypes, this.fOptimizeWholeNumbersKey, this.fDefaultSignednessKey, this.fSafetyMarginKey));
        linkedHashMap.put(FixedPointDataAdapter.SettingsCategory.FIACCEL, this.getFiaccelParams());
        linkedHashMap.put(FixedPointDataAdapter.SettingsCategory.FILE, this.keysToParams(this.fGeneratedFileSuffixKey));
        linkedHashMap.put(FixedPointDataAdapter.SettingsCategory.PLOTTING, this.keysToParams(this.fPlotFunction, this.fSDIPlot, this.fEnableEfficiencyChecks));
        return linkedHashMap;
    }

    protected List<Param> getFiaccelParams() {
        LinkedList<Param> linkedList = new LinkedList<Param>();
        for (ParamSet paramSet : this.fConfiguration.getTarget().getParamSets()) {
            for (Param param : paramSet.getParams()) {
                if (!param.getExtraAttributes().containsKey("_fiaccel") || !((String)param.getExtraAttributes().get("_fiaccel")).equals("true")) continue;
                linkedList.add(param);
            }
        }
        return linkedList;
    }

    protected List<Param> keysToParams(String ... stringArray) {
        ArrayList<Param> arrayList = new ArrayList<Param>();
        for (String string : stringArray) {
            Param param;
            Param param2 = param = string != null ? this.fConfiguration.getTarget().getParam(string) : null;
            if (param == null) continue;
            arrayList.add(param);
        }
        return arrayList;
    }

    protected final void setFixedPointTypeSource(String string, @Nullable Boolean bl, @Nullable Boolean bl2) {
        boolean bl3;
        assert (bl != null || bl2 != null);
        String string2 = this.fConfiguration.getParamAsString(string);
        boolean bl4 = string2.contains("Sim");
        boolean bl5 = string2.contains("Derived");
        boolean bl6 = bl != null && bl != false || bl4;
        boolean bl7 = bl3 = bl2 != null && bl2 != false || bl5;
        if (bl6 && bl3) {
            string2 = "option.FixedPointTypeSource.SimAndDerived";
        } else if (bl6 && !bl4) {
            string2 = "option.FixedPointTypeSource.Sim";
        } else if (bl3 && !bl5) {
            string2 = "option.FixedPointTypeSource.Derived";
        }
        this.fConfiguration.setParamAsString(string, string2);
    }

    protected abstract boolean isBuildFolderProject();

    protected abstract boolean isWorkingFolderSpecified();

    protected abstract boolean isWorkingFolderProject();

    protected final void setSignedness(String string, boolean bl, boolean bl2) {
        String string2 = bl ? "Automatic" : (bl2 ? "Unsigned" : "Signed");
        this.fConfiguration.setParamAsString(this.fDefaultSignednessKey, string + '.' + string2);
    }

    private class TestFileSubsetImpl
    implements TestFileSubset {
        private final String fExcludedKey;

        TestFileSubsetImpl(String string) {
            this.fExcludedKey = string;
        }

        @Override
        public Set<File> getExcludedFiles() {
            HashSet<File> hashSet = new HashSet<File>();
            XmlReader xmlReader = (XmlReader)AbstractProjectDataAdapter.this.fConfiguration.getParamAsObject(this.fExcludedKey);
            if (xmlReader != null) {
                XmlReader xmlReader2 = xmlReader.getChild(new String[]{"file"});
                while (xmlReader2.isPresent()) {
                    String string = xmlReader2.readAttribute("reference");
                    if (string != null) {
                        File file = AbstractProjectDataAdapter.this.referenceToFile(string);
                        hashSet.add(file);
                    }
                    xmlReader2 = xmlReader2.next();
                }
            }
            return hashSet;
        }

        @Override
        public Set<File> getFiles() {
            Set<File> set = AbstractProjectDataAdapter.this.getTestFiles();
            if (set.size() < 2) {
                return set;
            }
            set.removeAll(this.getExcludedFiles());
            return set;
        }

        @Override
        public void toggleIncluded(File file) {
            Set<File> set = this.getExcludedFiles();
            if (set.contains(file)) {
                set.remove(file);
            } else {
                set.add(file);
            }
            XmlWriter xmlWriter = XmlApi.getInstance().create("file-references");
            for (File file2 : set) {
                XmlWriter xmlWriter2 = xmlWriter.createElement("file");
                xmlWriter2.writeAttribute("reference", (Object)AbstractProjectDataAdapter.this.fileToReference(file2));
            }
            try {
                AbstractProjectDataAdapter.this.fConfiguration.setParamAsXml(this.fExcludedKey, XmlApi.getInstance().read(xmlWriter.getXML()));
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }
}

