/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableContextMenuCustomizer;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.Range;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.Predicate;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;

public class AnalysisTableContextMenu
implements PropertyTableContextMenuCustomizer {
    private final PropertyTable<Variable> fTable;
    private final ConversionModel fConversionModel;
    private final Predicate<Function> fIsEntryPoint;
    private final Runnable fReset;
    private final Runnable fDataChange;
    private final Runnable fStaticAnalysisChange;
    private final int fStaticMinIndex;
    private final int fStaticMaxIndex;
    private final int fIntegerFlagIndex;
    private final int fProposedTypeIndex;

    public AnalysisTableContextMenu(PropertyTable<Variable> propertyTable, ConversionModel conversionModel, int n, int n2, int n3, int n4, Predicate<Function> predicate, Runnable runnable, Runnable runnable2, Runnable runnable3) {
        this.fConversionModel = conversionModel;
        this.fIsEntryPoint = predicate;
        this.fReset = runnable;
        this.fDataChange = runnable2;
        this.fStaticAnalysisChange = runnable3;
        this.fStaticMinIndex = n;
        this.fStaticMaxIndex = n2;
        this.fIntegerFlagIndex = n3;
        this.fProposedTypeIndex = n4;
        this.fTable = propertyTable;
    }

    public void customize(MJPopupMenu mJPopupMenu, int n, int n2) {
        final List list = this.fTable.getSelectedValues(n2);
        Variable variable = (Variable)this.fTable.getModel().getValue(n, n2);
        int n3 = mJPopupMenu.getComponentCount();
        if (n2 == this.fStaticMinIndex || n2 == this.fStaticMaxIndex) {
            MJAbstractAction mJAbstractAction = AnalysisTableContextMenu.createAction("f2f.context.copySimRange", this.hasAnySimulationRanges(list), new Runnable(){

                @Override
                public void run() {
                    AnalysisTableContextMenu.this.copySimulationRanges(list);
                }
            });
            MJAbstractAction mJAbstractAction2 = this.createCopySimRangeAction("f2f.context.copySimRangesForInputs", true, VariableKind.INPUT, VariableKind.INPUT_OUTPUT);
            MJAbstractAction mJAbstractAction3 = this.createCopySimRangeAction("f2f.context.copySimRangesForPersistents", false, VariableKind.PERSISTENT);
            MJAbstractAction mJAbstractAction4 = AnalysisTableContextMenu.createAction("f2f.context.clearDesignRange", this.hasAnyDesignRanges(list), new Runnable(){

                @Override
                public void run() {
                    AnalysisTableContextMenu.this.clearDesignRanges(list);
                }
            });
            MJAbstractAction mJAbstractAction5 = AnalysisTableContextMenu.createAction("f2f.context.clearAllDesignRanges", this.fConversionModel.hasAnyDesignRanges(), new Runnable(){

                @Override
                public void run() {
                    AnalysisTableContextMenu.this.fTable.stopEditing(false);
                    AnalysisTableContextMenu.this.fConversionModel.clearDesignRanges();
                    AnalysisTableContextMenu.this.fStaticAnalysisChange.run();
                    AnalysisTableContextMenu.this.fDataChange.run();
                }
            });
            if (variable != null) {
                mJPopupMenu.add((Action)mJAbstractAction);
            }
            mJPopupMenu.add((Action)mJAbstractAction2);
            mJPopupMenu.add((Action)mJAbstractAction3);
            if (variable != null) {
                mJPopupMenu.addSeparator();
            }
            if (variable != null) {
                mJPopupMenu.add((Action)mJAbstractAction4);
            }
            mJPopupMenu.add((Action)mJAbstractAction5);
        } else if (n2 == this.fIntegerFlagIndex) {
            MJAbstractAction mJAbstractAction = AnalysisTableContextMenu.createAction("f2f.context.restoreAllComputedValues", this.fConversionModel.getUserIntegerFlags().hasAnyValues(), new Runnable(){

                @Override
                public void run() {
                    AnalysisTableContextMenu.this.fTable.stopEditing(false);
                    AnalysisTableContextMenu.this.fConversionModel.clearUserIntegerFlags();
                    AnalysisTableContextMenu.this.fDataChange.run();
                }
            });
            if (variable != null) {
                mJPopupMenu.add((Action)this.createResetAction(list, this.fConversionModel.getUserIntegerFlags()));
            }
            mJPopupMenu.add((Action)mJAbstractAction);
        } else if (n2 == this.fProposedTypeIndex) {
            MJAbstractAction mJAbstractAction = AnalysisTableContextMenu.createAction("f2f.context.restoreAllComputedValues", this.fConversionModel.getUserProposedTypes().hasAnyValues(), new Runnable(){

                @Override
                public void run() {
                    AnalysisTableContextMenu.this.fTable.stopEditing(false);
                    AnalysisTableContextMenu.this.fConversionModel.clearUserProposedTypes();
                    AnalysisTableContextMenu.this.fDataChange.run();
                }
            });
            if (variable != null) {
                MJAbstractAction mJAbstractAction6 = AnalysisTableContextMenu.createAction("f2f.context.lockProposedType", this.hasAnyLockable(list), new Runnable(){

                    @Override
                    public void run() {
                        AnalysisTableContextMenu.this.lock(list);
                    }
                });
                mJPopupMenu.add((Action)mJAbstractAction6);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add((Action)this.createResetAction(list, this.fConversionModel.getUserProposedTypes(), this.fConversionModel.getUserOverflowActions(), this.fConversionModel.getUserRoundingMethods()));
            }
            mJPopupMenu.add((Action)mJAbstractAction);
        }
        if (mJPopupMenu.getComponentCount() != n3) {
            mJPopupMenu.addSeparator();
        }
        mJPopupMenu.add((Action)AnalysisTableContextMenu.createAction("f2f.context.clearAll", true, new Runnable(){

            @Override
            public void run() {
                AnalysisTableContextMenu.this.fReset.run();
            }
        }));
    }

    private static MJAbstractAction createAction(String string, boolean bl, final Runnable runnable) {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(CoderResources.getString(string)){

            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        };
        mJAbstractAction.setComponentName(string);
        mJAbstractAction.setEnabled(bl);
        return mJAbstractAction;
    }

    private MJAbstractAction createCopySimRangeAction(String string, final boolean bl, final VariableKind ... variableKindArray) {
        return AnalysisTableContextMenu.createAction(string, this.fConversionModel.hasSimulationRanges(), new Runnable(){

            @Override
            public void run() {
                AnalysisTableContextMenu.this.fTable.stopEditing(true);
                for (Function function : AnalysisTableContextMenu.this.fConversionModel.getFunctions()) {
                    if (bl && !AnalysisTableContextMenu.this.fIsEntryPoint.accept((Object)function)) continue;
                    for (Variable variable : AnalysisTableContextMenu.this.fConversionModel.getVariables(function)) {
                        if (!Arrays.asList(variableKindArray).contains((Object)AnalysisTableContextMenu.this.fConversionModel.getVariableKind(variable))) continue;
                        AnalysisTableContextMenu.this.fConversionModel.setDesignRange(variable, AnalysisTableContextMenu.this.fConversionModel.getSimulationRange(variable));
                    }
                }
                AnalysisTableContextMenu.this.fStaticAnalysisChange.run();
                AnalysisTableContextMenu.this.fDataChange.run();
            }
        });
    }

    private <T> MJAbstractAction createResetAction(final List<Variable> list, final MetadataTree<? extends T> ... metadataTreeArray) {
        return AnalysisTableContextMenu.createAction("f2f.context.restoreComputedValue", AnalysisTableContextMenu.hasAny(list, metadataTreeArray), new Runnable(){

            @Override
            public void run() {
                AnalysisTableContextMenu.this.fTable.stopEditing(false);
                for (Variable variable : list) {
                    for (MetadataTree metadataTree : metadataTreeArray) {
                        metadataTree.remove(variable);
                    }
                    AnalysisTableContextMenu.this.fConversionModel.updateSupportedRange(variable);
                }
                AnalysisTableContextMenu.this.fDataChange.run();
            }
        });
    }

    private void copySimulationRanges(List<Variable> list) {
        this.fTable.stopEditing(false);
        for (Variable variable : list) {
            Range range = this.fConversionModel.getSimulationRange(variable);
            if (range == null) continue;
            this.fConversionModel.setDesignRange(variable, this.fConversionModel.getSimulationRange(variable));
        }
        this.fStaticAnalysisChange.run();
        this.fDataChange.run();
    }

    private boolean hasAnySimulationRanges(List<Variable> list) {
        if (!this.fConversionModel.hasSimulationRanges()) {
            return false;
        }
        for (Variable variable : list) {
            if (this.fConversionModel.getSimulationRange(variable) == null) continue;
            return true;
        }
        return false;
    }

    private void clearDesignRanges(List<Variable> list) {
        this.fTable.stopEditing(false);
        for (Variable variable : list) {
            this.fConversionModel.clearDesignRange(variable);
        }
        this.fStaticAnalysisChange.run();
        this.fDataChange.run();
    }

    private boolean hasAnyDesignRanges(List<Variable> list) {
        for (Variable variable : list) {
            if (this.fConversionModel.getDesignRange(variable) == null) continue;
            return true;
        }
        return false;
    }

    private void lock(List<Variable> list) {
        for (Variable variable : list) {
            this.fConversionModel.setProposedType(variable, this.fConversionModel.getProposedType(variable));
        }
        this.fStaticAnalysisChange.run();
        this.fDataChange.run();
    }

    private boolean hasAnyLockable(List<Variable> list) {
        for (Variable variable : list) {
            MetadataTree<String> metadataTree = this.fConversionModel.getComputedProposedTypes();
            String string = metadataTree == null ? null : metadataTree.get(variable);
            String string2 = this.fConversionModel.getUserProposedTypes().get(variable);
            if (string == null || string2 != null) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean hasAny(List<Variable> list, MetadataTree<? extends T> ... metadataTreeArray) {
        for (Variable variable : list) {
            for (MetadataTree<T> metadataTree : metadataTreeArray) {
                if (metadataTree.get(variable) == null) continue;
                return true;
            }
        }
        return false;
    }
}

