/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapterFactory;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementStrategy;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementsModel;
import com.mathworks.toolbox.coder.fixedpoint.replace.ReplacementKey;
import com.mathworks.toolbox.coder.fixedpoint.replace.ReplacementSerializer;
import com.mathworks.toolbox.coder.mi.ConversionUtils;
import com.mathworks.toolbox.coder.model.AnnotatedMetadataTree;
import com.mathworks.toolbox.coder.model.Expression;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.MatlabType;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.NumericType;
import com.mathworks.toolbox.coder.model.Range;
import com.mathworks.toolbox.coder.model.UnifiedModel;
import com.mathworks.toolbox.coder.model.UnifiedSerializationStrategy;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.fixedpoint.FimathPanel;
import com.mathworks.util.Converter;
import com.mathworks.util.Holder;
import com.mathworks.util.ReturnRunnable;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CRC32;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class ConversionModel
extends UnifiedModel {
    public static final String DERIVED_RANGES_PROPERTY = "DerivedRanges";
    public static final String COMPUTED_PROPOSED_TYPES_PROPERTY = "ComputedProposedTypes";
    public static final String SIMULATION_RANGES_PROPERTY = "SimulationRanges";
    public static final String PROPOSED_TYPE_PROPERTY_PREFIX = "ProposedType:";
    public static final String ROUNDING_METHOD_PROPERTY_PREFIX = "RoundingMethod:";
    public static final String OVERFLOW_ACTION_PROPERTY_PREFIX = "OverflowAction:";
    public static final String FUNCTION_REPLACEMENTS_PROPERTY = "FunctionReplacements";
    public static final String DESIGN_RANGE_PREFIX = "DesignRange:";
    public static final String BUILD_ERRORS_PROPERTY = "BuildErrors";
    public static final String INTEGER_FLAG_PROPERTY = "WholeNumber";
    public static final String DEP_MODIFYING_TB_FLAG_PROPERTY = "DependencyModifyingTestBenchFlag";
    private static final String USER_CLEARED_PROPOSED_TYPE_VALUE = "";
    private MetadataTree<Range> fSimulationRanges;
    private MetadataTree<Range> fDesignRanges;
    private MetadataTree<Range> fAutoDesignRanges;
    private MetadataTree<Range> fDerivedRanges;
    private MetadataTree<Range> fSupportedRanges;
    private MetadataTree<Boolean> fSimulationOverflows;
    private FunctionReplacementsModel fFunctionReplacements;
    private FimathPanel.OverflowAction fDefaultOverflowAction = FimathPanel.OVERFLOW_ENUM_DEFAULT;
    private FimathPanel.RoundingMethod fDefaultRoundingMethod = FimathPanel.ROUNDING_ENUM_DEFAULT;
    private boolean fHasHistogram;
    private boolean fDependencyModifyingTestBenchFlag;
    private final AnnotatedMetadataTree<Boolean> fIntegerFlags;
    private final AnnotatedMetadataTree<String> fProposedTypes;
    private final AnnotatedMetadataTree<FimathPanel.RoundingMethod> fRoundingMethods;
    private final AnnotatedMetadataTree<FimathPanel.OverflowAction> fOverflowActions;
    private final ChangeListener fReplacementModelListener;
    private final ReplacementSerializer fReplacementSerializer;
    private final List<ReadWriteRequest> fReadWriteRequests;
    private final ReadWriteLock fLock;
    private volatile boolean fProcessing;

    public ConversionModel() {
        this.fDesignRanges = new MetadataTree();
        this.fAutoDesignRanges = new MetadataTree();
        this.fIntegerFlags = new AnnotatedMetadataTree();
        this.fProposedTypes = new AnnotatedMetadataTree();
        this.fRoundingMethods = new AnnotatedMetadataTree();
        this.fOverflowActions = new AnnotatedMetadataTree();
        this.fSupportedRanges = new MetadataTree();
        this.fReadWriteRequests = new ArrayList<ReadWriteRequest>();
        this.fLock = new ReentrantReadWriteLock();
        this.fReplacementModelListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ConversionModel.this.firePropertyChange(new PropertyChangeEvent(this, ConversionModel.FUNCTION_REPLACEMENTS_PROPERTY, ConversionModel.this.fFunctionReplacements, ConversionModel.this.fFunctionReplacements));
            }
        };
        this.fReplacementSerializer = ConversionModel.createMultiplexedReplacementSerializer(new ReplacementSerializer.DefaultSerializer(), new ReplacementSerializer.CompatibilitySerializer());
        this.setFunctionReplacementModel(new FunctionReplacementsModel(this));
    }

    private UnifiedSerializationStrategy.SerializationExtender createSerializationExtender(final FixedPointDataAdapter fixedPointDataAdapter) {
        return new UnifiedSerializationStrategy.SerializationExtender(){

            @Override
            public void serializeFunctionExtensions(Function function, XmlWriter xmlWriter, XmlWriter xmlWriter2, UnifiedSerializationStrategy unifiedSerializationStrategy) {
            }

            @Override
            public void serializeVariableExtensions(Variable variable, XmlWriter xmlWriter, XmlWriter xmlWriter2, UnifiedSerializationStrategy unifiedSerializationStrategy) {
                Object object;
                unifiedSerializationStrategy.setEnumConverter(FimathPanel.RoundingMethod.class, new Converter<FimathPanel.RoundingMethod, String>(){

                    public String convert(FimathPanel.RoundingMethod roundingMethod) {
                        return roundingMethod.toSyntaxString();
                    }
                });
                unifiedSerializationStrategy.setEnumConverter(FimathPanel.OverflowAction.class, new Converter<FimathPanel.OverflowAction, String>(){

                    public String convert(FimathPanel.OverflowAction overflowAction) {
                        return overflowAction.toSyntaxString();
                    }
                });
                Range range = (Range)ConversionModel.this.fDesignRanges.get(variable);
                boolean bl = false;
                if (range == null) {
                    range = (Range)ConversionModel.this.fAutoDesignRanges.get(variable);
                    bl = true;
                }
                if (range != null) {
                    unifiedSerializationStrategy.serializeProperty(xmlWriter, "DesignRangeIsAutoDefined", "Boolean", bl);
                    unifiedSerializationStrategy.serializeProperty(xmlWriter, "DesignMin", "Double", range.getMin());
                    unifiedSerializationStrategy.serializeProperty(xmlWriter, "DesignMax", "Double", range.getMax());
                }
                if (ConversionModel.this.fSimulationRanges != null && (object = (Range)ConversionModel.this.fSimulationRanges.get(variable)) != null) {
                    unifiedSerializationStrategy.serializeProperty(xmlWriter2, "SimMin", "Double", ((Range)object).getMin());
                    unifiedSerializationStrategy.serializeProperty(xmlWriter2, "SimMax", "Double", ((Range)object).getMax());
                }
                if (ConversionModel.this.fDerivedRanges != null && (object = (Range)ConversionModel.this.fDerivedRanges.get(variable)) != null) {
                    unifiedSerializationStrategy.serializeProperty(xmlWriter2, "DerivedMin", "Double", ((Range)object).getMin());
                    unifiedSerializationStrategy.serializeProperty(xmlWriter2, "DerivedMax", "Double", ((Range)object).getMax());
                }
                if (ConversionModel.this.getMatlabTypes() != null && (object = ConversionModel.this.getMatlabTypes().get(variable)) != null) {
                    unifiedSerializationStrategy.serializeMatlabType(xmlWriter2, (MatlabType)object);
                }
                unifiedSerializationStrategy.serializeAnnotatedProperty(xmlWriter2, xmlWriter, "IsInteger", "Boolean", ConversionModel.this.fIntegerFlags, variable);
                unifiedSerializationStrategy.serializeAnnotatedProperty(xmlWriter2, xmlWriter, "RoundMode", "String", ConversionModel.this.fRoundingMethods, variable);
                unifiedSerializationStrategy.serializeAnnotatedProperty(xmlWriter2, xmlWriter, "OverflowMode", "String", ConversionModel.this.fOverflowActions, variable);
                unifiedSerializationStrategy.serializeAnnotatedProperty(xmlWriter2, xmlWriter, "ProposedType", "String", ConversionModel.this.fProposedTypes, variable);
            }

            @Override
            public void serializeAdditionalExtensions(UnifiedSerializationStrategy unifiedSerializationStrategy) {
                XmlWriter xmlWriter = XmlApi.getInstance().create(ConversionModel.FUNCTION_REPLACEMENTS_PROPERTY);
                if (ConversionModel.this.fFunctionReplacements != null) {
                    ConversionModel.this.fFunctionReplacements.serialize(xmlWriter);
                }
                try {
                    fixedPointDataAdapter.setFunctionReplacements(XmlApi.getInstance().read(xmlWriter.getXML()));
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException);
                }
            }

            @Override
            public boolean shouldSerializeFunction(Function function) {
                return true;
            }

            @Override
            public boolean shouldSerializeVariable(Variable variable) {
                return true;
            }
        };
    }

    private UnifiedSerializationStrategy.DeserializationExtender createDeserializationExtender(FixedPointDataAdapter fixedPointDataAdapter) {
        return new UnifiedSerializationStrategy.DeserializationExtender(){

            @Override
            public void deserializeColumn(Function function, Variable variable, XmlReader xmlReader, boolean bl, UnifiedSerializationStrategy unifiedSerializationStrategy) {
                ConversionModel.this.deserializeValue(variable, xmlReader, bl, (Holder<Boolean>)new Holder((Object)false));
            }

            @Override
            public void deserializeColumn(Function function, XmlReader xmlReader, boolean bl, UnifiedSerializationStrategy unifiedSerializationStrategy) {
            }
        };
    }

    @Override
    protected void resetExtensions(boolean bl) {
        this.fIntegerFlags.resetComputedValues();
        this.fProposedTypes.resetComputedValues();
        this.fRoundingMethods.resetComputedValues();
        this.fOverflowActions.resetComputedValues();
        this.fSimulationRanges = null;
        this.fDerivedRanges = null;
        if (bl) {
            this.fIntegerFlags.resetUserValues();
            this.fProposedTypes.resetUserValues();
            this.fRoundingMethods.resetUserValues();
            this.fOverflowActions.resetUserValues();
            this.fDesignRanges.reset();
            this.fAutoDesignRanges.reset();
        }
    }

    @Override
    protected void transformLegacyFunction(Function function, Function function2) {
        ConversionModel.transformLegacyFunction(this.fProposedTypes, function, function2);
        ConversionModel.transformLegacyFunction(this.fIntegerFlags, function, function2);
        ConversionModel.transformLegacyFunction(this.fRoundingMethods, function, function2);
        ConversionModel.transformLegacyFunction(this.fOverflowActions, function, function2);
    }

    public void setFunctionReplacementModel(FunctionReplacementsModel functionReplacementsModel) {
        FunctionReplacementsModel functionReplacementsModel2 = this.fFunctionReplacements;
        if (functionReplacementsModel2 != null) {
            functionReplacementsModel2.removeChangeListener(this.fReplacementModelListener);
        }
        this.fFunctionReplacements = functionReplacementsModel;
        this.fFunctionReplacements.setSerializer(this.fReplacementSerializer);
        this.fFunctionReplacements.addChangeListener(this.fReplacementModelListener);
        this.firePropertyChange(FUNCTION_REPLACEMENTS_PROPERTY, functionReplacementsModel2, this.fFunctionReplacements);
    }

    @Deprecated
    public void setFunctionReplacements(Map<String, String> map) {
    }

    @Deprecated
    public Map<String, String> getFunctionReplacements() {
        return new HashMap<String, String>();
    }

    @Deprecated
    public String getReplacement(String string) {
        return this.fFunctionReplacements != null && this.fFunctionReplacements.hasFunctionReplacement(string) ? this.fFunctionReplacements.getFunctionReplacement(string).toString() : null;
    }

    public FunctionReplacementsModel getFunctionReplacementsModel() {
        return this.fFunctionReplacements;
    }

    public void setSimulationData(MetadataTree<Range> metadataTree, MetadataTree<MatlabType> metadataTree2, MetadataTree<String> metadataTree3, MetadataTree<Boolean> metadataTree4, MetadataTree<Boolean> metadataTree5, MetadataTree<FimathPanel.RoundingMethod> metadataTree6, MetadataTree<FimathPanel.OverflowAction> metadataTree7, boolean bl) {
        this.startBatchingPropertyChangeEvents();
        MetadataTree<Range> metadataTree8 = this.fSimulationRanges;
        this.fHasHistogram = bl;
        this.setMatlabTypes(metadataTree2);
        this.fSimulationRanges = metadataTree;
        this.fSimulationOverflows = metadataTree5;
        this.performComputedTypesUpdate(metadataTree3);
        this.fIntegerFlags.setComputedValues(metadataTree4);
        this.fRoundingMethods.setComputedValues(metadataTree6);
        this.fOverflowActions.setComputedValues(metadataTree7);
        this.setKeyTree(metadataTree);
        this.updateSupportedRanges();
        this.fireQueuedPropertyChanges();
        this.firePropertyChange(SIMULATION_RANGES_PROPERTY, metadataTree8, this.fSimulationRanges);
    }

    public void setDerivedRangesAndTypes(MetadataTree<Range> metadataTree, MetadataTree<MatlabType> metadataTree2, MetadataTree<String> metadataTree3, MetadataTree<Boolean> metadataTree4, MetadataTree<FimathPanel.RoundingMethod> metadataTree5, MetadataTree<FimathPanel.OverflowAction> metadataTree6) {
        MetadataTree<Range> metadataTree7 = this.fDerivedRanges;
        this.setMatlabTypes(metadataTree2);
        this.fDerivedRanges = metadataTree;
        this.performComputedTypesUpdate(metadataTree3);
        this.fIntegerFlags.setComputedValues(metadataTree4);
        this.fRoundingMethods.setComputedValues(metadataTree5);
        this.fOverflowActions.setComputedValues(metadataTree6);
        this.setKeyTree(metadataTree);
        this.updateSupportedRanges();
        this.firePropertyChange(DERIVED_RANGES_PROPERTY, metadataTree7, this.fDerivedRanges);
    }

    public boolean isDependencyModifyingTestBenchFlag() {
        return this.fDependencyModifyingTestBenchFlag;
    }

    public void setDependencyModifyingTestBenchFlag(boolean bl) {
        boolean bl2 = bl;
        this.fDependencyModifyingTestBenchFlag = bl;
        this.firePropertyChange(DEP_MODIFYING_TB_FLAG_PROPERTY, bl2, bl);
    }

    public boolean hasAnyDesignRanges() {
        return this.fDesignRanges.hasAnyValues() || this.fAutoDesignRanges.hasAnyValues();
    }

    public MetadataTree<Range> getDesignRanges() {
        return this.fDesignRanges;
    }

    public MetadataTree<Range> getAutoDesignRanges() {
        return this.fAutoDesignRanges;
    }

    public ReturnRunnable<MetadataTree<Range>> getLazyDesignRanges() {
        return new ReturnRunnable<MetadataTree<Range>>(){

            public MetadataTree<Range> run() {
                return ConversionModel.this.fDesignRanges;
            }
        };
    }

    public ReturnRunnable<MetadataTree<Range>> getLazyAutoDesignRanges() {
        return new ReturnRunnable<MetadataTree<Range>>(){

            public MetadataTree<Range> run() {
                return ConversionModel.this.fAutoDesignRanges;
            }
        };
    }

    public Range getDesignRange(FunctionScopedKey functionScopedKey) {
        Range range = this.fDesignRanges.get(functionScopedKey);
        return range != null ? range : this.fAutoDesignRanges.get(functionScopedKey);
    }

    public boolean hasAutoDesignRange(FunctionScopedKey functionScopedKey) {
        return this.fAutoDesignRanges.get(functionScopedKey) != null;
    }

    public void setDesignRange(Variable variable, Range range) {
        Range range2 = this.fDesignRanges.get(variable);
        this.fDesignRanges.put(variable, range);
        this.fAutoDesignRanges.remove(variable);
        this.firePropertyChange(DESIGN_RANGE_PREFIX + variable, range2, range);
    }

    public void setAutoDesignRange(Variable variable, Range range) {
        Range range2 = this.fAutoDesignRanges.get(variable);
        this.fAutoDesignRanges.put(variable, range);
        this.firePropertyChange(DESIGN_RANGE_PREFIX + variable, range2, range);
    }

    public void clearDesignRange(Variable variable) {
        Range range = this.fDesignRanges.get(variable);
        if (range == null) {
            range = this.fAutoDesignRanges.get(variable);
        }
        this.fDesignRanges.remove(variable);
        this.fAutoDesignRanges.remove(variable);
        if (this.fDerivedRanges != null) {
            this.fDerivedRanges.put(variable, null);
        }
        this.firePropertyChange(DESIGN_RANGE_PREFIX + variable, range, null);
    }

    public void setDerivedRange(Variable variable, Range range) {
        if (this.fDerivedRanges != null) {
            this.fDerivedRanges.put(variable, range);
        }
    }

    public void clearDesignRanges() {
        if (this.fDerivedRanges != null) {
            for (Function function : this.fDesignRanges.getFunctions()) {
                for (Variable variable : this.fDesignRanges.getKeys(function, Variable.class)) {
                    this.fDerivedRanges.put(variable, null);
                }
            }
        }
        this.fAutoDesignRanges = new MetadataTree();
        this.fDesignRanges = new MetadataTree();
    }

    public List<Variable> getVariablesWithUnavailableDesignRanges(FixedPointDataAdapter fixedPointDataAdapter) {
        List<Variable> list = this.getVariablesWithUnspecifiedDesignRanges(fixedPointDataAdapter, false);
        Iterator<Variable> iterator = list.iterator();
        while (iterator.hasNext()) {
            Variable variable = iterator.next();
            String string = this.getUserProposedTypes().get(variable);
            if (string == null) continue;
            try {
                new NumericType(string).getSupportedRange();
                iterator.remove();
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public List<Variable> getVariablesWithUnspecifiedDesignRanges(FixedPointDataAdapter fixedPointDataAdapter, boolean bl) {
        LinkedList<Variable> linkedList = new LinkedList<Variable>();
        for (Variable variable : this.getVariablesWithRequiredDesignRanges(fixedPointDataAdapter, bl)) {
            boolean bl2;
            Range range = this.getDesignRange(variable);
            if (range == null && this.getVariableKind(variable) == VariableKind.PERSISTENT) {
                range = this.getDerivedRange(variable);
            }
            if (!(bl2 = range == null || range.getMin() == null || range.getMax() == null)) continue;
            linkedList.add(variable);
        }
        return linkedList;
    }

    public List<Variable> getVariablesWithRequiredDesignRanges(FixedPointDataAdapter fixedPointDataAdapter, boolean bl) {
        LinkedList<Variable> linkedList = new LinkedList<Variable>();
        Set<File> set = fixedPointDataAdapter.getEntryPoints();
        for (Function function : this.getFunctions()) {
            for (Variable variable : this.getVariables(function)) {
                VariableKind variableKind = this.getVariableKind(variable);
                if (!function.isEntryPointFunction() || !set.contains(function.getFile()) || (variableKind == null || !variableKind.isInput()) && (!bl || variableKind != VariableKind.PERSISTENT)) continue;
                linkedList.add(variable);
            }
        }
        return linkedList;
    }

    public boolean hasSimulationRanges() {
        return this.fSimulationRanges != null;
    }

    public boolean hasHistogram() {
        return this.fHasHistogram;
    }

    public MetadataTree<Range> getSimulationRanges() {
        return this.fSimulationRanges;
    }

    public Range getSupportedRange(Variable variable) {
        return this.fSupportedRanges.get(variable);
    }

    public ReturnRunnable<MetadataTree<Range>> getLazySimulationRanges() {
        return new ReturnRunnable<MetadataTree<Range>>(){

            public MetadataTree<Range> run() {
                return ConversionModel.this.fSimulationRanges;
            }
        };
    }

    public Range getSimulationRange(FunctionScopedKey functionScopedKey) {
        return this.fSimulationRanges == null ? null : this.fSimulationRanges.get(functionScopedKey);
    }

    public boolean hasDerivedRanges() {
        return this.fDerivedRanges != null;
    }

    public MetadataTree<Range> getDerivedRanges() {
        return this.fDerivedRanges;
    }

    public ReturnRunnable<MetadataTree<Range>> getLazyDerivedRanges() {
        return new ReturnRunnable<MetadataTree<Range>>(){

            public MetadataTree<Range> run() {
                return ConversionModel.this.fDerivedRanges;
            }
        };
    }

    public Range getDerivedRange(FunctionScopedKey functionScopedKey) {
        return this.fDerivedRanges == null ? null : this.fDerivedRanges.get(functionScopedKey);
    }

    public boolean hasComputedProposedTypes() {
        return this.fProposedTypes.getComputedValues() != null;
    }

    public boolean hasAllProposedTypes() {
        if (this.getKeyTree() == null) {
            return false;
        }
        for (Function function : this.getFunctions()) {
            for (Variable variable : this.getVariables(function)) {
                if (this.getProposedType(variable) != null) continue;
                return false;
            }
        }
        return true;
    }

    public String getProposedType(FunctionScopedKey functionScopedKey) {
        return this.fProposedTypes.get(functionScopedKey);
    }

    public void setProposedType(FunctionScopedKey functionScopedKey, String string) {
        String string2 = this.getProposedType(functionScopedKey);
        this.fProposedTypes.put(functionScopedKey, false, string);
        this.updateSupportedRange(functionScopedKey);
        this.firePropertyChange(ConversionModel.createPropertyName(PROPOSED_TYPE_PROPERTY_PREFIX, functionScopedKey), string2, string);
    }

    public boolean setProposedTypeIfNotAcceptingDefault(Variable variable, String string) {
        String string2 = this.getProposedType(variable);
        boolean bl = true;
        if (string == null) {
            this.fProposedTypes.resetUserValue(variable);
        } else {
            bl = this.fProposedTypes.putIfNotAcceptingDefault(variable, string);
        }
        if (bl) {
            this.updateSupportedRange(variable);
            this.firePropertyChange(ConversionModel.createPropertyName(PROPOSED_TYPE_PROPERTY_PREFIX, variable), string2, string);
        }
        return bl;
    }

    public void clearUserProposedTypes() {
        this.fProposedTypes.resetUserValues();
        this.fRoundingMethods.resetUserValues();
        this.fOverflowActions.resetUserValues();
        this.updateSupportedRanges();
    }

    public MetadataTree<String> getUserProposedTypes() {
        return this.fProposedTypes.getUserValues();
    }

    public boolean hasSimulationOverflow(Variable variable) {
        Boolean bl = this.fSimulationOverflows == null || variable == null ? Boolean.FALSE : this.fSimulationOverflows.get(variable);
        return bl != null && bl.equals(true);
    }

    public Boolean getIntegerFlag(Variable variable) {
        return this.fIntegerFlags.get(variable);
    }

    public boolean setIntegerFlagIfNotAcceptingDefault(Variable variable, boolean bl) {
        return this.fIntegerFlags.putIfNotAcceptingDefault(variable, bl);
    }

    public MetadataTree<Boolean> getUserIntegerFlags() {
        return this.fIntegerFlags.getUserValues();
    }

    public void clearUserIntegerFlags() {
        this.fIntegerFlags.resetUserValues();
    }

    private static <T> void transformLegacyFunction(AnnotatedMetadataTree<T> annotatedMetadataTree, Function function, Function function2) {
        for (Variable variable : annotatedMetadataTree.getUserValues().getKeys(function, Variable.class)) {
            T t = annotatedMetadataTree.getUserValues().get(variable);
            annotatedMetadataTree.getUserValues().remove(variable);
            annotatedMetadataTree.put(new Variable(function2, variable.getName()), false, t);
        }
    }

    public void setComputedIntegerFlags(MetadataTree<Boolean> metadataTree) {
        MetadataTree<Boolean> metadataTree2 = this.fIntegerFlags.getComputedValues();
        this.fIntegerFlags.setComputedValues(metadataTree);
        this.firePropertyChange(INTEGER_FLAG_PROPERTY, metadataTree2, metadataTree);
    }

    public void setComputedProposedTypes(MetadataTree<String> metadataTree) {
        MetadataTree<String> metadataTree2 = this.fProposedTypes.getComputedValues();
        this.performComputedTypesUpdate(metadataTree);
        this.updateSupportedRanges();
        this.firePropertyChange(COMPUTED_PROPOSED_TYPES_PROPERTY, metadataTree2, metadataTree);
    }

    private void performComputedTypesUpdate(MetadataTree<String> metadataTree) {
        this.fProposedTypes.setComputedValues(metadataTree);
        ConversionModel.clearUserData(this.fProposedTypes, USER_CLEARED_PROPOSED_TYPE_VALUE);
    }

    private static <T> void clearUserData(AnnotatedMetadataTree<T> annotatedMetadataTree, @Nullable T t) {
        MetadataTree<T> metadataTree = annotatedMetadataTree.getUserValues();
        for (Function function : metadataTree.getFunctions()) {
            for (FunctionScopedKey<?> functionScopedKey : metadataTree.getKeys(function)) {
                T t2 = metadataTree.get(functionScopedKey);
                if (t != null && (t2 == null || !t2.equals(t))) continue;
                metadataTree.remove(functionScopedKey);
            }
        }
    }

    public MetadataTree<Boolean> getComputedIntegerFlags() {
        return this.fIntegerFlags.getComputedValues();
    }

    public MetadataTree<String> getComputedProposedTypes() {
        return this.fProposedTypes.getComputedValues();
    }

    public boolean hasExpression(Expression expression) {
        return this.fProposedTypes != null && this.fProposedTypes.get(expression) != null;
    }

    public FimathPanel.RoundingMethod getDefaultRoundingMethod(FunctionScopedKey functionScopedKey) {
        FimathPanel.RoundingMethod roundingMethod = null;
        MatlabType matlabType = this.getMatlabType(functionScopedKey);
        if (matlabType != null && matlabType.isFimathLocal() && matlabType.getFimath() != null) {
            roundingMethod = matlabType.getFimath().getRoundingMethod();
        }
        if (roundingMethod == null && this.fRoundingMethods.getComputedValues() != null) {
            roundingMethod = this.fRoundingMethods.getComputedValues().get(functionScopedKey);
        }
        return roundingMethod == null ? this.fDefaultRoundingMethod : roundingMethod;
    }

    public MetadataTree<FimathPanel.RoundingMethod> getUserRoundingMethods() {
        return this.fRoundingMethods.getUserValues();
    }

    public FimathPanel.RoundingMethod getRoundingMethod(FunctionScopedKey functionScopedKey) {
        FimathPanel.RoundingMethod roundingMethod = this.fRoundingMethods.get(functionScopedKey);
        return roundingMethod == null ? this.getDefaultRoundingMethod(functionScopedKey) : roundingMethod;
    }

    public void setRoundingMethod(FunctionScopedKey functionScopedKey, FimathPanel.RoundingMethod roundingMethod) {
        FimathPanel.RoundingMethod roundingMethod2 = this.getRoundingMethod(functionScopedKey);
        this.fRoundingMethods.put(functionScopedKey, false, roundingMethod);
        this.firePropertyChange(ConversionModel.createPropertyName(ROUNDING_METHOD_PROPERTY_PREFIX, functionScopedKey), roundingMethod2, roundingMethod);
    }

    public FimathPanel.OverflowAction getDefaultOverflowAction(FunctionScopedKey functionScopedKey) {
        FimathPanel.OverflowAction overflowAction = null;
        MatlabType matlabType = this.getMatlabType(functionScopedKey);
        if (matlabType != null && matlabType.isFimathLocal() && matlabType.getFimath() != null) {
            overflowAction = matlabType.getFimath().getOverflowAction();
        }
        if (this.fOverflowActions.getComputedValues() != null) {
            overflowAction = this.fOverflowActions.getComputedValues().get(functionScopedKey);
        }
        return overflowAction == null ? this.fDefaultOverflowAction : overflowAction;
    }

    public boolean hasSpecificOverflowAction(FunctionScopedKey functionScopedKey) {
        return this.fOverflowActions.get(functionScopedKey) != null;
    }

    public boolean hasSpecificRoundingMethod(FunctionScopedKey functionScopedKey) {
        return this.fRoundingMethods.get(functionScopedKey) != null;
    }

    public FimathPanel.OverflowAction getOverflowAction(FunctionScopedKey functionScopedKey) {
        FimathPanel.OverflowAction overflowAction = this.fOverflowActions.get(functionScopedKey);
        return overflowAction == null ? this.getDefaultOverflowAction(functionScopedKey) : overflowAction;
    }

    public MetadataTree<FimathPanel.OverflowAction> getUserOverflowActions() {
        return this.fOverflowActions.getUserValues();
    }

    public void setOverflowAction(FunctionScopedKey functionScopedKey, FimathPanel.OverflowAction overflowAction) {
        FimathPanel.OverflowAction overflowAction2 = this.getOverflowAction(functionScopedKey);
        this.fOverflowActions.put(functionScopedKey, false, overflowAction);
        this.firePropertyChange(ConversionModel.createPropertyName(OVERFLOW_ACTION_PROPERTY_PREFIX, functionScopedKey), overflowAction2, overflowAction);
    }

    public void fireQueuedPropertyChanges() {
        this.fireBatchedPropertyChangeEvents();
    }

    public void serialize(FixedPointDataAdapter fixedPointDataAdapter) {
        this.addReadWriteRequest(new ReadWriteRequest(fixedPointDataAdapter, false, true));
        this.serviceReadWriteRequest();
    }

    public void deserialize(FixedPointDataAdapter fixedPointDataAdapter, boolean bl) {
        this.addReadWriteRequest(new ReadWriteRequest(fixedPointDataAdapter, bl, false));
        this.serviceReadWriteRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReadWriteRequest(ReadWriteRequest readWriteRequest) {
        List<ReadWriteRequest> list = this.fReadWriteRequests;
        synchronized (list) {
            if (!this.fReadWriteRequests.isEmpty() && this.fReadWriteRequests.get(this.fReadWriteRequests.size() - 1).equals(readWriteRequest)) {
                ReadWriteRequest readWriteRequest2 = this.fReadWriteRequests.remove(this.fReadWriteRequests.size() - 1);
                readWriteRequest = readWriteRequest2.compareTo(readWriteRequest) > 0 ? readWriteRequest2 : readWriteRequest;
            }
            this.fReadWriteRequests.add(readWriteRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceReadWriteRequest() {
        if (this.fProcessing) {
            return;
        }
        ReadWriteRequest readWriteRequest = null;
        List<ReadWriteRequest> list = this.fReadWriteRequests;
        synchronized (list) {
            if (!this.fReadWriteRequests.isEmpty()) {
                Iterator<ReadWriteRequest> iterator = this.fReadWriteRequests.iterator();
                readWriteRequest = iterator.next();
                iterator.remove();
            }
        }
        if (readWriteRequest != null) {
            this.serviceReadWriteRequest(readWriteRequest);
            this.serviceReadWriteRequest();
        }
    }

    private void serviceReadWriteRequest(ReadWriteRequest readWriteRequest) {
        this.fProcessing = true;
        FixedPointDataAdapter fixedPointDataAdapter = readWriteRequest.getFixedPointData();
        boolean bl = readWriteRequest.isIncludeComputed();
        if (readWriteRequest.isWrite()) {
            this.fLock.readLock().lock();
            if (this.getKeyTree() != null) {
                this.serialize(ConversionModel.createFixedPointXmlSourcePolicy(fixedPointDataAdapter), this.createSerializationExtender(fixedPointDataAdapter));
            }
            this.fLock.readLock().unlock();
        } else {
            this.fLock.writeLock().lock();
            this.deserialize(ConversionModel.createFixedPointXmlSourcePolicy(fixedPointDataAdapter), this.createDeserializationExtender(fixedPointDataAdapter), bl);
            XmlReader xmlReader = fixedPointDataAdapter.getFunctionReplacements();
            if (xmlReader != null) {
                this.fFunctionReplacements.load(xmlReader);
            }
            this.updateSupportedRanges();
            this.fLock.writeLock().unlock();
        }
        this.fProcessing = false;
    }

    private void deserializeValue(Variable variable, XmlReader xmlReader, boolean bl, Holder<Boolean> holder) {
        int n;
        String string = xmlReader.readAttribute("property");
        String string2 = xmlReader.readAttribute("value");
        if (string == null) {
            n = Integer.parseInt(xmlReader.readAttribute("index"));
            if (n) {
                string = "DesignMin";
            } else if (n == 2) {
                string = "DesignMax";
            } else if (n == 3) {
                string = "IsInteger";
            } else if (n == 4) {
                string = "ProposedType";
            } else {
                return;
            }
        }
        if (string2 == null) {
            return;
        }
        if (!(bl && (string.equals("SimMin") || string.equals("SimMax")) || bl && (string.equals("DerivedMin") || string.equals("DerivedMax")))) {
            if (string.equals("DesignMin") || string.equals("DesignMax")) {
                try {
                    double d = Double.parseDouble(string2);
                    this.updateRange((Boolean)holder.get() != false ? this.fAutoDesignRanges : this.fDesignRanges, variable, string.endsWith("Min"), d);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("DesignRangeIsAutoDefined")) {
                holder.set((Object)Boolean.parseBoolean(string2));
            } else if (string.equals("IsInteger")) {
                try {
                    n = Boolean.parseBoolean(string2) ? 1 : 0;
                    this.fIntegerFlags.put(variable, bl, n != 0);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("OverflowMode") || string.equals("OverflowAction")) {
                try {
                    FimathPanel.OverflowAction overflowAction = ConversionUtils.OVERFLOW_ACTION_RESOLVER.valueOf(string2.toUpperCase(Locale.ENGLISH));
                    if (overflowAction != null) {
                        this.fOverflowActions.put(variable, bl, overflowAction);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string.equals("RoundMode") || string.equals("RoundingMethod")) {
                try {
                    FimathPanel.RoundingMethod roundingMethod = ConversionUtils.ROUNDING_METHOD_RESOLVER.valueOf(string2.toUpperCase(Locale.ENGLISH));
                    if (roundingMethod != null) {
                        this.fRoundingMethods.put(variable, bl, roundingMethod);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string.equals("ProposedType")) {
                this.fProposedTypes.put(variable, bl, ConversionModel.upgradeNumericTypeString(string2));
            } else if (string.equals("Kind")) {
                try {
                    this.getVariableKinds().put(variable, VariableKind.valueOf(string2.toUpperCase(Locale.ENGLISH)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private static String upgradeNumericTypeString(String string) {
        try {
            return new NumericType(string).toString();
        }
        catch (RuntimeException runtimeException) {
            return string;
        }
    }

    public String generateTypesChecksum(String string) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        for (Function function : this.getFunctions()) {
            for (Variable variable : this.getVariables(function)) {
                String string2 = this.getProposedType(variable);
                if (string2 == null) continue;
                cRC32.update(function.toString().getBytes());
                cRC32.update(variable.getName().getBytes());
                cRC32.update(string2.getBytes());
            }
        }
        return Long.toString(cRC32.getValue());
    }

    public String generateSourceCodeChecksum() {
        CRC32 cRC32 = new CRC32();
        TreeSet<File> treeSet = new TreeSet<File>();
        for (Function object : this.getFunctions()) {
            treeSet.add(object.getFile());
        }
        Map<File, String> map = this.getShortestPaths(treeSet);
        for (Map.Entry entry : map.entrySet()) {
            cRC32.update(((String)entry.getValue()).getBytes());
            long l = ((File)entry.getKey()).lastModified();
            long l2 = ((File)entry.getKey()).length();
            cRC32.update((int)(l >>> 32));
            cRC32.update((int)(l & 0xFFFFFFFFFFFFFFFFL));
            cRC32.update((int)(l2 >>> 32));
            cRC32.update((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
        }
        return Long.toString(cRC32.getValue());
    }

    private Map<File, String> getShortestPaths(Set<File> set) {
        HashMap<File, String> hashMap = new HashMap<File, String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (File file : set) {
            StringBuilder stringBuilder = new StringBuilder(file.getName());
            for (File file2 = file.getParentFile(); !hashSet.add(stringBuilder.toString()) && file2 != null; file2 = file2.getParentFile()) {
                stringBuilder.insert(0, file2.getName() + "/");
            }
            hashMap.put(file, stringBuilder.toString());
        }
        return hashMap;
    }

    public String generateDesignRangeChecksum() {
        CRC32 cRC32 = new CRC32();
        ConversionModel.addRangesToChecksum(this.fDesignRanges, cRC32);
        ConversionModel.addRangesToChecksum(this.fAutoDesignRanges, cRC32);
        return Long.toString(cRC32.getValue());
    }

    private static void addRangesToChecksum(MetadataTree<Range> metadataTree, CRC32 cRC32) {
        for (Function function : metadataTree.getFunctions()) {
            for (Variable variable : metadataTree.getKeys(function, Variable.class)) {
                cRC32.update(function.toString().getBytes());
                cRC32.update(variable.getName().getBytes());
                Range range = metadataTree.get(variable);
                if (range.getMin() != null) {
                    cRC32.update(Double.toString(range.getMin()).getBytes());
                }
                if (range.getMax() == null) continue;
                cRC32.update(Double.toString(range.getMax()).getBytes());
            }
        }
    }

    private void updateRange(MetadataTree<Range> metadataTree, Variable variable, boolean bl, double d) {
        Range range = metadataTree.get(variable);
        Double d2 = null;
        Double d3 = null;
        if (range != null) {
            d2 = range.getMin();
            d3 = range.getMax();
        }
        if (bl) {
            d2 = d;
        } else {
            d3 = d;
        }
        metadataTree.put(variable, new Range(d2, d3));
    }

    public static String[][] convertTypesToArray(Configuration configuration, boolean bl, boolean bl2) {
        ConversionModel conversionModel = new ConversionModel();
        FixedPointDataAdapter fixedPointDataAdapter = FixedPointDataAdapterFactory.create(configuration);
        conversionModel.updateDefaultsFromFimath(fixedPointDataAdapter.getFimath());
        conversionModel.deserialize(fixedPointDataAdapter, true);
        fixedPointDataAdapter.dispose();
        MetadataTree<String> metadataTree = bl2 ? conversionModel.getComputedProposedTypes() : conversionModel.getUserProposedTypes();
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        File file = (File)configuration.getFileSet("fileset.entrypoints").getFiles().iterator().next();
        String string = new FileLocation(file).getNameBeforeDot();
        if (metadataTree != null) {
            for (Function function : metadataTree.getFunctions()) {
                if (bl && !function.getName().equals(string)) continue;
                for (Variable variable : metadataTree.getKeys(function, Variable.class)) {
                    if (bl && (conversionModel.getVariableKind(variable) == null || !conversionModel.getVariableKind(variable).isInput())) continue;
                    String string2 = ConversionUtils.expandFixedPointType(conversionModel.getProposedType(variable));
                    if (!bl) {
                        linkedList.add(new String[]{function.toString(), variable.getName(), string2});
                        continue;
                    }
                    linkedList.add(new String[]{variable.getName(), string2});
                }
            }
        }
        return (String[][])linkedList.toArray((T[])new String[linkedList.size()][]);
    }

    public static String[][] convertTypesToArray(Configuration configuration, boolean bl) {
        return ConversionModel.convertTypesToArray(configuration, bl, true);
    }

    public void updateDefaultsFromFimath(String string) {
        Object[] objectArray = new Object[]{"fpGetFimathDefaults", string};
        CompletionObserver completionObserver = new CompletionObserver(){

            public void completed(int n, Object object) {
                Object[] objectArray = (Object[])object;
                ConversionModel.this.fDefaultRoundingMethod = Utilities.getEnumeration(objectArray[0].toString(), FimathPanel.RoundingMethod.values());
                ConversionModel.this.fDefaultOverflowAction = Utilities.getEnumeration(objectArray[1].toString(), FimathPanel.OverflowAction.values());
            }
        };
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                Object object = Matlab.mtFeval((String)"emlcprivate", (Object[])objectArray, (int)2);
                completionObserver.completed(0, object);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        } else {
            new Matlab().feval("emlcprivate", objectArray, 2, completionObserver);
        }
    }

    private void updateSupportedRanges() {
        if (this.getKeyTree() != null) {
            for (Function function : this.getKeyTree().getFunctions()) {
                for (Variable variable : this.getKeyTree().getKeys(function, Variable.class)) {
                    this.updateSupportedRange(variable);
                }
            }
        }
    }

    public void updateSupportedRange(FunctionScopedKey functionScopedKey) {
        String string = this.getProposedType(functionScopedKey);
        if (string != null) {
            try {
                this.fSupportedRanges.put(functionScopedKey, new NumericType(string).getSupportedRange());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fSupportedRanges.remove(functionScopedKey);
            }
        } else {
            this.fSupportedRanges.remove(functionScopedKey);
        }
    }

    private static UnifiedSerializationStrategy.XmlSourcePolicy createFixedPointXmlSourcePolicy(final FixedPointDataAdapter fixedPointDataAdapter) {
        return new UnifiedSerializationStrategy.XmlSourcePolicy(){

            @Override
            public void setComputedXML(XmlReader xmlReader) {
                fixedPointDataAdapter.setComputedFixedPointData(xmlReader);
            }

            @Override
            public void setAnnotatedXML(XmlReader xmlReader) {
                fixedPointDataAdapter.setUserFixedPointData(xmlReader);
            }

            @Override
            public XmlReader getComputedXML() {
                return fixedPointDataAdapter.getComputedFixedPointData();
            }

            @Override
            public XmlReader getAnnotatedXML() {
                return fixedPointDataAdapter.getUserFixedPointData();
            }

            @Override
            public String convertFileToReference(File file) {
                return fixedPointDataAdapter.fileToReference(file);
            }

            @Override
            public File convertReferenceToFile(String string) {
                return fixedPointDataAdapter.referenceToFile(string);
            }
        };
    }

    static ReplacementSerializer createMultiplexedReplacementSerializer(final ReplacementSerializer ... replacementSerializerArray) {
        return new ReplacementSerializer(){

            @Override
            public void serialize(Map<ReplacementKey, FunctionReplacementStrategy> map, XmlWriter xmlWriter) {
                for (ReplacementSerializer replacementSerializer : replacementSerializerArray) {
                    replacementSerializer.serialize(map, xmlWriter);
                }
            }

            @Override
            public Map<ReplacementKey, FunctionReplacementStrategy> deserialize(XmlReader xmlReader) {
                LinkedHashMap<ReplacementKey, FunctionReplacementStrategy> linkedHashMap = new LinkedHashMap<ReplacementKey, FunctionReplacementStrategy>();
                for (ReplacementSerializer replacementSerializer : replacementSerializerArray) {
                    linkedHashMap.putAll(replacementSerializer.deserialize(xmlReader));
                }
                return linkedHashMap;
            }
        };
    }

    private static class ReadWriteRequest
    implements Comparable<ReadWriteRequest> {
        private final FixedPointDataAdapter fFixedPointData;
        private final boolean fWrite;
        private final boolean fIncludeComputed;

        ReadWriteRequest(FixedPointDataAdapter fixedPointDataAdapter, boolean bl, boolean bl2) {
            this.fFixedPointData = fixedPointDataAdapter;
            this.fWrite = bl2;
            this.fIncludeComputed = bl;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ReadWriteRequest)) {
                return false;
            }
            ReadWriteRequest readWriteRequest = (ReadWriteRequest)object;
            if (this.fWrite != readWriteRequest.fWrite) {
                return false;
            }
            if (!this.fWrite && this.fIncludeComputed != readWriteRequest.fIncludeComputed) {
                return false;
            }
            return this.fFixedPointData.getConfiguration().getFile().equals(readWriteRequest.fFixedPointData.getConfiguration().getFile());
        }

        public int hashCode() {
            int n = this.fFixedPointData.getConfiguration().getFile().hashCode();
            n = 31 * n + (this.fWrite ? 1 : 0);
            if (!this.fWrite) {
                n = 31 * n + (this.fIncludeComputed ? 1 : 0);
            }
            return n;
        }

        @Override
        public int compareTo(ReadWriteRequest readWriteRequest) {
            if (this.equals(readWriteRequest)) {
                return 0;
            }
            if (!this.fWrite) {
                if (this.fIncludeComputed && !readWriteRequest.fIncludeComputed) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        FixedPointDataAdapter getFixedPointData() {
            return this.fFixedPointData;
        }

        boolean isWrite() {
            return this.fWrite;
        }

        boolean isIncludeComputed() {
            return this.fIncludeComputed;
        }
    }
}

