/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.util.FileSystemListener;
import com.mathworks.util.FileSystemUtils;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RequestQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.Field;
import javax.swing.SwingUtilities;

public final class ConversionStatusManager {
    private final FixedPointDataAdapter fData;
    private final ConversionModel fConversionModel;
    private final RequestQueue fRequestQueue;
    private final FileSystemListener fFileSystemListener;
    private final PropertyChangeListener fConfigurationListener;
    private final PropertyChangeListener fModelListener;
    private PropertyChangeSupport fPropertySupport;
    private volatile String fCurrentSourceCodeChecksum;
    private volatile State fState;
    public static final String NEEDS_ENTRY_POINTS_PROPERTY = "NeedsEntryPoints";
    public static final String SOURCE_CODE_OUTDATED_PROPERTY = "SourceCodeOutdated";
    public static final String NEEDS_TYPES_PROPERTY = "NeedsTypes";
    public static final String NEEDS_VALIDATION_PROPERTY = "NeedsValidation";
    public static final String CONVERSION_ENABLED_PROPERTY = "ConversionEnabled";
    public static final String NEEDS_STATIC_ANALYSIS_RERUN_PROPERTY = "NeedsStaticAnalysisRerun";
    public static final String PENDING_CHECK_PROPERTY = "PendingCheck";

    public ConversionStatusManager(FixedPointDataAdapter fixedPointDataAdapter, ConversionModel conversionModel) {
        this.fData = fixedPointDataAdapter;
        this.fConversionModel = conversionModel;
        this.fState = new State();
        this.fRequestQueue = new RequestQueue("Float-to-fixed ConversionstatusManager");
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.fFileSystemListener = new FileSystemListener(){

            public void fileCreated(File file) {
            }

            public void fileMoved(File file, File file2) {
                if (ConversionStatusManager.this.isPossiblyRelevant(file) || ConversionStatusManager.this.isPossiblyRelevant(file2)) {
                    ConversionStatusManager.this.updateCurrentSourceCodeChecksum();
                    ConversionStatusManager.this.refresh();
                }
            }

            public void fileDeleted(File file) {
                if (ConversionStatusManager.this.isPossiblyRelevant(file)) {
                    ConversionStatusManager.this.updateCurrentSourceCodeChecksum();
                    ConversionStatusManager.this.refresh();
                }
            }

            public void fileChanged(File file) {
                if (ConversionStatusManager.this.isPossiblyRelevant(file)) {
                    ConversionStatusManager.this.updateCurrentSourceCodeChecksum();
                    ConversionStatusManager.this.refresh();
                }
            }
        };
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ConversionStatusManager.this.fData.isConversionModeChange(propertyChangeEvent) || propertyChangeEvent.getPropertyName().equals(ConversionStatusManager.this.fData.getOverflowDetectionKey()) || propertyChangeEvent.getPropertyName().equals("files") && propertyChangeEvent.getSource().equals(ConversionStatusManager.this.fData.getConfiguration().getFileSet("fileset.entrypoints"))) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ConversionStatusManager.this.refresh();
                        }
                    });
                }
            }
        };
        this.fModelListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().startsWith("DesignRange:") || propertyChangeEvent.getPropertyName().startsWith("DerivedRanges")) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ConversionStatusManager.this.refreshStaticAnalysisStatus();
                        }
                    });
                }
            }
        };
        this.refresh();
        this.refreshStaticAnalysisStatus();
        FileSystemUtils.getFileSystemNotifier().addFileSystemListener(this.fFileSystemListener);
        this.fData.getConfiguration().addPropertyChangeListener(this.fConfigurationListener);
        this.fConversionModel.addPropertyChangeListener(this.fModelListener);
    }

    private void getCurrentSourceCodeChecksum(final ParameterRunnable<String> parameterRunnable) {
        if (this.fCurrentSourceCodeChecksum == null) {
            this.updateCurrentSourceCodeChecksum();
        }
        this.fRequestQueue.request(new Runnable(){

            @Override
            public void run() {
                final String string = ConversionStatusManager.this.fCurrentSourceCodeChecksum;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        parameterRunnable.run((Object)string);
                    }
                });
            }
        });
    }

    private void updateCurrentSourceCodeChecksum() {
        this.fRequestQueue.request(new Runnable(){

            @Override
            public void run() {
                ConversionStatusManager.this.fCurrentSourceCodeChecksum = ConversionStatusManager.this.fConversionModel.hasVariableNames() ? ConversionStatusManager.this.fConversionModel.generateSourceCodeChecksum() : null;
            }
        });
    }

    public void dispose() {
        FileSystemUtils.getFileSystemNotifier().removeFileSystemListener(this.fFileSystemListener);
        this.fData.getConfiguration().removePropertyChangeListener(this.fConfigurationListener);
        this.fConversionModel.removeChangeListener(this.fModelListener);
        this.fPropertySupport = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.fPropertySupport != null) {
            this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.fPropertySupport != null) {
            this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public boolean hasPendingCheck() {
        return this.fState.pendingCheck;
    }

    public boolean needsEntryPoints() {
        return this.fState.needsEntryPoints;
    }

    public boolean isSourceCodeOutdated() {
        return this.fState.sourceCodeOutdated;
    }

    public boolean needsTypes() {
        return this.fState.needsTypes;
    }

    public boolean needsValidation() {
        return this.fState.needsValidation;
    }

    public boolean needsStaticAnalysisRerun() {
        return this.fState.needsStaticAnalysisRerun;
    }

    public boolean isConversionEnabled() {
        return this.fState.conversionEnabled;
    }

    public void refreshStaticAnalysisStatus() {
        String string = this.fData.getStaticAnalysisChecksum();
        State state = this.fState.clone();
        state.needsStaticAnalysisRerun = !PlatformInfo.isMacintosh() && string != null && !string.isEmpty() && !this.fConversionModel.generateDesignRangeChecksum().equals(string);
        this.changeState(state);
    }

    public void validationSucceeded() {
        this.fRequestQueue.request(new Runnable(){

            @Override
            public void run() {
                ConversionStatusManager.this.getCurrentSourceCodeChecksum((ParameterRunnable<String>)((ParameterRunnable)new ParameterRunnable<String>(){

                    public void run(String string) {
                        ConversionStatusManager.this.fData.setSourceCodeChecksum(string);
                        ConversionStatusManager.this.fData.setValidationChecksum(ConversionStatusManager.this.fConversionModel.generateTypesChecksum(string));
                        State state = ConversionStatusManager.this.fState.clone();
                        state.sourceCodeOutdated = false;
                        state.needsValidation = false;
                        ConversionStatusManager.this.changeState(state);
                    }
                }));
            }
        });
    }

    public void validationFailed() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ConversionStatusManager.this.fData.setValidationChecksum(Double.toString(Math.random()));
                State state = ConversionStatusManager.this.fState.clone();
                state.needsValidation = true;
                ConversionStatusManager.this.changeState(state);
            }
        });
    }

    public void typesChanged(final boolean bl) {
        this.getCurrentSourceCodeChecksum(new ParameterRunnable<String>(){

            public void run(String string) {
                State state = ConversionStatusManager.this.fState.clone();
                if (bl) {
                    ConversionStatusManager.this.fData.setSourceCodeChecksum(string);
                    state.sourceCodeOutdated = false;
                }
                String string2 = ConversionStatusManager.this.fData.getValidationChecksum();
                String string3 = ConversionStatusManager.this.generateValidationChecksum(string);
                state.needsTypes = !ConversionStatusManager.this.fConversionModel.hasAllProposedTypes();
                state.needsValidation = !ConversionStatusManager.compareChecksum(string2, string3);
                ConversionStatusManager.this.changeState(state);
            }
        });
    }

    private String generateValidationChecksum(String string) {
        String string2 = this.fConversionModel.generateTypesChecksum(string);
        return string2;
    }

    public void refresh() {
        State state = new State();
        state.conversionEnabled = this.fData.isModeAutomatic();
        if (this.fData.isModeAutomatic()) {
            if (this.fData.getEntryPoints().isEmpty()) {
                state.needsEntryPoints = true;
                this.changeState(state);
            } else if (!this.fConversionModel.hasVariableNames() || !this.fConversionModel.hasAllProposedTypes()) {
                state.needsTypes = true;
                this.changeState(state);
            } else {
                state.pendingCheck = true;
                this.changeState(state);
                this.getCurrentSourceCodeChecksum(new ParameterRunnable<String>(){

                    public void run(String string) {
                        State state = new State();
                        state.conversionEnabled = ConversionStatusManager.this.fData.isModeAutomatic();
                        if (string != null) {
                            String string2 = ConversionStatusManager.this.fData.getSourceCodeChecksum();
                            state.sourceCodeOutdated = string2 != null && !ConversionStatusManager.compareChecksum(string2, string);
                            String string3 = ConversionStatusManager.this.fData.getValidationChecksum();
                            String string4 = ConversionStatusManager.this.generateValidationChecksum(string);
                            state.needsValidation = !ConversionStatusManager.compareChecksum(string3, string4);
                            ConversionStatusManager.this.changeState(state);
                        }
                    }
                });
            }
        } else {
            this.changeState(state);
        }
    }

    private static boolean compareChecksum(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && string.equals(string2);
    }

    private boolean isPossiblyRelevant(File file) {
        if (!this.fConversionModel.hasVariableNames()) {
            return true;
        }
        for (Function function : this.fConversionModel.getFunctions()) {
            if (!function.getFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    private void changeState(final State state) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                State state2 = ConversionStatusManager.this.fState;
                ConversionStatusManager.this.fState = state;
                if (ConversionStatusManager.this.fPropertySupport != null) {
                    ConversionStatusManager.this.fPropertySupport.firePropertyChange(ConversionStatusManager.CONVERSION_ENABLED_PROPERTY, state2.conversionEnabled, state.conversionEnabled);
                    ConversionStatusManager.this.fPropertySupport.firePropertyChange(ConversionStatusManager.NEEDS_ENTRY_POINTS_PROPERTY, state2.needsEntryPoints, state.needsEntryPoints);
                    ConversionStatusManager.this.fPropertySupport.firePropertyChange(ConversionStatusManager.SOURCE_CODE_OUTDATED_PROPERTY, state2.sourceCodeOutdated, state.sourceCodeOutdated);
                    ConversionStatusManager.this.fPropertySupport.firePropertyChange(ConversionStatusManager.NEEDS_TYPES_PROPERTY, state2.needsTypes, state.needsTypes);
                    ConversionStatusManager.this.fPropertySupport.firePropertyChange(ConversionStatusManager.NEEDS_VALIDATION_PROPERTY, state2.needsValidation, state.needsValidation);
                    ConversionStatusManager.this.fPropertySupport.firePropertyChange(ConversionStatusManager.NEEDS_STATIC_ANALYSIS_RERUN_PROPERTY, state2.needsStaticAnalysisRerun, state.needsStaticAnalysisRerun);
                    ConversionStatusManager.this.fPropertySupport.firePropertyChange(ConversionStatusManager.PENDING_CHECK_PROPERTY, state2.pendingCheck, state.pendingCheck);
                }
            }
        });
    }

    public String toString() {
        return this.fState.toString();
    }

    private class State
    implements Cloneable {
        boolean conversionEnabled;
        boolean needsEntryPoints;
        boolean sourceCodeOutdated;
        boolean needsTypes;
        boolean needsValidation;
        boolean needsStaticAnalysisRerun;
        boolean pendingCheck;

        private State() {
        }

        public State clone() {
            try {
                return (State)super.clone();
            }
            catch (Exception exception) {
                throw new IllegalStateException();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            boolean bl = false;
            for (Field field : this.getClass().getDeclaredFields()) {
                try {
                    if (!field.getBoolean(this)) continue;
                    bl = true;
                    stringBuilder.append(field.getName());
                    stringBuilder.append(", ");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                stringBuilder.setLength(stringBuilder.length() - 2);
            }
            return stringBuilder.toString() + ")";
        }
    }
}

