/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.coder.fixedpoint.AbstractEditableCodePopupContentView;
import com.mathworks.toolbox.coder.fixedpoint.AnalysisTable;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupFrame;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.RangeColumn;
import com.mathworks.toolbox.coder.mi.ConversionUtils;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.MetadataTreeUtils;
import com.mathworks.toolbox.coder.model.Range;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.fixedpoint.FimathPanel;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ReturnRunnable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FixedPointCodePopupContentView
extends AbstractEditableCodePopupContentView {
    private final AnalysisTable fTable;
    private final ConversionModel fModel;
    private final List<JComboBox> fComboBoxes;
    private CodePopupFrame fParentPopupFrame;

    public FixedPointCodePopupContentView(AnalysisTable analysisTable) {
        this.fTable = analysisTable;
        this.fModel = this.fTable.getConversionModel();
        this.fComboBoxes = new LinkedList<JComboBox>();
    }

    @Override
    protected JComponent doContentWidgetUpdate(FunctionScopedKey functionScopedKey, Function function) {
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new GridBagLayout());
        this.fComboBoxes.clear();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        if (this.hasMatlabType(this.getFunctionScopedKey())) {
            gridBagConstraints.insets.bottom = PlatformInfo.isMacintosh() ? 8 : 6;
            mJPanel.add((Component)FixedPointCodePopupContentView.createLabel(CoderResources.getString("f2f.popup.matlabType")), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 3;
            mJPanel.add((Component)FixedPointCodePopupContentView.createReadOnlyField("f2f.matlabType.field", this.fModel.getMatlabType(this.getFunctionScopedKey()).toString()), (Object)gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets.bottom = 3;
        }
        if (FixedPointCodePopupContentView.isEditable(this.getFunctionScopedKey()) || this.hasSimRange(this.getFunctionScopedKey())) {
            mJPanel.add((Component)FixedPointCodePopupContentView.createLabel(CoderResources.getString("f2f.popup.simulationRange")), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.addRange("f2f.sim", this.fModel.getSimulationRanges(), functionScopedKey, mJPanel, gridBagConstraints);
        }
        if (FixedPointCodePopupContentView.isEditable(this.getFunctionScopedKey()) || this.hasDerivedRange(this.getFunctionScopedKey())) {
            mJPanel.add((Component)FixedPointCodePopupContentView.createLabel(CoderResources.getString("f2f.popup.staticRange")), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            mJPanel.add((Component)this.createRangeField("f2f.staticMin.field", functionScopedKey, true, this.fModel.getDesignRanges(), this.fModel.getAutoDesignRanges(), this.fModel.getDerivedRanges()), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            mJPanel.add((Component)new MJLabel(":"), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            mJPanel.add((Component)this.createRangeField("f2f.staticMax.field", functionScopedKey, false, this.fModel.getDesignRanges(), this.fModel.getAutoDesignRanges(), this.fModel.getDerivedRanges()), (Object)gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
        }
        if (this.getFunctionScopedKey() instanceof Variable) {
            mJPanel.add((Component)FixedPointCodePopupContentView.createLabel(CoderResources.getString("f2f.popup.type")), (Object)gridBagConstraints);
            gridBagConstraints.gridwidth = 3;
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 2;
            mJPanel.add((Component)this.createProposedTypeField(functionScopedKey), (Object)gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
        }
        if (FixedPointCodePopupContentView.isEditable(this.getFunctionScopedKey()) || this.hasRoundingMethod(this.getFunctionScopedKey())) {
            mJPanel.add((Component)FixedPointCodePopupContentView.createLabel(CoderResources.getString("f2f.popup.roundingMethod")), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 3;
            mJPanel.add((Component)this.createRoundingMethodField(functionScopedKey), (Object)gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 0;
        }
        if (FixedPointCodePopupContentView.isEditable(functionScopedKey) || this.hasOverflowAction(this.getFunctionScopedKey())) {
            mJPanel.add((Component)FixedPointCodePopupContentView.createLabel(CoderResources.getString("f2f.popup.overflowAction")), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 3;
            mJPanel.add((Component)this.createOverflowActionField(functionScopedKey), (Object)gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
        }
        return mJPanel;
    }

    @Override
    public void setParentCodePopupFrame(CodePopupFrame codePopupFrame) {
        this.fParentPopupFrame = codePopupFrame;
    }

    @Override
    public boolean isContentViewFocused() {
        for (JComboBox jComboBox : this.fComboBoxes) {
            if (!jComboBox.isPopupVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean isEditable(FunctionScopedKey functionScopedKey) {
        return functionScopedKey instanceof Variable;
    }

    private FunctionScopedKey getFunctionScopedKey() {
        return this.fParentPopupFrame.getFunctionScopedKey();
    }

    private boolean hasMatlabType(FunctionScopedKey functionScopedKey) {
        return this.fModel.getMatlabType(functionScopedKey) != null;
    }

    private boolean hasSimRange(FunctionScopedKey functionScopedKey) {
        Range range = this.fModel.getSimulationRange(functionScopedKey);
        return range != null && !Double.isInfinite(range.getMin()) && !Double.isInfinite(range.getMax());
    }

    private boolean hasDerivedRange(FunctionScopedKey functionScopedKey) {
        if (this.fModel.getDesignRange(functionScopedKey) != null) {
            return true;
        }
        Range range = this.fModel.getDerivedRange(functionScopedKey);
        return range != null && !Double.isInfinite(range.getMin()) && !Double.isInfinite(range.getMax());
    }

    private boolean hasOverflowAction(FunctionScopedKey functionScopedKey) {
        return this.fModel.hasSpecificOverflowAction(functionScopedKey);
    }

    private boolean hasRoundingMethod(FunctionScopedKey functionScopedKey) {
        return this.fModel.hasSpecificRoundingMethod(functionScopedKey);
    }

    private void addRange(String string, MetadataTree<Range> metadataTree, FunctionScopedKey functionScopedKey, MJPanel mJPanel, GridBagConstraints gridBagConstraints) {
        if (metadataTree == null || metadataTree.get(functionScopedKey) == null) {
            gridBagConstraints.gridwidth = 3;
            MJLabel mJLabel = new MJLabel(CoderResources.getString("f2f.popup.notComputed"));
            mJLabel.setName(string + "Range.field");
            mJPanel.add((Component)mJLabel, (Object)gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
        } else {
            mJPanel.add((Component)FixedPointCodePopupContentView.createReadOnlyField(string + "Min.field", this.getMin(metadataTree)), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            mJPanel.add((Component)new MJLabel(":"), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            mJPanel.add((Component)FixedPointCodePopupContentView.createReadOnlyField(string + "Max.field", this.getMax(metadataTree)), (Object)gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
    }

    private String getMin(MetadataTree<Range> metadataTree) {
        if (metadataTree == null) {
            return CoderResources.getString("f2f.popup.unknown");
        }
        Range range = metadataTree.get(this.getFunctionScopedKey());
        return range == null ? CoderResources.getString("f2f.popup.unknown") : RangeColumn.format(range.getMin());
    }

    private String getMax(MetadataTree<Range> metadataTree) {
        if (metadataTree == null) {
            return CoderResources.getString("f2f.popup.unknown");
        }
        Range range = metadataTree.get(this.getFunctionScopedKey());
        return range == null ? CoderResources.getString("f2f.popup.unknown") : RangeColumn.format(range.getMax());
    }

    private MJTextField createRangeField(String string, final FunctionScopedKey functionScopedKey, final boolean bl, final MetadataTree<Range> ... metadataTreeArray) {
        MJTextField mJTextField = this.createTextField(FixedPointCodePopupContentView.isEditable(functionScopedKey), new ParameterRunnable<String>(){

            public void run(String string) {
                try {
                    Double d = string.trim().length() == 0 ? null : Double.valueOf(Double.parseDouble(string));
                    Range range = (Range)metadataTreeArray[0].get(functionScopedKey);
                    Double d2 = null;
                    Double d3 = null;
                    if (range != null) {
                        d2 = range.getMin();
                        d3 = range.getMax();
                    }
                    if (bl) {
                        d2 = d;
                    } else {
                        d3 = d;
                    }
                    metadataTreeArray[0].put(functionScopedKey, new Range(d2, d3));
                    FixedPointCodePopupContentView.this.fTable.dataChanged();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        mJTextField.setName(string);
        mJTextField.setColumns(6);
        Double d = MetadataTreeUtils.get(bl, functionScopedKey, metadataTreeArray);
        if (d != null) {
            mJTextField.setText(Double.toString(d));
            if (mJTextField.getText().endsWith(".0")) {
                mJTextField.setText(mJTextField.getText().substring(0, mJTextField.getText().length() - 2));
            }
        }
        mJTextField.setCaretPosition(0);
        if (!FixedPointCodePopupContentView.isEditable(functionScopedKey)) {
            mJTextField.setEditable(false);
            mJTextField.setBorder(null);
        }
        return mJTextField;
    }

    private MJTextField createProposedTypeField(final FunctionScopedKey functionScopedKey) {
        MJTextField mJTextField = this.createTextField(FixedPointCodePopupContentView.isEditable(functionScopedKey), new ParameterRunnable<String>(){

            public void run(String string) {
                FixedPointCodePopupContentView.this.fModel.setProposedType(functionScopedKey, ConversionUtils.contractFixedPointType(string));
            }
        });
        String string = this.fModel.getProposedType(functionScopedKey);
        if (string != null) {
            mJTextField.setText(ConversionUtils.expandFixedPointType(string));
        }
        mJTextField.setName("f2f.proposedType.field");
        mJTextField.setCaretPosition(0);
        return mJTextField;
    }

    private MJTextField createTextField(boolean bl, final ParameterRunnable<String> parameterRunnable) {
        final MJTextField mJTextField = new MJTextField();
        mJTextField.removeContextMenu();
        if (!bl) {
            mJTextField.setBorder(null);
            mJTextField.setEditable(false);
        }
        if (!PlatformInfo.isMacintosh() || !bl) {
            mJTextField.setBackground(CodePopupFrame.BACKGROUND);
        }
        mJTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Timer timer = new Timer(100, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        mJTextField.selectAll();
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
        });
        mJTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FixedPointCodePopupContentView.this.pushCommitRequest(new AbstractEditableCodePopupContentView.CommitContext(){

                    @Override
                    public String getValue() {
                        return mJTextField.getText();
                    }

                    @Override
                    public Object getKey() {
                        return mJTextField;
                    }

                    @Override
                    public ParameterRunnable<String> getParameterRunnable() {
                        return parameterRunnable;
                    }
                });
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        return mJTextField;
    }

    private JComponent createRoundingMethodField(final FunctionScopedKey functionScopedKey) {
        return this.createEnumField(FixedPointCodePopupContentView.isEditable(functionScopedKey), FimathPanel.RoundingMethod.values(), this.fModel.getDefaultRoundingMethod(functionScopedKey), "f2f.roundingMethod.combo", new ReturnRunnable<FimathPanel.RoundingMethod>(){

            public FimathPanel.RoundingMethod run() {
                return FixedPointCodePopupContentView.this.fModel.getRoundingMethod(functionScopedKey);
            }
        }, new ParameterRunnable<FimathPanel.RoundingMethod>(){

            public void run(FimathPanel.RoundingMethod roundingMethod) {
                FixedPointCodePopupContentView.this.fModel.setRoundingMethod(functionScopedKey, roundingMethod);
            }
        });
    }

    private JComponent createOverflowActionField(final FunctionScopedKey functionScopedKey) {
        return this.createEnumField(FixedPointCodePopupContentView.isEditable(functionScopedKey), FimathPanel.OverflowAction.values(), this.fModel.getDefaultOverflowAction(functionScopedKey), "f2f.overflowAction.combo", new ReturnRunnable<FimathPanel.OverflowAction>(){

            public FimathPanel.OverflowAction run() {
                return FixedPointCodePopupContentView.this.fModel.getOverflowAction(functionScopedKey);
            }
        }, new ParameterRunnable<FimathPanel.OverflowAction>(){

            public void run(FimathPanel.OverflowAction overflowAction) {
                FixedPointCodePopupContentView.this.fModel.setOverflowAction(functionScopedKey, overflowAction);
            }
        });
    }

    private <T> JComponent createEnumField(boolean bl, T[] TArray, final T t, String string, ReturnRunnable<T> returnRunnable, final ParameterRunnable<T> parameterRunnable) {
        if (!bl) {
            return FixedPointCodePopupContentView.createReadOnlyField(string, returnRunnable.run().toString());
        }
        final JComboBox<?> jComboBox = this.fParentPopupFrame.createTransparencySafeComboBox();
        jComboBox.setName(string);
        for (T t2 : TArray) {
            jComboBox.addItem(t2);
        }
        jComboBox.setSelectedItem(returnRunnable.run());
        if (!jComboBox.getSelectedItem().equals(t)) {
            jComboBox.setFont(jComboBox.getFont().deriveFont(1));
        }
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                try {
                    if (jComboBox.isPopupVisible()) {
                        this.setFont(this.getFont().deriveFont(0));
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return component;
            }
        });
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!FixedPointCodePopupContentView.this.isSuppressCommit()) {
                    parameterRunnable.run(jComboBox.getSelectedItem());
                }
                if (!jComboBox.getSelectedItem().equals(t)) {
                    jComboBox.setFont(jComboBox.getFont().deriveFont(1));
                } else {
                    jComboBox.setFont(jComboBox.getFont().deriveFont(0));
                }
            }
        });
        this.fComboBoxes.add(jComboBox);
        return jComboBox;
    }

    private static MJLabel createLabel(String string) {
        MJLabel mJLabel = new MJLabel(string);
        mJLabel.setForeground(Color.DARK_GRAY);
        mJLabel.setFont(mJLabel.getFont().deriveFont(1));
        return mJLabel;
    }

    private static MJTextField createReadOnlyField(String string, String string2) {
        MJTextField mJTextField = new MJTextField(string2);
        mJTextField.setBorder(null);
        mJTextField.setEditable(false);
        mJTextField.setOpaque(false);
        mJTextField.setName(string);
        return mJTextField;
    }
}

