/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.toolbox.coder.app.FindAdapter;
import com.mathworks.toolbox.coder.app.PopupBarManager;
import com.mathworks.toolbox.coder.app.PopupHintProvider;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.ConversionStatusManager;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ReturnRunnable;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FixedPointHintProvider
implements PopupHintProvider {
    private final PopupBarManager fManager;
    private final ConversionModel fModel;
    private final ConversionStatusManager fStatus;
    private final PropertyChangeListener fModelListener;
    private final PropertyChangeListener fStatusListener;
    private final MulticastChangeListener fChangeListeners;

    public FixedPointHintProvider(PopupBarManager popupBarManager, ConversionModel conversionModel, ConversionStatusManager conversionStatusManager, Window window, Component component, FindAdapter findAdapter, ReturnRunnable<Point> returnRunnable) {
        this.fManager = popupBarManager;
        this.fModel = conversionModel;
        this.fStatus = conversionStatusManager;
        this.fChangeListeners = new MulticastChangeListener();
        this.fModelListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (FixedPointHintProvider.this.fManager.getState() == PopupBarManager.State.INITIAL_HINT && (FixedPointHintProvider.this.fModel.hasSimulationRanges() || FixedPointHintProvider.this.fModel.hasDerivedRanges())) {
                    FixedPointHintProvider.this.fManager.closePopup();
                }
            }
        };
        this.fModel.addPropertyChangeListener(this.fModelListener);
        this.fStatusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FixedPointHintProvider.this.fChangeListeners.stateChanged(new ChangeEvent(FixedPointHintProvider.this));
            }
        };
        this.fStatus.addPropertyChangeListener(this.fStatusListener);
    }

    @Override
    public String getCurrentHint() {
        if (this.fStatus.isSourceCodeOutdated() && !this.fStatus.hasPendingCheck()) {
            return CoderResources.getString("f2f.hint.outdatedCode");
        }
        if (this.fStatus.needsStaticAnalysisRerun() && this.fModel.hasDerivedRanges()) {
            return CoderResources.getString("f2f.hint.needsStaticAnalysisRerun");
        }
        return null;
    }

    @Override
    public void dispose() {
        this.fModel.removeChangeListener(this.fModelListener);
        this.fStatus.removePropertyChangeListener(this.fStatusListener);
    }

    @Override
    public String getInitialHint() {
        if (!this.fModel.hasAllProposedTypes()) {
            return CoderResources.getString(PlatformInfo.isMacintosh() ? "f2f.hint.ranges.mac" : "f2f.hint.ranges");
        }
        return null;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }
}

