/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.ConversionStatusManager;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointToolPanel;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;

public final class FixedPointTool {
    private final JFrame fDialog;
    private final FixedPointToolPanel fPanel;
    private static FixedPointTool sInstance;

    public static void show(FixedPointDataAdapter fixedPointDataAdapter, ConversionModel conversionModel, ConversionStatusManager conversionStatusManager, File file) {
        if (sInstance == null) {
            sInstance = new FixedPointTool(fixedPointDataAdapter, conversionModel, conversionStatusManager, file);
        }
        FixedPointTool.sInstance.fDialog.show();
    }

    public static FixedPointTool getInstance() {
        return sInstance;
    }

    public static void close() {
        if (sInstance != null) {
            sInstance.dispose();
            sInstance = null;
        }
    }

    public FixedPointToolPanel getPanel() {
        return this.fPanel;
    }

    private FixedPointTool(FixedPointDataAdapter fixedPointDataAdapter, ConversionModel conversionModel, ConversionStatusManager conversionStatusManager, File file) {
        sInstance = this;
        this.fDialog = new MJFrame(CoderResources.getString("f2f.dialog.main") + " - " + fixedPointDataAdapter.getConfiguration().getFile().getName());
        this.fDialog.setName("dialog.fixedpoint");
        this.fDialog.setLayout(new BorderLayout(0, 0));
        GlassPaneManager glassPaneManager = new GlassPaneManager(this.fDialog.getRootPane());
        this.fPanel = new FixedPointToolPanel(this.fDialog, glassPaneManager, fixedPointDataAdapter, conversionStatusManager, conversionModel, file);
        this.fPanel.activate();
        this.fDialog.getGlassPane().setVisible(true);
        this.fDialog.getGlassPane().repaint();
        this.fDialog.add((Component)this.fPanel.getComponent(), "Center");
        this.fDialog.setSize((int)Math.min(WindowUtils.getScreenBounds().getWidth(), 980.0), (int)Math.min(WindowUtils.getScreenBounds().getHeight(), 770.0));
        this.fDialog.setMinimumSize(this.fDialog.getSize());
        WindowUtils.centerWindowOnScreen((Window)this.fDialog);
        this.fDialog.setVisible(true);
        this.fDialog.addWindowListener(new CloseListener());
    }

    private void dispose() {
        this.fPanel.dispose();
        this.fDialog.dispose();
    }

    static {
        MJUtilities.initJIDE();
    }

    private static class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (sInstance != null) {
                sInstance.dispose();
            }
            sInstance = null;
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.windowClosing(windowEvent);
        }
    }
}

