/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.GenericArtifact;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public final class GlobalFixedPointRegistry {
    public static final String CODER_STRING = GenericArtifact.C.toString();
    public static final String HDL_CODER_STRING = GenericArtifact.HDL.toString();
    public static final String FIXED_POINT_DESIGNER_STRING = GenericArtifact.FIXED_POINT.toString();
    private static final GlobalFixedPointRegistry SINGLETON = new GlobalFixedPointRegistry(false);
    private final Map<File, FixedPointInstance> fInstances;
    private final Object fMutex;
    private final boolean fAllowMultiple;

    private GlobalFixedPointRegistry(boolean bl) {
        this.fAllowMultiple = bl;
        this.fInstances = new LinkedHashMap<File, FixedPointInstance>();
        this.fMutex = new Object();
    }

    public static GlobalFixedPointRegistry getInstance() {
        return SINGLETON;
    }

    public static boolean isProjectActive(File file) {
        return GlobalFixedPointRegistry.getInstance().isActive(file);
    }

    public static boolean isUnified(File file) {
        FixedPointInstance fixedPointInstance = GlobalFixedPointRegistry.getInstance().getFixedPointInstance(file);
        return fixedPointInstance != null && fixedPointInstance.isUnifiedGui();
    }

    public static String getProductTypeString(File file) {
        FixedPointInstance fixedPointInstance = GlobalFixedPointRegistry.getInstance().getFixedPointInstance(file);
        return fixedPointInstance != null ? fixedPointInstance.getProductString() : "";
    }

    public static GenericArtifact getProductType(File file) {
        FixedPointInstance fixedPointInstance = GlobalFixedPointRegistry.getInstance().getFixedPointInstance(file);
        return fixedPointInstance != null ? fixedPointInstance.getProduct() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(FixedPointDataAdapter fixedPointDataAdapter) {
        Object object = this.fMutex;
        synchronized (object) {
            return this.isActive(GlobalFixedPointRegistry.getFileFromDataAdapter(fixedPointDataAdapter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isActive(File file) {
        Object object = this.fMutex;
        synchronized (object) {
            return this.fInstances.containsKey(file);
        }
    }

    public FixedPointInstance getFixedPointInstance(FixedPointDataAdapter fixedPointDataAdapter) {
        return this.getFixedPointInstance(GlobalFixedPointRegistry.getFileFromDataAdapter(fixedPointDataAdapter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedPointInstance getFixedPointInstance(File file) {
        Object object = this.fMutex;
        synchronized (object) {
            return this.fInstances.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FixedPointInstance> getActiveFixedPointContexts() {
        Object object = this.fMutex;
        synchronized (object) {
            return new LinkedList<FixedPointInstance>(this.fInstances.values());
        }
    }

    public boolean isAllowMultiple() {
        return this.fAllowMultiple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstance(FixedPointDataAdapter fixedPointDataAdapter, CoderApp coderApp) {
        MJUtilities.assertEventDispatchThread();
        this.closeActiveIfNecessary();
        Object object = this.fMutex;
        synchronized (object) {
            FixedPointInstance fixedPointInstance = this.createContextObject(fixedPointDataAdapter, coderApp);
            this.fInstances.put(fixedPointInstance.getFile(), fixedPointInstance);
        }
    }

    public void registerInstance(FixedPointDataAdapter fixedPointDataAdapter) {
        this.registerInstance(fixedPointDataAdapter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstance(FixedPointDataAdapter fixedPointDataAdapter) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fInstances.remove(GlobalFixedPointRegistry.getFileFromDataAdapter(fixedPointDataAdapter));
        }
    }

    private FixedPointInstance createContextObject(FixedPointDataAdapter fixedPointDataAdapter, CoderApp coderApp) {
        GenericArtifact genericArtifact = null;
        genericArtifact = coderApp != null ? (coderApp.getModel().getGenericArtifact() == GenericArtifact.HDL ? GenericArtifact.HDL : (coderApp.getModel().getGenericArtifact() == GenericArtifact.C ? GenericArtifact.C : GenericArtifact.FIXED_POINT)) : (fixedPointDataAdapter.getConfiguration().getTargetKey().contains("hdl") ? GenericArtifact.HDL : GenericArtifact.C);
        return new FixedPointInstance(fixedPointDataAdapter, genericArtifact, coderApp);
    }

    private static File getFileFromDataAdapter(FixedPointDataAdapter fixedPointDataAdapter) {
        return fixedPointDataAdapter.getConfiguration().getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeActiveIfNecessary() {
        FixedPointInstance fixedPointInstance;
        MJUtilities.assertEventDispatchThread();
        Object object = this.fMutex;
        synchronized (object) {
            if (this.isAllowMultiple() || this.fInstances.isEmpty()) {
                return;
            }
            fixedPointInstance = this.fInstances.values().iterator().next();
        }
        if (fixedPointInstance.isUnifiedGui()) {
            fixedPointInstance.getApp().close();
        } else {
            object = ProjectGUI.getInstance().getCurrentProject();
            if (object != null && object.getFile().equals(fixedPointInstance.getData().getConfiguration().getFile())) {
                ProjectGUI.getInstance().closeCurrentProject();
            }
        }
    }

    public static final class FixedPointInstance {
        private final FixedPointDataAdapter fData;
        private final GenericArtifact fProduct;
        private final CoderApp fApp;

        private FixedPointInstance(FixedPointDataAdapter fixedPointDataAdapter, GenericArtifact genericArtifact, CoderApp coderApp) {
            this.fData = fixedPointDataAdapter;
            this.fApp = coderApp;
            this.fProduct = genericArtifact;
        }

        public File getFile() {
            return GlobalFixedPointRegistry.getFileFromDataAdapter(this.getData());
        }

        public FixedPointDataAdapter getData() {
            return this.fData;
        }

        public String getProductString() {
            return this.fProduct.toString();
        }

        public GenericArtifact getProduct() {
            return this.fProduct;
        }

        public boolean isUnifiedGui() {
            return this.getApp() != null;
        }

        private CoderApp getApp() {
            return this.fApp;
        }
    }
}

